<?php

//*********************************************************
// Access key / make public
//*********************************************************

function makeMyAccessKeyPublic(&$error)
{
	global $regdir,$myuserid,$myprivatekey;
	return makeAccessKeyPublic($myuserid,$myprivatekey,$error);
}

function makeAccessKeyPublic($userid,$userprivatekey,&$error)
{
	global $regdir;
	$filename = "$regdir/$userid/accesskey.txt";
	if (file_exists($filename)) return true;

	if (!loadAccessKeyOfUser($userid,$userprivatekey,$accesskey,$error))
	{
		$error = "Cannot make access key public. ".$error;
		return false;
	}

	//Save the access key
	if (!ozsavefile($filename,$accesskey,$error)) 
	{
		$error = "Cannot make access key public. Cannot save access key ".$error;
		return false;
	}

	return true;
}

function loadAccessKeyOfUser($userid,$userprivatekey,&$accesskey,&$error)
{
	global $regdir;

	if (!is_resource($userprivatekey) && !is_object($userprivatekey))
	{
		$error = "Invalid private key provided.";
		return false;
	}

	//Get aes key of user id
	$aessharedfile = "$regdir/$userid/aesshared.txt";
	$aessharedencrypted = file_get_contents($aessharedfile);
	if (!decryptTextRSA($userprivatekey,$aessharedencrypted,$aesshared,$error))
	{
		$error = "Cannot decrypt aes shared key of user. ".$error;
		return false;
	}
	
	//Load registration details of user id
	$filename = "$regdir/$userid/registration.txt";
	if (!ozloadencryptedjson($aesshared,$filename,$userdetails,$error))
	{
		$error = "Cannot load registration details of user. ".$error;
		return false;
	}

	//Return the access key
	$accesskey = $userdetails["accesskey"];
	return true;
}

//*********************************************************
// Share access key / make public
//*********************************************************
function shareMyAccessKeyTo($sharetoid,&$error)
{
	global $myuserid,$myprivatekey;
	return shareAccessKey($myuserid,$myprivatekey,$sharetoid,$error);
}

function shareAccessKey($userid,$userprivatekey,$sharedtoid,&$error)
{
	global $regdir;

	$filename = "$regdir/$userid/sharedto/$sharedtoid"."_accesskey.txt";
	if (file_exists($filename))
	{
		return true;
	}

	if (!userExists($sharedtoid) || !userExists($userid))
	{
		$error = "Cannot share access key. User does not exist.";
		return false;
	}

	if (!loadAccessKeyOfUser($userid,$userprivatekey,$accesskey,$error))
	{
		$error = "Cannot share access key. Accesskey not loaded. ".$error;
		return false;
	}

	if (!ozloadrsapublickeyof($sharedtoid,$publickeyofsharedtoid,$error))
	{
		$error = "Cannot share access key. Public key not loaded. ".$error;
		return false;
	}

	$encryptedAccessKey = encryptTextRSA($publickeyofsharedtoid,$accesskey);
	//Save the access key
	if (!ozsavefile($filename,$encryptedAccessKey,$error)) 
	{
		$error = "Cannot share access key. Shared file could not be saved. ".$error;
		return false;
	}

	return true;
}

function loadSharedAccessKeyOf($userid,$sharedtoid,$sharedtoprivatekey,&$accesskey,&$error)
{
	global $regdir,$myuserid,$myaccesskey;
	$debug = false;
	if ($debug) {echo "<hr>Looking for the access key of $userid. Shared to: $sharedtoid. <BR>";}

	//Return my access key
	if ($userid == $myuserid && $sharedtoid==$myuserid)
	{
		$accesskey = $myaccesskey;
		return true;
	}

	//Load public access key
	if ($debug) {echo "Checking public access key for $userid <BR>";}
	$filename = "$regdir/$userid/accesskey.txt";
	if (ozreadfile($filename,$accesskey,$error)) 
	{
		if ($debug) {echo "Found public access key for $userid <BR>";}
		return true;
	}

	//Load owner access key	
	if ($debug) {echo "Checking if I am looking for my own access key $sharedtoid = $userid <BR>";}
	if ($userid==$sharedtoid)
	{
		if ($debug) {echo "Found my own access key for $userid <BR>";}
		return loadAccessKeyOfUser($userid,$sharedtoprivatekey,$accesskey,$error);
	}

	//Load directly shared access key 
	$filename = "$regdir/$userid/sharedto/$sharedtoid"."_accesskey.txt";
	if ($debug) {echo "Checking directly shared access key $filename <BR>";}
	if (ozreadfile($filename,$encrytpedaccesskey,$error))
	{
		if ($debug) {echo "Found directly shared access key for $userid. Shared to $sharedtoid.<BR>";}
		if (!decryptTextRSA($sharedtoprivatekey,$encrytpedaccesskey,$accesskey,$error))
		{
			$error = "Cannot load shared access key. Decryption error. $error";
			return false;
		}
		return true;
	}

	//Load access key from shared registration details
	if ($debug) {echo "Checking registration details for shared access key<BR>";}
	if (ozloadaessharedkeyofuser($userid,$sharedtoid,$sharedtoprivatekey,$aeskey,$error))
	{
		if ($debug) {echo "Found shared registration details.<BR>";}
		$filename = "$regdir/$userid/registration.txt";
		if (!ozloadencryptedjson($aeskey,$filename,$userdetails,$error))
		{
			$error = "Cannot load shared access key. User details error. $error";
			return false;
		}
		$accesskey = $userdetails["accesskey"];
		return true;
	}
	
	//Load access key with shared private key
	if ($debug) {echo "Checking private key for shared access key<BR>";}
	if (ozloadrsaprivatekeyof($userid,$rsaprivatekeyofuserid,$error))
	{
		return loadAccessKeyOfUser($userid,$rsaprivatekeyofuserid,$accesskey,$error);
	}

	if ($debug) {echo "Not found access key.<BR>";}
	$error = "Cannot load shared access key of $userid. Key not shared to $sharedtoid.";
	return false;
}

//*************************************************
// Access key / load shared to me
//*************************************************

function loadAccessKeyOf($userid, &$accesskey,&$error)
{
	global $regdir,$myuserid,$myprivatekey,$debug;

	//Load shared access key
	return loadSharedAccessKeyOf($userid,$myuserid,$myprivatekey,$accesskey,$error);
}

?>
