#!/usr/bin/php
<?php
function ozlsdirc($path, &$files, &$dirs, &$error)
{
        if (!is_dir($path))
        {
                $error = "Directory does not exist; ".$path;
                return false;
        }

        $dirs = array();
        $files = array();
        $dir = new DirectoryIterator($path);
        $x=0;
        foreach ($dir as $fileinfo) {

            if ($x++>500000) return true;
            if ($fileinfo->isDot()) { continue; }
                if ($fileinfo->isDir())
                {
                        $dirs[] = $fileinfo->getFilename();
                        continue;
                }
            $files[] = $fileinfo->getFilename();
        }
        return true;
}

function ozreadjsonc($f,&$jsondecoded,&$error)
{
    if (!file_exists($f))
        {
                $error = "File does not exists;";
                $content = "";
                return false;
        }

        if (($content = @file_get_contents($f)) === false)
        {
                $error = error_get_last();
            return false;
        }

        $jsondecoded = json_decode($content,true);
        if ($jsondecoded==null)
        {
                $error = "JSON data empty. $f";
                return false;
        }
        return true;
}

$path = "/root/my/ozekidata/sessions/browser";
if (!ozlsdirc($path, $files, $dirs, $error))
{
        echo "Cannot list dir ".$error; exit;
}

$d90 = strtotime("-90 days");
$d30 = strtotime("-30 days");
$d10 = strtotime("-10 days");
$d3 = strtotime("-3 days");
$x=0;

foreach($files as $file)
{
        $f = "$path/$file";
        $x++;
        echo "$x. $f\r\n";
        if (!ozreadjsonc($f,$jsondecoded,$error)) {
                echo "  Invalid content. \r\n";
                exit;
        }
        $time = strtotime($jsondecoded["BrowserLastTouch"]);

        if (!array_key_exists("loginsessionkey",$jsondecoded))
        {
                echo "  No loginsessionkey. \r\n";
                if ($time<$d3)
                {
                    echo "  Older then 3 days. \r\n";
                    unlink($f);
                    echo "  Deleted.\r\n";
                }
                continue;
        }
        else if ($jsondecoded["loginsessionkey"] == "logout")
        {
                echo "  Logged out at ".$jsondecoded["BrowserLastTouch"]." \r\n";
                if($time<$d3)
                {
                    echo "  Older then 3 days. \r\n";
                    unlink($f);
                    echo "  Deleted.\r\n";
                }
                continue;
        }
        else
        {
                echo "  Login session key found: ".$jsondecoded["loginsessionkey"]."\r\n";
                if($time<$d90)
                {
                     echo "  Last touch older then 90 days: ".$jsondecoded["BrowserLastTouch"]."\r\n";
                }
                echo "  Preserved.\r\n";
        }

        var_dump($jsondecoded);
}


?>
