<?php
$debugsession = false;
if (!$sessionsenabled) return;

//**********************************************************
// User ID cookie
//**********************************************************
$logincookiename = "ozekiaccount";

//**********************************************************
// Exclude Non authenticated Ozeki website user from session management
//**********************************************************
if (isset($mainsite) && $mainsite && !isset($_COOKIE[$logincookiename]) && !isset($_POST["registrationview"]) && !isset($_POST["setsessionid"])) return;

//**********************************************************
// Exclude Ozeki 10 clients from session management
//**********************************************************
if (isset($_SERVER['HTTP_USER_AGENT']) && ozstartswith($_SERVER['HTTP_USER_AGENT'],'OZEKI 10')) return;

//**********************************************************
// Session debug
//**********************************************************
if (isOzeki10Debug())
{
	//$debugsession = true;
}

//**********************************************************
// Session support function
//**********************************************************

function addSessionData($dataname, $datavalue, $save=true)
{
	global $$dataname,$debugsession;
	$$dataname = $datavalue;
	global $browsersession;
	$browsersession[$dataname] = $datavalue;
	if ($save) saveBrowserSession();
}

function getSessionData($dataname,$default)
{
	global $browsersession;
	if (array_key_exists($dataname,$browsersession)) 
	{
		return $browsersession[$dataname];
	}
	return $default;
}

function delSessionData($dataname, $save=true)
{
	global $$dataname,$debugsession,$browsersession;
	$$dataname = "";
	unset($browsersession[$dataname]);
	if ($save) saveBrowserSession();
}

function saveBrowserSession()
{
	global $browsersession,$sessionfilebrowser;
	if (isEmpty($sessionfilebrowser)) return;
	$serialized = json_encode($browsersession);
	file_put_contents($sessionfilebrowser,$serialized,LOCK_EX);
}

function createBrowserSession()
{
	global $accesstoken;
	if (!isEmpty($accesstoken)) return;
	$accesstoken = time()."_".ozrndstr()."_".$_SERVER["REMOTE_ADDR"];
	$accesstoken = str_replace(":","_",$accesstoken);
	ozfilenamesafe($accesstoken, $safeaccesstoken, $error);
	$safeaccesstoken = $accesstoken;
	setupBrowserSession();
}

function setupBrowserSession()
{
	global $accesstoken,$safeaccesstoken,$sessionfilebrowser,$sessionrootbrowser;
	ozfilenamesafe($accesstoken, $safeaccesstoken , $error);
	if (!is_dir($sessionrootbrowser)) ozmkdir($sessionrootbrowser,$error);
	$sessionfilebrowser = $sessionrootbrowser ."/".$safeaccesstoken;
}

function destroyBrowserSession()
{
	global $browsersession;
	if (!is_array($browsersession)) return;
	$keys = array_keys($browsersession);
	foreach ($keys as $key)
	{
		if ($key=="BrowserID") continue;
		if ($key=="BrowserCreated") continue;
		if ($key=="BrowserLastTouch") continue;
		if ($key=="VisitorIPs") continue;
		if ($key=="VisitorIP") continue;
		if ($key=="UserAgent") continue;
		if ($key=="VisitorHost") continue;
		if ($key=="LastRequest") continue;
		if ($key=="setupservicerequest") continue;
		if ($key=="Ozeki10Frame") continue;
		if (ozstartswith($key,"Longterm_")) continue;
		unset($browsersession[$key]);
	}

	saveBrowserSession();
}

//**********************************************************
// Encrpyted session data
//**********************************************************

function addEncryptedSessionData($dataname, $datavalue, $save=true, $aeskey=null)
{
	global $siteid,$myaesprivate;
	if (isEmpty($aeskey) && !isEmpty($myaesprivate))
	{
		$aeskey = $myaesprivate;
	}
	
	if (isEmpty($aeskey) && !isEmpty($siteid))
	{
		$aeskey = $siteid;
	}

	if (!isEmpty($aeskey) && !isEmpty($datavalue))
	{
		$datavalueenc = encryptTextAES($aeskey, $datavalue);
	} 
	else 
	{
		$datavalueenc = "";
	}

	addSessionData($dataname, $datavalueenc, $save=true);
}

function getEncryptedSessionData($dataname, $aeskey=null)
{
	global $browsersession,$siteid,$myaesprivate;
	if (!array_key_exists($dataname,$browsersession)) return "";
	$encrypted = $browsersession[$dataname];

	if (isEmpty($aeskey) && !isEmpty($myaesprivate))
	{
		$aeskey = $myaesprivate;
	}

	if (isEmpty($aeskey) && !isEmpty($siteid))
	{
		$aeskey = $siteid ;
	}

	if (isEmpty($aeskey)) return "";
	if (isEmpty($encrypted)) return "";
	
	$datavalue = decryptTextAES($aeskey, $encrypted);
	return $datavalue;
}

//**********************************************************
// Directories
//**********************************************************
$sessionroot = $datadir."/sessions";
$sessionrootbrowser = $sessionroot ."/browser";
$sessionrootip = $datadir."/services/visitorlog/ips";

if ($debugsession) {
	ob_start();
	echo "<hr><b>Browser session</b><br>";
	echo "Session root: $sessionroot<br>";
}

if (!is_dir($sessionroot)) 
{
	if (!ozmkdir($sessionroot,$error))
	{
		echo "Error: Cannot create ozeki data directory for session! ".$error;
	}

	if (!ozmkdir($sessionrootbrowser,$error))
	{
		echo "Error: Cannot create ozeki data directory for session browser! ".$error;
	}

	if (!ozmkdir($sessionrootip,$error))
	{
		echo "Error: Cannot create ozeki data directory for session ip! ".$error;
	}
}

//**********************************************************
// Browser session / Create
//**********************************************************
$cookie_name = "mysessionid";
$accesstoken = (array_key_exists($cookie_name,$_COOKIE)) ? $_COOKIE[$cookie_name] : "";
if (isset($_POST["setsessionid"]) && !isempty($_POST["setsessionid"])) $accesstoken = $_POST["setsessionid"];
if (isEmpty($accesstoken)) createBrowserSession();
if ($debugsession) {
	echo "Access token for session: $accesstoken<br>";
	echo "Setting cookie: $cookie_name=$accesstoken<br>";
}
setcookie($cookie_name, $accesstoken, time()+31556926, "/"); // 31556926 = 1 year

//**********************************************************
// Browser session / Load
//**********************************************************
setupBrowserSession();
$visitorip = $_SERVER['REMOTE_ADDR'];

if ($debugsession) 
{
	echo "<hr><b>Received cookie</b><br>";
	echo "Session file: $sessionfilebrowser<br>";
	foreach ($_COOKIE as $cookieName => $cookieValue) {
		echo "Browser sent cookie: $cookieName: $cookieValue<br>";
	}
}

if (file_exists($sessionfilebrowser))
{
	if ($debugsession) echo "Browser session file: $sessionfilebrowser<BR>";
	$filetext = ozfilelockread($sessionfilebrowser);
	$browsersession = json_decode($filetext,true);
	$browsersession["BrowserLastTouch"]=mysqldate();
	$browsersession["LastRequest"]=$_SERVER["REQUEST_METHOD"]." ".$_SERVER['REQUEST_URI'];
	$browsersession["VisitorIP"]=$visitorip;
	if (!array_key_exists("VisitorIPs",$browsersession) || !is_array($browsersession["VisitorIPs"])) $browsersession["VisitorIPs"] = [];
	if (!in_array($visitorip,$browsersession["VisitorIPs"])) $browsersession["VisitorIPs"][] = $visitorip;

	foreach($browsersession as $key=>$value)
	{
		if ($debugsession) {
			if (is_array($value)) $vald = json_encode($value); else $vald = $value;
			echo "Browser session data: $key:$vald<br>";
		}
		$$key = $value;	
	}
	if (empty($myuserid) && isset($userid) && ismd5($userid)) $myuserid=$userid;
	if (!array_key_exists("loginsessionkey",$browsersession) || 
		$browsersession["loginsessionkey"]=="logout") 
	{
		$myuserid = "";
		$userid="";
	}
} 
else
{
	$browsersession = [];
	$browsersession["BrowserID"]=$accesstoken;
	$browsersession["BrowserCreated"]=mysqldate();
	$browsersession["BrowserLastTouch"]=mysqldate();
	$browsersession["VisitorIP"][]= $visitorip;
	$browsersession["VisitorIPs"][]= $visitorip;
	if (isset($_SERVER['HTTP_USER_AGENT'])) $browsersession["UserAgent"]=$_SERVER['HTTP_USER_AGENT'];
	$browsersession["VisitorHost"]=gethostbyaddr($_SERVER['REMOTE_ADDR']);
	$browsersession["LastRequest"]=$_SERVER["REQUEST_METHOD"]." ".$_SERVER['REQUEST_URI'];
}

if ($debugsession) 
{
	$debuglog .= ob_get_contents();
	ob_end_clean();
}


saveBrowserSession();

//**********************************************************
// Browser session / Cleanup on logout
//**********************************************************
if (array_key_exists("justloggedout",$_REQUEST)) destroyBrowserSession();
if ($owpn=="page_authentication_passwordforgot") 
{
	$loginmode = "logoutfirst";
	destroyBrowserSession();
}

//**********************************************************
// IP session / Create
//**********************************************************
$clientip = $_SERVER['REMOTE_ADDR'];

if ($debugsession) $debuglog .= "IP address for session: ".$clientip."<br>";

if (!ozfilenamesafe($clientip, $clientipsafe, $error))
{
	echo "Error: Cannot create ozeki ip session file! Invalid client IP address. ".$error;
	exit;
}

$clientipsafe = str_replace("__","",$clientipsafe);
$clientipsafe = str_replace("_",".",$clientipsafe);

$sessionrootip = $sessionrootip."/".$clientipsafe;
if (!ozmkdir($sessionrootip,$error))
{
	echo "Error: Cannot create ozeki ip session directory! ".$error;
}
$sessionfileip = $sessionrootip ."/myozeki_ipsession.json";

if (file_exists($sessionfileip))
{
	if ($debugsession) {
		ob_start();
		echo "<hr><b>IP session loaded.</b><br>";
		echo "IP session file: ".$sessionfileip."<br>";
	}
	$filetext = file_get_contents($sessionfileip);
	$ipsession = json_decode($filetext,true);
	$ipsession["IPLastTouch"]=mysqldate();
	foreach($ipsession as $key=>$value)
	{
		if ($debugsession) echo "IP session data: $key:$value<br>";
		$$key = $value;	
	}

	if ($debugsession) {
		$debuglog .= ob_get_contents();
		ob_end_clean();
	}

} 
else
{
	$ipsession = [];
	$ipsession["IPID"]=$clientip;
	$ipsession["IPCreated"]=mysqldate();
	$ipsession["IPLastTouch"]=mysqldate();
}

function addSessionDataIP($dataname, $datavalue)
{
	global $browsersession;
	$browsersession[$dataname] = $datavalue;
	saveIPSession();
}

function saveIPSession()
{
	global $ipsession,$sessionfileip;
	$serialized = json_encode($ipsession);
	file_put_contents($sessionfileip,$serialized);
}

saveIPSession();

?>