<?php
//*****************************************************
// Account qualification system
// Account types:
// - user
// - serviceuser
// - staff
// - developer
// - decisionmaker
// - testuser
//*****************************************************

//*****************************************************
// Set qualification 
//*****************************************************
$valid_qualifications = ["decisionmaker", "developer", "testuser", "staff", "exstaff", "serviceuser"];
function setUserQualifications($userid,$qualifications,&$error){
    global $valid_qualifications;
    if (!is_array($qualifications)){
        $error = "Invalid qualifications.";
        return false;
    }
    $invalid = array_diff($qualifications,$valid_qualifications);
    if (!isempty($invalid)){
        $error = "Invalid qualifications.";
        return false;
    }
    $old_qualifications = getUserQualifications($userid);
    $new_qualifications = array_diff($qualifications, $old_qualifications);
    $remove_qualifications = array_diff($old_qualifications, $qualifications);
    if($new_qualifications){
        foreach($new_qualifications as $qualify){
            if (!setUserQualification($userid,$qualify,null,null,$error)) return false;
        }
    }
    if($remove_qualifications){
        foreach($remove_qualifications as $unqualify){
            if (!setUserQualification($userid,null,$unqualify,null,$error)) return false;
        }
    }
    return true;
}

function setUserQualification($userid,$qualifyas,$unqualifyas,$notes,&$error)
{
    global $regdir,$datadir,$myuserid;
    $dir = "$regdir/$userid/qualification";

    if (!userExists($userid))
    {
        $error = "Cannot set user qualification. User does not exist.";
        return false;
    }

    if (!isEmpty($qualifyas) && !isfilesafe($qualifyas,$error))
    {
        $error = "Cannot set user qualification. Invalid qualification. $error";
        return false;
    }

    if (!isEmpty($unqualifyas) && !isfilesafe($unqualifyas,$error))
    {
        $error = "Cannot unset user qualification. Invalid qualification. $error";
        return false;
    }

    if (!ozmkdir($dir,$error))
    {
        $error = "Cannot set user qualification. Dir create error. $error";
        return false;
    }

    $dirservice = "$datadir/qualifications";
    if (!ozmkdir($dirservice,$error))
    {
        $error = "Cannot set user qualification. Service dir create error. $error";
        return false;
    }

    if (!isEmpty($qualifyas))
    {
        $file = "$dir/$qualifyas.txt";
        if (file_exists($file))
        {
            return true;
        }
    
        $qualifyinfo = [];
        $qualifyinfo["createdby"] = $myuserid;
        $qualifyinfo["createtime"] = mysqldate();
        $qualifyinfo["createip"] = $_SERVER['REMOTE_ADDR'];
        $qualifyinfo["notes"] = $notes;

        if (!ozsavejson($file,$qualifyinfo,$error))
        {
            $error = "Cannot set user qualification. Data save error. $error";
            return false;
        }

        $servicefile = "$dirservice/$qualifyas.txt";
        ozfileaddtolist($servicefile,$userid,$error);
    }

    
    if (!isEmpty($unqualifyas))
    {
        $file = "$dir/$unqualifyas.txt";
        if (!file_exists($file))
        {
            return true;
        }
    
        unlink($file);

        $servicefile = "$dirservice/$unqualifyas.txt";
        ozfiledelfromlist($servicefile,$userid,$error);
    }
    
    return true;

}

//*****************************************************
// Get qualification 
//*****************************************************

function getUserQualifications($userid){
    global $valid_qualifications;
    $qualifications = [];
    foreach ($valid_qualifications as $qualification) {
        if (isUserQualifedAs($userid, $qualification)) {
            $qualifications[] = $qualification;
        }
    }
    return $qualifications;
}
//*****************************************************
// IP qualification / Del logs
//*****************************************************

function displayUserQualifierLink($userid,$qualification,$calssunqualified,$classqualified)
{
    global $owpn;
    if (isempty($userid)) return "";
    $unqualify = isUserQualifedAs($userid,$qualification);
    $actionname = ($unqualify)?"unqualifyas" : "qualifyas";
    $caption = ($unqualify)? "Unqualify as $qualification" : "Qualify as $qualification";
    $class = ($unqualify)? $classqualified : $calssunqualified;
    $link = "index.php?owpn=$owpn&userq=".urlencode($userid)."&$actionname=$qualification".getLinkExtra(array('qualifyas','unqualifyas','userq')).nocache();
    return "<a href='$link' ><div class='btn $class mb-1 mt-1 me-3'>$caption</div></a>";
}

function displayUserQualificationButtons($userid)
{
    global $qualifyas,$unqualifyas,$userq;
    loadReqParams("qualifyas","unqualifyas","userq");

    $username = GetName($userid);
    $ret = "<h4>$username</h4>";

    if (!isEmpty($userq) && 
       (!isEmpty($qualifyas) || !isEmpty($unqualifyas)) &&
       ($userq==$userid))
    {
        $notes = "";
        if (!setUserQualification($userid,$qualifyas,$unqualifyas,$notes,$error))
        {
            $ret .= "<h4 style='color:red'>Qualification error</h4>";
            $ret .= $error;
        } else if (!isEmpty($qualifyas))
        {
            $ret .= "<h4 style='color:green'>Qualification success</h4>";
            $ret .= GetName($userid)." is set to ".$qualifyas;
        } else
        {
            $ret .= "<h4 style='color:green'>Unqualification success</h4>";
            $ret .= GetName($userid)." is no longer ".$unqualifyas;
        }
    }
    
    $ret.= displayUserQualifierLink($userid,"staff","btn-primary","btn-secondary");
    $ret.= displayUserQualifierLink($userid,"exstaff","btn-primary","btn-secondary");
    $ret.= displayUserQualifierLink($userid,"developer","btn-primary","btn-secondary");
    $ret.= displayUserQualifierLink($userid,"serviceuser","btn-primary","btn-secondary");
    $ret.= displayUserQualifierLink($userid,"decisionmaker","btn-primary","btn-secondary");
    $ret.= displayUserQualifierLink($userid,"testuser","btn-primary","btn-secondary");
    return $ret;
}

function getUserQualificationColor($userid)
{
    if (isDecisionMaker($userid)) return "#fba5a5";
    if (isDeveloper($userid)) return "#fbeba5";
    if (isUserQualifedAs($userid,"serviceuser")) return "#d0d0d0";
    if (isTestuser($userid)) return "#cdd9f7";
    if (isStaff($userid)) return "#80d0ff";
    if (isExStaff($userid)) return "#8db9c0";

    return "white";
}

function getUserQualificationLegend()
{
    $ret = <<<LEGENDEND
    <table>
    <tr><td bgcolor="#fba5a5" style="width:20px">&nbsp;</td><td>Decision maker</td></tr>
    <tr><td bgcolor="#fbeba5" style="width:20px">&nbsp;</td><td>Developer</td></tr>
    <tr><td bgcolor="#cdd9f7" style="width:20px">&nbsp;</td><td>User service</td></tr>
    <tr><td bgcolor="#eac1fe" style="width:20px">&nbsp;</td><td>Test user</td></tr>
    <tr><td bgcolor="#80d0ff" style="width:20px">&nbsp;</td><td>Staff</td></tr>
    <tr><td bgcolor="#8db9c0" style="width:20px">&nbsp;</td><td>Ex staff</td></tr>
    <tr><td bgcolor="white">&nbsp;</td><td>Normal user</td></tr>
    </table>
LEGENDEND;
    return $ret;
}

?>