<?php
//**************************************************************************
// Mime type tables
//**************************************************************************

$mimeToExt = [
        'application/vnd.1000minds.decision-model+xml' => '1km',
        'text/vnd.in3d.3dml' => '3dml',
        'image/x-3ds' => '3ds',
        'video/3gpp2' => '3g2',
        'video/3gp' => '3gp',
        'video/3gpp' => '3gpp',
        'model/3mf' => '3mf',
        'application/x-7z-compressed' => '7z',
        'application/vnd.lotus-1-2-3' => '123',
        'application/x-authorware-bin' => 'aab',
        'audio/x-acc' => 'aac',
        'application/x-authorware-map' => 'aam',
        'application/x-authorware-seg' => 'aas',
        'application/x-abiword' => 'abw',
        'application/vnd.nokia.n-gage.ac+xml' => 'ac',
        'audio/ac3' => 'ac3',
        'application/vnd.americandynamics.acc' => 'acc',
        'application/x-ace-compressed' => 'ace',
        'application/vnd.acucobol' => 'acu',
        'application/vnd.acucorp' => 'acutc',
        'audio/adpcm' => 'adp',
        'application/vnd.audiograph' => 'aep',
        'application/x-font-type1' => 'afm',
        'application/vnd.ibm.modcap' => 'afp',
        'application/vnd.age' => 'age',
        'application/vnd.ahead.space' => 'ahead',
        'application/pdf' => 'ai',
        'audio/x-aiff' => 'aif',
        'application/vnd.adobe.air-application-installer-package+zip' => 'air',
        'application/vnd.dvb.ait' => 'ait',
        'application/vnd.amiga.ami' => 'ami',
        'audio/amr' => 'amr',
        'application/vnd.android.package-archive' => 'apk',
        'image/apng' => 'apng',
        'text/cache-manifest' => 'appcache',
        'application/x-ms-application' => 'application',
        'application/vnd.lotus-approach' => 'apr',
        'application/x-freearc' => 'arc',
        'application/x-arj' => 'arj',
        'application/pgp-signature' => 'asc',
        'video/x-ms-asf' => 'asf',
        'text/x-asm' => 'asm',
        'application/vnd.accpac.simply.aso' => 'aso',
        'video/x-ms-asf' => 'asx',
        'application/vnd.acucorp' => 'atc',
        'application/atom+xml' => 'atom',
        'application/atomcat+xml' => 'atomcat',
        'application/atomdeleted+xml' => 'atomdeleted',
        'application/atomsvc+xml' => 'atomsvc',
        'application/vnd.antix.game-component' => 'atx',
        'audio/x-au' => 'au',
        'image/avci' => 'avci',
        'image/avcs' => 'avcs',
        'video/x-msvideo' => 'avi',
        'image/avif' => 'avif',
        'application/applixware' => 'aw',
        'application/vnd.airzip.filesecure.azf' => 'azf',
        'application/vnd.airzip.filesecure.azs' => 'azs',
        'image/vnd.airzip.accelerator.azv' => 'azv',
        'application/vnd.amazon.ebook' => 'azw',
        'image/vnd.pco.b16' => 'b16',
        'application/x-msdownload' => 'bat',
        'application/x-bcpio' => 'bcpio',
        'application/x-font-bdf' => 'bdf',
        'application/vnd.syncml.dm+wbxml' => 'bdm',
        'application/x-bdoc' => 'bdoc',
        'application/vnd.realvnc.bed' => 'bed',
        'application/vnd.fujitsu.oasysprs' => 'bh2',
        'application/octet-stream' => 'bin',
        'application/x-blorb' => 'blb',
        'application/vnd.bmi' => 'bmi',
        'application/vnd.balsamiq.bmml+xml' => 'bmml',
        'image/bmp' => 'bmp',
        'application/vnd.framemaker' => 'book',
        'application/vnd.previewsystems.box' => 'box',
        'application/x-bzip2' => 'boz',
        'application/octet-stream' => 'bin',
        'model/vnd.valve.source.compiled-map' => 'bsp',
        'image/prs.btif' => 'btif',
        'application/x-bzip' => 'bz',
        'application/x-bzip2' => 'bz2',
        'text/x-c' => 'c',
        'application/vnd.clonk.c4group' => 'c4d',
        'application/vnd.cluetrust.cartomobile-config' => 'c11amc',
        'application/vnd.cluetrust.cartomobile-config-pkg' => 'c11amz',
        'application/vnd.ms-cab-compressed' => 'cab',
        'audio/x-caf' => 'caf',
        'application/vnd.tcpdump.pcap' => 'cap',
        'application/vnd.curl.car' => 'car',
        'application/vnd.ms-pki.seccat' => 'cat',
        'application/x-cbr' => 'cb7',
        'text/x-c' => 'cc',
        'application/x-cocoa' => 'cco',
        'application/x-director' => 'cct',
        'application/ccxml+xml' => 'ccxml',
        'application/vnd.contact.cmsg' => 'cdbcmsg',
        'application/x-netcdf' => 'cdf',
        'application/cdfx+xml' => 'cdfx',
        'application/vnd.mediastation.cdkey' => 'cdkey',
        'application/cdmi-capability' => 'cdmia',
        'application/cdmi-container' => 'cdmic',
        'application/cdmi-domain' => 'cdmid',
        'application/cdmi-object' => 'cdmio',
        'application/cdmi-queue' => 'cdmiq',
        'application/cdr' => 'cdr',
        'chemical/x-cdx' => 'cdx',
        'application/vnd.chemdraw+xml' => 'cdxml',
        'application/vnd.cinderella' => 'cdy',
        'application/pkix-cert' => 'cer',
        'application/x-cfs-compressed' => 'cfs',
        'image/cgm' => 'cgm',
        'application/x-chat' => 'chat',
        'application/vnd.ms-htmlhelp' => 'chm',
        'application/vnd.kde.kchart' => 'chrt',
        'chemical/x-cif' => 'cif',
        'application/vnd.anser-web-certificate-issue-initiation' => 'cii',
        'application/vnd.ms-artgalry' => 'cil',
        'application/node' => 'cjs',
        'application/vnd.claymore' => 'cla',
        'application/vnd.crick.clicker.keyboard' => 'clkk',
        'application/vnd.crick.clicker.palette' => 'clkp',
        'application/vnd.crick.clicker.template' => 'clkt',
        'application/vnd.crick.clicker.wordbank' => 'clkw',
        'application/vnd.crick.clicker' => 'clkx',
        'application/x-msclip' => 'clp',
        'application/vnd.cosmocaller' => 'cmc',
        'chemical/x-cmdf' => 'cmdf',
        'chemical/x-cml' => 'cml',
        'application/vnd.yellowriver-custom-menu' => 'cmp',
        'image/x-cmx' => 'cmx',
        'application/vnd.rim.cod' => 'cod',
        'text/coffeescript' => 'coffee',
        'application/x-msdownload' => 'com',
        'text/plain' => 'conf',
        'application/x-cpio' => 'cpio',
        'application/cpl+xml' => 'cpl',
        'text/x-c' => 'cpp',
        'application/mac-compactpro' => 'cpt',
        'application/x-mscardfile' => 'crd',
        'application/pkix-crl' => 'crl',
        'application/x-x509-ca-cert' => 'crt',
        'application/x-chrome-extension' => 'crx',
        'application/vnd.rig.cryptonote' => 'cryptonote',
        'application/x-csh' => 'csh',
        'application/vnd.citationstyles.style+xml' => 'csl',
        'chemical/x-csml' => 'csml',
        'application/vnd.commonspace' => 'csp',
        'text/css' => 'css',
        'application/x-director' => 'cst',
        'text/csv' => 'csv',
        'application/cu-seeme' => 'cu',
        'text/vnd.curl' => 'curl',
        'application/prs.cww' => 'cww',
        'application/x-director' => 'cxt',
        'text/x-c' => 'cxx',
        'model/vnd.collada+xml' => 'dae',
        'application/vnd.mobius.daf' => 'daf',
        'application/vnd.dart' => 'dart',
        'application/vnd.fdsn.seed' => 'dataless',
        'application/davmount+xml' => 'davmount',
        'application/vnd.dbf' => 'dbf',
        'application/docbook+xml' => 'dbk',
        'application/x-director' => 'dcr',
        'text/vnd.curl.dcurl' => 'dcurl',
        'application/vnd.oma.dd2+xml' => 'dd2',
        'application/vnd.fujixerox.ddd' => 'ddd',
        'application/vnd.syncml.dmddf+xml' => 'ddf',
        'image/vnd.ms-dds' => 'dds',
        'application/x-debian-package' => 'deb',
        'text/plain' => 'def',
        'application/octet-stream' => 'deploy',
        'application/x-x509-ca-cert' => 'der',
        'application/vnd.dreamfactory' => 'dfac',
        'application/x-dgc-compressed' => 'dgc',
        'text/x-c' => 'dic',
        'application/x-director' => 'dir',
        'application/vnd.mobius.dis' => 'dis',
        'message/disposition-notification' => 'disposition-notification',
        'image/vnd.djvu' => 'djv',
        'application/octet-stream' => 'dll',
        'application/x-apple-diskimage' => 'dmg',
        'application/octet-stream' => 'dmn',
        'application/vnd.tcpdump.pcap' => 'dmp',
        'application/octet-stream' => 'dms',
        'application/vnd.dna' => 'dna',
        'application/msword' => 'doc',
        'application/vnd.ms-word.template.macroEnabled.12' => 'docm',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document' => 'docx',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.template' => 'dotx',
        'application/vnd.osgi.dp' => 'dp',
        'application/vnd.dpgraph' => 'dpg',
        'audio/vnd.dra' => 'dra',
        'image/dicom-rle' => 'drle',
        'text/prs.lines.tag' => 'dsc',
        'application/dssc+der' => 'dssc',
        'application/x-dtbook+xml' => 'dtb',
        'application/xml-dtd' => 'dtd',
        'audio/vnd.dts' => 'dts',
        'audio/vnd.dts.hd' => 'dtshd',
        'video/vnd.dvb.file' => 'dvb',
        'application/x-dvi' => 'dvi',
        'application/atsc-dwd+xml' => 'dwd',
        'model/vnd.dwf' => 'dwf',
        'image/vnd.dwg' => 'dwg',
        'image/vnd.dxf' => 'dxf',
        'application/vnd.spotfire.dxp' => 'dxp',
        'application/x-director' => 'dxr',
        'application/java-archive' => 'ear',
        'audio/vnd.nuera.ecelp4800' => 'ecelp4800',
        'audio/vnd.nuera.ecelp7470' => 'ecelp7470',
        'audio/vnd.nuera.ecelp9600' => 'ecelp9600',
        'application/ecmascript' => 'ecma',
        'application/vnd.novadigm.edm' => 'edm',
        'application/vnd.novadigm.edx' => 'edx',
        'application/vnd.picsel' => 'efif',
        'application/vnd.pg.osasli' => 'ei6',
        'application/octet-stream' => 'elc',
        'image/emf' => 'emf',
        'message/rfc822' => 'eml',
        'application/emma+xml' => 'emma',
        'application/emotionml+xml' => 'emotionml',
        'application/x-msmetafile' => 'emz',
        'audio/vnd.digital-winds' => 'eol',
        'application/vnd.ms-fontobject' => 'eot',
        'application/postscript' => 'eps',
        'application/epub+zip' => 'epub',
        'application/ecmascript' => 'es',
        'application/vnd.eszigno3+xml' => 'es3',
        'application/vnd.osgi.subsystem' => 'esa',
        'application/vnd.epson.esf' => 'esf',
        'application/vnd.eszigno3+xml' => 'et3',
        'text/x-setext' => 'etx',
        'application/x-eva' => 'eva',
        'application/x-envoy' => 'evy',
        'application/octet-stream' => 'exe',
        'application/exi' => 'exi',
        'application/express' => 'exp',
        'image/aces' => 'exr',
        'application/vnd.novadigm.ext' => 'ext',
        'application/andrew-inset' => 'ez',
        'application/vnd.ezpix-album' => 'ez2',
        'application/vnd.ezpix-package' => 'ez3',
        'text/x-fortran' => 'f',
        'video/mp4' => 'mp3',
        'text/x-fortran' => 'f77',
        'image/vnd.fastbidsheet' => 'fbs',
        'application/vnd.adobe.formscentral.fcdt' => 'fcdt',
        'application/vnd.isac.fcs' => 'fcs',
        'application/vnd.fdf' => 'fdf',
        'application/fdt+xml' => 'fdt',
        'application/vnd.denovo.fcselayout-link' => 'fe_launch',
        'application/vnd.fujitsu.oasysgp' => 'fg5',
        'application/x-director' => 'fgd',
        'image/x-freehand' => 'fh',
        'application/x-xfig' => 'fig',
        'image/fits' => 'fits',
        'audio/x-flac' => 'flac',
        'video/x-fli' => 'fli',
        'application/vnd.micrografx.flo' => 'flo',
        'video/x-flv' => 'flv',
        'application/vnd.kde.kivio' => 'flw',
        'text/vnd.fmi.flexstor' => 'flx',
        'text/vnd.fly' => 'fly',
        'application/vnd.framemaker' => 'fm',
        'application/vnd.frogans.fnc' => 'fnc',
        'application/vnd.software602.filler.form+xml' => 'fo',
        'text/x-fortran' => 'for',
        'image/vnd.fpx' => 'fpx',
        'application/vnd.framemaker' => 'frame',
        'application/vnd.fsc.weblaunch' => 'fsc',
        'image/vnd.fst' => 'fst',
        'application/vnd.fluxtime.clip' => 'ftc',
        'application/vnd.anser-web-funds-transfer-initiation' => 'fti',
        'video/vnd.fvt' => 'fvt',
        'application/vnd.adobe.fxp' => 'fxp',
        'application/vnd.fuzzysheet' => 'fzs',
        'application/vnd.geoplan' => 'g2w',
        'image/g3fax' => 'g3',
        'application/vnd.geospace' => 'g3w',
        'application/vnd.groove-account' => 'gac',
        'application/x-tads' => 'gam',
        'application/rpki-ghostbusters' => 'gbr',
        'application/x-gca-compressed' => 'gca',
        'model/vnd.gdl' => 'gdl',
        'application/vnd.google-apps.document' => 'gdoc',
        'text/vnd.familysearch.gedcom' => 'ged',
        'application/vnd.dynageo' => 'geo',
        'application/geo+json' => 'geojson',
        'application/vnd.geometry-explorer' => 'gex',
        'application/vnd.geogebra.file' => 'ggb',
        'application/vnd.geogebra.tool' => 'ggt',
        'application/vnd.groove-help' => 'ghf',
        'image/gif' => 'gif',
        'application/vnd.groove-identity-message' => 'gim',
        'model/gltf-binary' => 'glb',
        'model/gltf+json' => 'gltf',
        'application/gml+xml' => 'gml',
        'application/vnd.gmx' => 'gmx',
        'application/x-gnumeric' => 'gnumeric',
        'application/gpg-keys' => 'gpg',
        'application/vnd.flographit' => 'gph',
        'application/gpx+xml' => 'gpx',
        'application/vnd.grafeq' => 'gqf',
        'application/vnd.grafeq' => 'gqs',
        'application/srgs' => 'gram',
        'application/x-gramps-xml' => 'gramps',
        'application/vnd.geometry-explorer' => 'gre',
        'application/vnd.groove-injector' => 'grv',
        'application/srgs+xml' => 'grxml',
        'application/x-font-ghostscript' => 'gsf',
        'application/vnd.google-apps.spreadsheet' => 'gsheet',
        'application/vnd.google-apps.presentation' => 'gslides',
        'application/x-gtar' => 'gtar',
        'application/vnd.groove-tool-message' => 'gtm',
        'model/vnd.gtw' => 'gtw',
        'text/vnd.graphviz' => 'gv',
        'application/gxf' => 'gxf',
        'application/vnd.geonext' => 'gxt',
        'application/gzip' => 'gz',
        'text/x-c' => 'h',
        'video/h261' => 'h261',
        'video/h263' => 'h263',
        'video/h264' => 'h264',
        'application/vnd.hal+xml' => 'hal',
        'application/vnd.hbci' => 'hbci',
        'text/x-handlebars-template' => 'hbs',
        'application/x-virtualbox-hdd' => 'hdd',
        'application/x-hdf' => 'hdf',
        'image/heic' => 'heic',
        'image/heic-sequence' => 'heics',
        'image/heif' => 'heif',
        'image/heif-sequence' => 'heifs',
        'image/hej2k' => 'hej2',
        'application/atsc-held+xml' => 'held',
        'text/x-c' => 'hh',
        'application/hjson' => 'hjson',
        'application/winhlp' => 'hlp',
        'application/vnd.hp-hpgl' => 'hpgl',
        'application/vnd.hp-hpid' => 'hpid',
        'application/vnd.hp-hps' => 'hps',
        'application/mac-binhex40' => 'hqx',
        'image/hsj2' => 'hsj2',
        'text/x-component' => 'htc',
        'application/vnd.kenameaapp' => 'htke',
        'text/html' => 'htm',
        'text/html' => 'html',
        'application/vnd.yamaha.hv-dic' => 'hvd',
        'application/vnd.yamaha.hv-voice' => 'hvp',
        'application/vnd.yamaha.hv-script' => 'hvs',
        'application/vnd.intergeo' => 'i2g',
        'application/vnd.iccprofile' => 'icc',
        'x-conference/x-cooltalk' => 'ice',
        'application/vnd.iccprofile' => 'icm',
        'image/x-icon' => 'ico',
        'text/calendar' => 'ics',
        'image/ief' => 'ief',
        'text/calendar' => 'ifb',
        'application/vnd.shana.informed.formdata' => 'ifm',
        'model/iges' => 'iges',
        'application/vnd.igloader' => 'igl',
        'application/vnd.insors.igm' => 'igm',
        'model/iges' => 'igs',
        'application/vnd.micrografx.igx' => 'igx',
        'application/vnd.shana.informed.interchange' => 'iif',
        'application/octet-stream' => 'img',
        'application/vnd.accpac.simply.imp' => 'imp',
        'application/vnd.ms-ims' => 'ims',
        'text/plain' => 'in',
        'text/plain' => 'ini',
        'application/inkml+xml' => 'ink',
        'application/inkml+xml' => 'inkml',
        'application/x-install-instructions' => 'install',
        'application/vnd.astraea-software.iota' => 'iota',
        'application/ipfix' => 'ipfix',
        'application/vnd.shana.informed.package' => 'ipk',
        'application/vnd.ibm.rights-management' => 'irm',
        'application/vnd.irepository.package+xml' => 'irp',
        'application/x-iso9660-image' => 'iso',
        'application/vnd.shana.informed.formtemplate' => 'itp',
        'application/its+xml' => 'its',
        'application/vnd.immervision-ivp' => 'ivp',
        'application/vnd.immervision-ivu' => 'ivu',
        'text/vnd.sun.j2me.app-descriptor' => 'jad',
        'text/jade' => 'jade',
        'application/vnd.jam' => 'jam',
        'application/java-archive' => 'jar',
        'application/x-java-archive-diff' => 'jardiff',
        'text/x-java-source' => 'java',
        'image/jphc' => 'jhc',
        'application/vnd.jisp' => 'jisp',
        'image/jls' => 'jls',
        'application/vnd.hp-jlyt' => 'jlt',
        'image/x-jng' => 'jng',
        'application/x-java-jnlp-file' => 'jnlp',
        'application/vnd.joost.joda-archive' => 'joda',
        'image/jp2' => 'jp2',
        'image/jpeg' => 'jpeg',
        'image/jpx' => 'jpf',
        'video/jpm' => 'jpgm',
        'video/jpeg' => 'jpgv',
        'image/jph' => 'jph',
        'video/jpm' => 'jpm',
        'application/javascript' => 'js',
        'application/json' => 'json',
        'application/json5' => 'json5',
        'application/ld+json' => 'jsonld',
        'application/jsonml+json' => 'jsonml',
        'text/jsx' => 'jsx',
        'image/jxr' => 'jxr',
        'image/jxra' => 'jxra',
        'image/jxrs' => 'jxrs',
        'image/jxs' => 'jxs',
        'image/jxsc' => 'jxsc',
        'image/jxsi' => 'jxsi',
        'image/jxss' => 'jxss',
        'audio/midi' => 'kar',
        'application/vnd.kde.karbon' => 'karbon',
        'application/octet-stream' => 'kdb',
        'application/x-keepass2' => 'kdbx',
        'application/x-iwork-keynote-sffkey' => 'key',
        'application/vnd.kde.kformula' => 'kfo',
        'application/vnd.kidspiration' => 'kia',
        'application/vnd.google-earth.kml+xml' => 'kml',
        'application/vnd.google-earth.kmz' => 'kmz',
        'application/vnd.kinar' => 'kne',
        'application/vnd.kinar' => 'knp',
        'application/vnd.kde.kontour' => 'kon',
        'application/vnd.kde.kpresenter' => 'kpr',
        'application/vnd.ds-keypoint' => 'kpxx',
        'application/vnd.kde.kspread' => 'ksp',
        'application/vnd.kahootz' => 'ktr',
        'image/ktx' => 'ktx',
        'image/ktx2' => 'ktx2',
        'application/vnd.kahootz' => 'ktz',
        'application/vnd.kde.kword' => 'kwd',
        'application/vnd.las.las+xml' => 'lasxml',
        'application/x-latex' => 'latex',
        'application/vnd.llamagraphics.life-balance.desktop' => 'lbd',
        'application/vnd.llamagraphics.life-balance.exchange+xml' => 'lbe',
        'application/vnd.hhe.lesson-player' => 'les',
        'text/less' => 'less',
        'application/lgr+xml' => 'lgr',
        'application/octet-stream' => 'lha',
        'application/vnd.route66.link66+xml' => 'link66',
        'application/vnd.ibm.modcap' => 'listafp',
        'text/coffeescript' => 'litcoffee',
        'application/x-ms-shortcut' => 'lnk',
        'application/lost+xml' => 'lostxml',
        'application/octet-stream' => 'lrf',
        'application/vnd.ms-lrm' => 'lrm',
        'application/vnd.frogans.ltf' => 'ltf',
        'text/x-lua' => 'lua',
        'application/x-lua-bytecode' => 'luac',
        'audio/vnd.lucent.voice' => 'lvp',
        'application/vnd.lotus-wordpro' => 'lwp',
        'application/octet-stream' => 'lzh',
        'video/mpeg' => 'mpeg',
        'audio/mpeg' => 'm2a',
        'text/plain' => 'txt',
        'application/vnd.apple.mpegurl' => 'm3u8',
        'audio/x-m4a' => 'm4a',
        'application/mp4' => 'm4p',
        'video/iso.segment' => 'm4s',
        'application/vnd.mpegurl' => 'm4u',
        'video/x-m4v' => 'm4v',
        'application/x-msmediaview' => 'm13',
        'application/x-msmediaview' => 'm14',
        'application/mp21' => 'm21',
        'application/mathematica' => 'ma',
        'application/mads+xml' => 'mads',
        'application/mmt-aei+xml' => 'maei',
        'application/vnd.ecowin.chart' => 'mag',
        'application/vnd.framemaker' => 'maker',
        'text/troff' => 'man',
        'text/cache-manifest' => 'manifest',
        'application/json' => 'map',
        'application/octet-stream' => 'mar',
        'text/markdown' => 'markdown',
        'application/mathml+xml' => 'mathml',
        'application/mathematica' => 'mb',
        'application/vnd.mobius.mbk' => 'mbk',
        'application/mbox' => 'mbox',
        'application/vnd.medcalcdata' => 'mc1',
        'application/vnd.mcd' => 'mcd',
        'text/vnd.curl.mcurl' => 'mcurl',
        'text/markdown' => 'md',
        'application/x-msaccess' => 'mdb',
        'image/vnd.ms-modi' => 'mdi',
        'text/mdx' => 'mdx',
        'text/troff' => 'me',
        'model/mesh' => 'mesh',
        'application/metalink4+xml' => 'meta4',
        'application/metalink+xml' => 'metalink',
        'application/mets+xml' => 'mets',
        'application/vnd.mfmp' => 'mfm',
        'application/rpki-manifest' => 'mft',
        'application/vnd.osgeo.mapguide.package' => 'mgp',
        'application/vnd.proteus.magazine' => 'mgz',
        'audio/midi' => 'mid',
        'application/x-mie' => 'mie',
        'application/vnd.mif' => 'mif',
        'message/rfc822' => 'mime',
        'video/mj2' => 'mj2',
        'video/mj2' => 'mjp2',
        'application/javascript' => 'mjs',
        'video/x-matroska' => 'mk3d',
        'audio/x-matroska' => 'mka',
        'text/x-markdown' => 'mkd',
        'video/x-matroska' => 'mkv',
        'application/vnd.dolby.mlp' => 'mlp',
        'application/vnd.chipnuts.karaoke-mmd' => 'mmd',
        'application/vnd.smaf' => 'mmf',
        'text/mathml' => 'mml',
        'image/vnd.fujixerox.edmics-mmr' => 'mmr',
        'video/x-mng' => 'mng',
        'application/x-msmoney' => 'mny',
        'application/x-mobipocket-ebook' => 'mobi',
        'application/mods+xml' => 'mods',
        'video/quicktime' => 'mov',
        'video/x-sgi-movie' => 'movie',
        'audio/mpeg' => 'mp3',
        'video/mp4' => 'mp4',
        'application/mp4' => 'mp4s',
        'video/mp4' => 'mp4v',
        'application/mp21' => 'mp21',
        'application/vnd.mophun.certificate' => 'mpc',
        'application/dash+xml' => 'mpd',
        'video/mpeg' => 'mpe',
        'video/mpeg' => 'mpeg',
        'application/media-policy-dataset+xml' => 'mpf',
        'video/mpeg' => 'mpg',
        'video/mp4' => 'mpg4',
        'audio/mpeg' => 'mpga',
        'application/vnd.apple.installer+xml' => 'mpkg',
        'application/vnd.blueice.multipass' => 'mpm',
        'application/vnd.mophun.application' => 'mpn',
        'application/vnd.ms-project' => 'mpp',
        'application/vnd.ms-project' => 'mpt',
        'application/vnd.ibm.minipay' => 'mpy',
        'application/vnd.mobius.mqy' => 'mqy',
        'application/marc' => 'mrc',
        'application/marcxml+xml' => 'mrcx',
        'text/troff' => 'ms',
        'application/mediaservercontrol+xml' => 'mscml',
        'application/vnd.fdsn.mseed' => 'mseed',
        'application/vnd.mseq' => 'mseq',
        'application/vnd.epson.msf' => 'msf',
        'application/vnd.ms-outlook' => 'msg',
        'model/mesh' => 'msh',
        'application/x-msdownload' => 'msi',
        'application/vnd.mobius.msl' => 'msl',
        'application/octet-stream' => 'msm',
        'application/octet-stream' => 'msp',
        'application/vnd.muvee.style' => 'msty',
        'model/mtl' => 'mtl',
        'model/vnd.mts' => 'mts',
        'application/vnd.musician' => 'mus',
        'application/mmt-usd+xml' => 'musd',
        'application/vnd.recordare.musicxml+xml' => 'musicxml',
        'application/x-msmediaview' => 'mvb',
        'application/vnd.mapbox-vector-tile' => 'mvt',
        'application/vnd.mfer' => 'mwf',
        'application/mxf' => 'mxf',
        'application/vnd.recordare.musicxml' => 'mxl',
        'audio/mobile-xmf' => 'mxmf',
        'application/xv+xml' => 'mxml',
        'application/vnd.triscape.mxs' => 'mxs',
        'video/vnd.mpegurl' => 'mxu',
        'application/vnd.nokia.n-gage.symbian.install' => 'n-gage',
        'text/n3' => 'n3',
        'application/mathematica' => 'nb',
        'application/vnd.wolfram.player' => 'nbp',
        'application/x-netcdf' => 'nc',
        'application/x-dtbncx+xml' => 'ncx',
        'text/x-nfo' => 'nfo',
        'application/vnd.nokia.n-gage.data' => 'ngdat',
        'application/vnd.nitf' => 'nitf',
        'application/vnd.neurolanguage.nlu' => 'nlu',
        'application/vnd.enliven' => 'nml',
        'application/vnd.noblenet-directory' => 'nnd',
        'application/vnd.noblenet-sealer' => 'nns',
        'application/vnd.noblenet-web' => 'nnw',
        'image/vnd.net-fpx' => 'npx',
        'application/n-quads' => 'nq',
        'application/x-conference' => 'nsc',
        'application/vnd.lotus-notes' => 'nsf',
        'application/n-triples' => 'nt',
        'application/vnd.nitf' => 'ntf',
        'application/x-iwork-numbers-sffnumbers' => 'numbers',
        'application/x-nzb' => 'nzb',
        'application/vnd.fujitsu.oasys2' => 'oa2',
        'application/vnd.fujitsu.oasys3' => 'oa3',
        'application/vnd.fujitsu.oasys' => 'oas',
        'application/x-msbinder' => 'obd',
        'application/vnd.openblox.game+xml' => 'obgx',
        'model/obj' => 'obj',
        'application/oda' => 'oda',
        'application/vnd.oasis.opendocument.database' => 'odb',
        'application/vnd.oasis.opendocument.chart' => 'odc',
        'application/vnd.oasis.opendocument.formula' => 'odf',
        'application/vnd.oasis.opendocument.formula-template' => 'odft',
        'application/vnd.oasis.opendocument.graphics' => 'odg',
        'application/vnd.oasis.opendocument.image' => 'odi',
        'application/vnd.oasis.opendocument.text-master' => 'odm',
        'application/vnd.oasis.opendocument.presentation' => 'odp',
        'application/vnd.oasis.opendocument.spreadsheet' => 'ods',
        'application/vnd.oasis.opendocument.text' => 'odt',
        'audio/ogg' => 'oga',
        'model/vnd.opengex' => 'ogex',
        'audio/ogg' => 'ogg',
        'video/ogg' => 'ogv',
        'application/ogg' => 'ogx',
        'application/omdoc+xml' => 'omdoc',
        'application/onenote' => 'onepkg',
        'application/oebps-package+xml' => 'opf',
        'text/x-opml' => 'opml',
        'application/vnd.palm' => 'oprc',
        'audio/ogg' => 'opus',
        'text/x-org' => 'org',
        'application/vnd.yamaha.openscoreformat' => 'osf',
        'application/vnd.yamaha.openscoreformat.osfpvg+xml' => 'osfpvg',
        'application/vnd.openstreetmap.data+xml' => 'osm',
        'application/vnd.oasis.opendocument.chart-template' => 'otc',
        'font/otf' => 'otf',
        'application/vnd.oasis.opendocument.graphics-template' => 'otg',
        'application/vnd.oasis.opendocument.text-web' => 'oth',
        'application/vnd.oasis.opendocument.image-template' => 'oti',
        'application/vnd.oasis.opendocument.presentation-template' => 'otp',
        'application/vnd.oasis.opendocument.spreadsheet-template' => 'ots',
        'application/vnd.oasis.opendocument.text-template' => 'ott',
        'application/x-virtualbox-ova' => 'ova',
        'application/x-virtualbox-ovf' => 'ovf',
        'application/rdf+xml' => 'owl',
        'application/oxps' => 'oxps',
        'application/vnd.openofficeorg.extension' => 'oxt',
        'text/x-pascal' => 'p',
        'application/x-pkcs7-signature' => 'p7a',
        'application/x-pkcs7-certificates' => 'p7b',
        'application/pkcs7-mime' => 'p7c',
        'application/pkcs7-mime' => 'p7m',
        'application/x-pkcs7-certreqresp' => 'p7r',
        'application/pkcs7-signature' => 'p7s',
        'application/pkcs8' => 'p8',
        'application/x-pkcs10' => 'p10',
        'application/x-pkcs12' => 'p12',
        'application/x-ns-proxy-autoconfig' => 'pac',
        'application/x-iwork-pages-sffpages' => 'pages',
        'text/x-pascal' => 'pas',
        'application/vnd.pawaafile' => 'paw',
        'application/vnd.powerbuilder6' => 'pbd',
        'image/x-portable-bitmap' => 'pbm',
        'application/vnd.tcpdump.pcap' => 'pcap',
        'application/x-font-pcf' => 'pcf',
        'application/vnd.hp-pcl' => 'pcl',
        'application/vnd.hp-pclxl' => 'pclxl',
        'image/x-pict' => 'pct',
        'application/vnd.curl.pcurl' => 'pcurl',
        'image/x-pcx' => 'pcx',
        'application/x-pilot' => 'pdb',
        'text/x-processing' => 'pde',
        'application/pdf' => 'pdf',
        'application/x-x509-user-cert' => 'pem',
        'application/x-font-type1' => 'pfa',
        'application/x-font-type1' => 'pfb',
        'application/x-font-type1' => 'pfm',
        'application/font-tdpfr' => 'pfr',
        'application/x-pkcs12' => 'pfx',
        'image/x-portable-graymap' => 'pgm',
        'application/x-chess-pgn' => 'pgn',
        'application/pgp' => 'pgp',
        'application/octet-stream' => 'phar',
        'application/x-httpd-php' => 'php',
        'image/x-pict' => 'pic',
        'application/octet-stream' => 'pkg',
        'application/pkixcmp' => 'pki',
        'application/pkix-pkipath' => 'pkipath',
        'application/vnd.apple.pkpass' => 'pkpass',
        'application/x-perl' => 'pl',
        'application/vnd.3gpp.pic-bw-large' => 'plb',
        'application/vnd.mobius.plc' => 'plc',
        'application/vnd.pocketlearn' => 'plf',
        'application/pls+xml' => 'pls',
        'application/x-perl' => 'pm',
        'application/vnd.ctc-posml' => 'pml',
        'image/png' => 'png',
        'image/x-portable-anymap' => 'pnm',
        'application/vnd.macports.portpkg' => 'portpkg',
        'application/vnd.ms-powerpoint' => 'pot',
        'application/vnd.ms-powerpoint.presentation.macroEnabled.12' => 'potm',
        'application/vnd.openxmlformats-officedocument.presentationml.template' => 'potx',
        'application/vnd.ms-powerpoint' => 'ppa',
        'application/vnd.ms-powerpoint.addin.macroEnabled.12' => 'ppam',
        'application/vnd.cups-ppd' => 'ppd',
        'image/x-portable-pixmap' => 'ppm',
        'application/vnd.ms-powerpoint' => 'pps',
        'application/vnd.ms-powerpoint.slideshow.macroEnabled.12' => 'ppsm',
        'application/vnd.openxmlformats-officedocument.presentationml.slideshow' => 'ppsx',
        'application/powerpoint' => 'ppt',
        'application/vnd.ms-powerpoint.presentation.macroEnabled.12' => 'pptm',
        'application/vnd.openxmlformats-officedocument.presentationml.presentation' => 'pptx',
        'application/vnd.palm' => 'pqa',
        'model/prc' => 'prc',
        'application/vnd.lotus-freelance' => 'pre',
        'application/pics-rules' => 'prf',
        'application/provenance+xml' => 'provx',
        'application/postscript' => 'ps',
        'application/vnd.3gpp.pic-bw-small' => 'psb',
        'application/x-photoshop' => 'psd',
        'application/x-font-linux-psf' => 'psf',
        'application/pskc+xml' => 'pskcxml',
        'image/prs.pti' => 'pti',
        'application/vnd.pvi.ptid1' => 'ptid',
        'application/x-mspublisher' => 'pub',
        'application/vnd.3gpp.pic-bw-var' => 'pvb',
        'application/vnd.3m.post-it-notes' => 'pwn',
        'audio/vnd.ms-playready.media.pya' => 'pya',
        'video/vnd.ms-playready.media.pyv' => 'pyv',
        'application/vnd.epson.quickanime' => 'qam',
        'application/vnd.intu.qbo' => 'qbo',
        'application/vnd.intu.qfx' => 'qfx',
        'application/vnd.publishare-delta-tree' => 'qps',
        'video/quicktime' => 'qt',
        'application/vnd.quark.quarkxpress' => 'qwd',
        'audio/x-realaudio' => 'ra',
        'audio/x-pn-realaudio' => 'ram',
        'application/raml+yaml' => 'raml',
        'application/route-apd+xml' => 'rapd',
        'application/x-rar' => 'rar',
        'image/x-cmu-raster' => 'ras',
        'application/vnd.ipunplugged.rcprofile' => 'rcprofile',
        'application/rdf+xml' => 'rdf',
        'application/vnd.data-vision.rdz' => 'rdz',
        'application/p2p-overlay+xml' => 'relo',
        'application/vnd.businessobjects' => 'rep',
        'application/x-dtbresource+xml' => 'res',
        'image/x-rgb' => 'rgb',
        'application/reginfo+xml' => 'rif',
        'audio/vnd.rip' => 'rip',
        'application/x-research-info-systems' => 'ris',
        'application/resource-lists+xml' => 'rl',
        'image/vnd.fujixerox.edmics-rlc' => 'rlc',
        'application/resource-lists-diff+xml' => 'rld',
        'audio/x-pn-realaudio' => 'rm',
        'audio/midi' => 'rmi',
        'audio/x-pn-realaudio-plugin' => 'rmp',
        'application/vnd.jcp.javame.midlet-rms' => 'rms',
        'application/vnd.rn-realmedia-vbr' => 'rmvb',
        'application/relax-ng-compact-syntax' => 'rnc',
        'application/xml' => 'rng',
        'application/rpki-roa' => 'roa',
        'text/troff' => 'roff',
        'application/vnd.cloanto.rp9' => 'rp9',
        'audio/x-pn-realaudio-plugin' => 'rpm',
        'application/vnd.nokia.radio-presets' => 'rpss',
        'application/vnd.nokia.radio-preset' => 'rpst',
        'application/sparql-query' => 'rq',
        'application/rls-services+xml' => 'rs',
        'application/x-pkcs7' => 'rsa',
        'application/atsc-rsat+xml' => 'rsat',
        'application/rsd+xml' => 'rsd',
        'application/urc-ressheet+xml' => 'rsheet',
        'application/rss+xml' => 'rss',
        'text/rtf' => 'rtf',
        'text/richtext' => 'rtx',
        'application/x-makeself' => 'run',
        'application/route-usd+xml' => 'rusd',
        'video/vnd.rn-realvideo' => 'rv',
        'text/x-asm' => 's',
        'audio/s3m' => 's3m',
        'application/vnd.yamaha.smaf-audio' => 'saf',
        'text/x-sass' => 'sass',
        'application/sbml+xml' => 'sbml',
        'application/vnd.ibm.secure-container' => 'sc',
        'application/x-msschedule' => 'scd',
        'application/vnd.lotus-screencam' => 'scm',
        'application/scvp-cv-request' => 'scq',
        'application/scvp-cv-response' => 'scs',
        'text/x-scss' => 'scss',
        'text/vnd.curl.scurl' => 'scurl',
        'application/vnd.stardivision.draw' => 'sda',
        'application/vnd.stardivision.calc' => 'sdc',
        'application/vnd.stardivision.impress' => 'sdd',
        'application/vnd.solent.sdkm+xml' => 'sdkd',
        'application/vnd.solent.sdkm+xml' => 'sdkm',
        'application/sdp' => 'sdp',
        'application/vnd.stardivision.writer' => 'sdw',
        'application/octet-stream' => 'sea',
        'application/vnd.seemail' => 'see',
        'application/vnd.fdsn.seed' => 'seed',
        'application/vnd.sema' => 'sema',
        'application/vnd.semd' => 'semd',
        'application/vnd.semf' => 'semf',
        'application/senml+xml' => 'senmlx',
        'application/sensml+xml' => 'sensmlx',
        'application/java-serialized-object' => 'ser',
        'application/set-payment-initiation' => 'setpay',
        'application/set-registration-initiation' => 'setreg',
        'application/vnd.hydrostatix.sof-data' => 'sfd-hdstx',
        'application/vnd.spotfire.sfs' => 'sfs',
        'text/x-sfv' => 'sfv',
        'image/sgi' => 'sgi',
        'application/vnd.stardivision.writer-global' => 'sgl',
        'text/sgml' => 'sgm',
        'text/sgml' => 'sgml',
        'application/x-sh' => 'sh',
        'application/x-shar' => 'shar',
        'text/shex' => 'shex',
        'application/shf+xml' => 'shf',
        'text/html' => 'shtml',
        'image/x-mrsid-image' => 'sid',
        'application/sieve' => 'sieve',
        'application/pgp-signature' => 'sig',
        'audio/silk' => 'sil',
        'model/mesh' => 'silo',
        'application/vnd.symbian.install' => 'sis',
        'application/vnd.symbian.install' => 'sisx',
        'application/x-stuffit' => 'sit',
        'application/x-stuffitx' => 'sitx',
        'application/sieve' => 'siv',
        'application/vnd.koan' => 'skd',
        'application/vnd.ms-powerpoint.slide.macroenabled.12' => 'sldm',
        'application/vnd.openxmlformats-officedocument.presentationml.slide' => 'sldx',
        'text/slim' => 'slim',
        'text/slim' => 'slm',
        'application/route-s-tsid+xml' => 'sls',
        'application/vnd.epson.salt' => 'slt',
        'application/vnd.stepmania.stepchart' => 'sm',
        'application/vnd.stardivision.math' => 'smf',
        'application/smil' => 'smi',
        'application/smil' => 'smil',
        'video/x-smv' => 'smv',
        'application/vnd.stepmania.package' => 'smzip',
        'audio/basic' => 'snd',
        'application/x-font-snf' => 'snf',
        'application/octet-stream' => 'so',
        'application/x-pkcs7-certificates' => 'spc',
        'text/spdx' => 'spdx',
        'application/vnd.yamaha.smaf-phrase' => 'spf',
        'application/x-futuresplash' => 'spl',
        'text/vnd.in3d.spot' => 'spot',
        'application/scvp-vp-response' => 'spp',
        'application/scvp-vp-request' => 'spq',
        'audio/ogg' => 'spx',
        'application/x-sql' => 'sql',
        'application/x-wais-source' => 'src',
        'application/x-subrip' => 'srt',
        'application/sru+xml' => 'sru',
        'application/sparql-results+xml' => 'srx',
        'application/ssdl+xml' => 'ssdl',
        'application/vnd.kodak-descriptor' => 'sse',
        'application/vnd.epson.ssf' => 'ssf',
        'application/ssml+xml' => 'ssml',
        'application/octet-stream' => 'sst',
        'application/vnd.sailingtracker.track' => 'st',
        'application/vnd.sun.xml.calc.template' => 'stc',
        'application/vnd.sun.xml.draw.template' => 'std',
        'application/vnd.wt.stf' => 'stf',
        'application/vnd.sun.xml.impress.template' => 'sti',
        'application/hyperstudio' => 'stk',
        'model/stl' => 'stl',
        'model/step+xml' => 'stpx',
        'model/step-xml+zip' => 'stpxz',
        'model/step+zip' => 'stpz',
        'application/vnd.pg.format' => 'str',
        'application/vnd.sun.xml.writer.template' => 'stw',
        'text/stylus' => 'styl',
        'text/stylus' => 'stylus',
        'text/vnd.dvb.subtitle' => 'sub',
        'application/vnd.sus-calendar' => 'sus',
        'application/vnd.sus-calendar' => 'susp',
        'application/x-sv4cpio' => 'sv4cpio',
        'application/x-sv4crc' => 'sv4crc',
        'application/vnd.dvb.service' => 'svc',
        'application/vnd.svd' => 'svd',
        'image/svg+xml' => 'svg',
        'image/svg+xml' => 'svgz',
        'application/x-director' => 'swa',
        'application/x-shockwave-flash' => 'swf',
        'application/vnd.aristanetworks.swi' => 'swi',
        'application/swid+xml' => 'swidtag',
        'application/vnd.sun.xml.calc' => 'sxc',
        'application/vnd.sun.xml.draw' => 'sxd',
        'application/vnd.sun.xml.writer.global' => 'sxg',
        'application/vnd.sun.xml.impress' => 'sxi',
        'application/vnd.sun.xml.math' => 'sxm',
        'application/vnd.sun.xml.writer' => 'sxw',
        'text/troff' => 't',
        'application/x-t3vm-image' => 't3',
        'image/t38' => 't38',
        'application/vnd.mynfc' => 'taglet',
        'application/vnd.tao.intent-module-archive' => 'tao',
        'image/vnd.tencent.tap' => 'tap',
        'application/x-tar' => 'tar',
        'application/vnd.3gpp2.tcap' => 'tcap',
        'application/x-tcl' => 'tcl',
        'application/urc-targetdesc+xml' => 'td',
        'application/vnd.smart.teacher' => 'teacher',
        'application/tei+xml' => 'tei',
        'application/tei+xml' => 'teicorpus',
        'application/x-tex' => 'tex',
        'application/x-texinfo' => 'texi',
        'application/x-texinfo' => 'texinfo',
        'text/plain' => 'text',
        'application/thraud+xml' => 'tfi',
        'application/x-tex-tfm' => 'tfm',
        'image/tiff-fx' => 'tfx',
        'image/x-tga' => 'tga',
        'application/x-tar' => 'tgz',
        'application/vnd.ms-officetheme' => 'thmx',
        'image/tiff' => 'tif',
        'image/tiff' => 'tiff',
        'application/x-tcl' => 'tk',
        'application/vnd.tmobile-livetv' => 'tmo',
        'application/toml' => 'toml',
        'application/x-bittorrent' => 'torrent',
        'application/vnd.groove-tool-template' => 'tpl',
        'application/vnd.trid.tpt' => 'tpt',
        'text/troff' => 'tr',
        'application/vnd.trueapp' => 'tra',
        'application/trig' => 'trig',
        'application/x-msterminal' => 'trm',
        'video/mp2t' => 'ts',
        'application/timestamped-data' => 'tsd',
        'text/tab-separated-values' => 'tsv',
        'font/collection' => 'ttc',
        'font/ttf' => 'ttf',
        'text/turtle' => 'ttl',
        'application/ttml+xml' => 'ttml',
        'application/vnd.simtech-mindmapper' => 'twd',
        'application/vnd.simtech-mindmapper' => 'twds',
        'application/vnd.genomatix.tuxedo' => 'txd',
        'application/vnd.mobius.txf' => 'txf',
        'text/plain' => 'txt',
        'model/u3d' => 'u3d',
        'message/global-delivery-status' => 'u8dsn',
        'message/global-headers' => 'u8hdr',
        'message/global-disposition-notification' => 'u8mdn',
        'message/global' => 'u8msg',
        'application/x-authorware-bin' => 'u32',
        'application/ubjson' => 'ubj',
        'application/x-debian-package' => 'udeb',
        'application/vnd.ufdl' => 'ufd',
        'application/x-glulx' => 'ulx',
        'application/vnd.umajin' => 'umj',
        'application/vnd.unity' => 'unityweb',
        'application/vnd.uoml+xml' => 'uoml',
        'text/uri-list' => 'urls',
        'model/vnd.usdz+zip' => 'usdz',
        'application/x-ustar' => 'ustar',
        'application/vnd.uiq.theme' => 'utz',
        'text/x-uuencode' => 'uu',
        'audio/vnd.dece.audio' => 'uva',
        'application/vnd.dece.data' => 'uvd',
        'application/vnd.dece.data' => 'uvf',
        'image/vnd.dece.graphic' => 'uvg',
        'video/vnd.dece.hd' => 'uvh',
        'image/vnd.dece.graphic' => 'uvi',
        'video/vnd.dece.mobile' => 'uvm',
        'video/vnd.dece.pd' => 'uvp',
        'video/vnd.dece.sd' => 'uvs',
        'application/vnd.dece.ttml+xml' => 'uvt',
        'video/vnd.uvvu.mp4' => 'uvu',
        'video/vnd.dece.video' => 'uvv',
        'audio/vnd.dece.audio' => 'uvva',
        'application/vnd.dece.data' => 'uvvd',
        'application/vnd.dece.data' => 'uvvf',
        'image/vnd.dece.graphic' => 'uvvg',
        'video/vnd.dece.hd' => 'uvvh',
        'image/vnd.dece.graphic' => 'uvvi',
        'video/vnd.dece.mobile' => 'uvvm',
        'video/vnd.dece.pd' => 'uvvp',
        'video/vnd.dece.sd' => 'uvvs',
        'application/vnd.dece.ttml+xml' => 'uvvt',
        'video/vnd.uvvu.mp4' => 'uvvu',
        'video/vnd.dece.video' => 'uvvv',
        'application/vnd.dece.unspecified' => 'uvvx',
        'application/vnd.dece.zip' => 'uvvz',
        'application/vnd.dece.unspecified' => 'uvx',
        'application/vnd.dece.zip' => 'uvz',
        'application/x-virtualbox-vbox' => 'vbox',
        'application/x-virtualbox-vbox-extpack' => 'vbox-extpack',
        'text/vcard' => 'vcard',
        'application/x-cdlink' => 'vcd',
        'text/x-vcard' => 'vcf',
        'application/vnd.groove-vcard' => 'vcg',
        'text/x-vcalendar' => 'vcs',
        'application/vnd.vcx' => 'vcx',
        'application/x-virtualbox-vdi' => 'vdi',
        'model/vnd.sap.vds' => 'vds',
        'application/x-virtualbox-vhd' => 'vhd',
        'application/vnd.visionary' => 'vis',
        'video/vnd.vivo' => 'viv',
        'application/videolan' => 'vlc',
        'application/x-virtualbox-vmdk' => 'vmdk',
        'video/x-ms-vob' => 'vob',
        'application/vnd.stardivision.writer' => 'vor',
        'application/x-authorware-bin' => 'vox',
        'model/vrml' => 'vrml',
        'application/vnd.visio' => 'vsd',
        'application/vnd.vsf' => 'vsf',
        'image/vnd.valve.source.texture' => 'vtf',
        'text/vtt' => 'vtt',
        'model/vnd.vtu' => 'vtu',
        'application/voicexml+xml' => 'vxml',
        'application/x-director' => 'w3d',
        'application/x-doom' => 'wad',
        'application/vnd.sun.wadl+xml' => 'wadl',
        'application/java-archive' => 'war',
        'application/wasm' => 'wasm',
        'audio/x-wav' => 'wav',
        'audio/x-ms-wax' => 'wax',
        'image/vnd.wap.wbmp' => 'wbmp',
        'application/vnd.criticaltools.wbs+xml' => 'wbs',
        'application/wbxml' => 'wbxml',
        'application/vnd.ms-works' => 'wcm',
        'application/vnd.ms-works' => 'wdb',
        'image/vnd.ms-photo' => 'wdp',
        'audio/webm' => 'weba',
        'application/x-web-app-manifest+json' => 'webapp',
        'video/webm' => 'webm',
        'application/manifest+json' => 'webmanifest',
        'image/webp' => 'webp',
        'application/vnd.pmi.widget' => 'wg',
        'application/widget' => 'wgt',
        'application/watcherinfo+xml' => 'wif',
        'application/vnd.ms-works' => 'wks',
        'video/x-ms-wm' => 'wm',
        'audio/x-ms-wma' => 'wma',
        'application/x-ms-wmd' => 'wmd',
        'image/wmf' => 'wmf',
        'text/vnd.wap.wml' => 'wml',
        'application/wmlc' => 'wmlc',
        'text/vnd.wap.wmlscript' => 'wmls',
        'application/vnd.wap.wmlscriptc' => 'wmlsc',
        'video/x-ms-wmv' => 'wmv',
        'video/x-ms-wmx' => 'wmx',
        'application/x-msmetafile' => 'wmz',
        'font/woff' => 'woff',
        'font/woff2' => 'woff2',
        'application/msword' => 'word',
        'application/vnd.wordperfect' => 'wpd',
        'application/vnd.ms-wpl' => 'wpl',
        'application/vnd.ms-works' => 'wps',
        'application/vnd.wqd' => 'wqd',
        'application/x-mswrite' => 'wri',
        'model/vrml' => 'wrl',
        'message/vnd.wfa.wsc' => 'wsc',
        'application/wsdl+xml' => 'wsdl',
        'application/wspolicy+xml' => 'wspolicy',
        'application/vnd.webturbo' => 'wtb',
        'video/x-ms-wvx' => 'wvx',
        'model/x3d+xml' => 'x3d',
        'model/x3d+fastinfoset' => 'x3db',
        'model/x3d+binary' => 'x3dbz',
        'model/x3d-vrml' => 'x3dv',
        'model/x3d+vrml' => 'x3dvz',
        'model/x3d+xml' => 'x3dz',
        'application/x-authorware-bin' => 'x32',
        'model/vnd.parasolid.transmit.binary' => 'x_b',
        'model/vnd.parasolid.transmit.text' => 'x_t',
        'application/xaml+xml' => 'xaml',
        'application/x-silverlight-app' => 'xap',
        'application/vnd.xara' => 'xar',
        'application/xcap-att+xml' => 'xav',
        'application/x-ms-xbap' => 'xbap',
        'application/vnd.fujixerox.docuworks.binder' => 'xbd',
        'image/x-xbitmap' => 'xbm',
        'application/xcap-caps+xml' => 'xca',
        'application/calendar+xml' => 'xcs',
        'application/xcap-diff+xml' => 'xdf',
        'application/vnd.syncml.dm+xml' => 'xdm',
        'application/vnd.adobe.xdp+xml' => 'xdp',
        'application/dssc+xml' => 'xdssc',
        'application/vnd.fujixerox.docuworks' => 'xdw',
        'application/xcap-el+xml' => 'xel',
        'application/xenc+xml' => 'xenc',
        'application/patch-ops-error+xml' => 'xer',
        'application/vnd.adobe.xfdf' => 'xfdf',
        'application/vnd.xfdl' => 'xfdl',
        'application/xhtml+xml' => 'xht',
        'application/xhtml+xml' => 'xhtml',
        'application/xv+xml' => 'xhvml',
        'image/vnd.xiff' => 'xif',
        'application/excel' => 'xl',
        'application/vnd.ms-excel' => 'xla',
        'application/vnd.ms-excel.addin.macroEnabled.12' => 'xlam',
        'application/vnd.ms-excel' => 'xlc',
        'application/xliff+xml' => 'xlf',
        'application/vnd.ms-excel' => 'xls',
        'application/vnd.ms-excel.sheet.binary.macroEnabled.12' => 'xlsb',
        'application/vnd.ms-excel.sheet.macroEnabled.12' => 'xlsm',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => 'xlsx',
        'application/vnd.ms-excel' => 'xlt',
        'application/vnd.ms-excel.template.macroEnabled.12' => 'xltm',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.template' => 'xltx',
        'application/vnd.ms-excel' => 'xlw',
        'audio/xm' => 'xm',
        'application/xml' => 'xml',
        'application/xcap-ns+xml' => 'xns',
        'application/vnd.olpc-sugar' => 'xo',
        'application/xop+xml' => 'xop',
        'application/x-xpinstall' => 'xpi',
        'application/xproc+xml' => 'xpl',
        'image/x-xpixmap' => 'xpm',
        'application/vnd.is-xpr' => 'xpr',
        'application/vnd.ms-xpsdocument' => 'xps',
        'application/vnd.intercon.formnet' => 'xpx',
        'application/xml' => 'xsd',
        'application/xml' => 'xsl',
        'application/xslt+xml' => 'xslt',
        'application/vnd.syncml+xml' => 'xsm',
        'application/xspf+xml' => 'xspf',
        'application/vnd.mozilla.xul+xml' => 'xul',
        'application/xv+xml' => 'xvm',
        'application/xv+xml' => 'xvml',
        'image/x-xwindowdump' => 'xwd',
        'chemical/x-xyz' => 'xyz',
        'application/x-xz' => 'xz',
        'text/yaml' => 'yaml',
        'application/yang' => 'yang',
        'application/yin+xml' => 'yin',
        'text/yaml' => 'yml',
        'text/x-suse-ymp' => 'ymp',
        'application/x-compress' => 'z',
        'application/x-zmachine' => 'z1',
        'application/vnd.zzazz.deck+xml' => 'zaz',
        'application/zip' => 'zip',
        'application/vnd.zul' => 'zir',
        'application/vnd.handheld-entertainment+xml' => 'zmm',
        'text/x-scriptzsh' => 'zsh',
    ];

$extToMime = [
    '1km' => 'application/vnd.1000minds.decision-model+xml',
    '3dml' => 'text/vnd.in3d.3dml',
    '3ds' => 'image/x-3ds',
    '3g2' => 'video/3gpp2',
    '3gp' => 'video/3gp',
    '3gpp' => 'video/3gpp',
    '3mf' => 'model/3mf',
    '7z' => 'application/x-7z-compressed',
    '7zip' => 'application/x-7z-compressed',
    '123' => 'application/vnd.lotus-1-2-3',
    'aab' => 'application/x-authorware-bin',
    'aac' => 'audio/x-acc',
    'aam' => 'application/x-authorware-map',
    'aas' => 'application/x-authorware-seg',
    'abw' => 'application/x-abiword',
    'ac' => 'application/vnd.nokia.n-gage.ac+xml',
    'ac3' => 'audio/ac3',
    'acc' => 'application/vnd.americandynamics.acc',
    'ace' => 'application/x-ace-compressed',
    'acu' => 'application/vnd.acucobol',
    'acutc' => 'application/vnd.acucorp',
    'adp' => 'audio/adpcm',
    'aep' => 'application/vnd.audiograph',
    'afm' => 'application/x-font-type1',
    'afp' => 'application/vnd.ibm.modcap',
    'age' => 'application/vnd.age',
    'ahead' => 'application/vnd.ahead.space',
    'ai' => 'application/pdf',
    'aif' => 'audio/x-aiff',
    'aifc' => 'audio/x-aiff',
    'aiff' => 'audio/x-aiff',
    'air' => 'application/vnd.adobe.air-application-installer-package+zip',
    'ait' => 'application/vnd.dvb.ait',
    'ami' => 'application/vnd.amiga.ami',
    'amr' => 'audio/amr',
    'apk' => 'application/vnd.android.package-archive',
    'apng' => 'image/apng',
    'appcache' => 'text/cache-manifest',
    'application' => 'application/x-ms-application',
    'apr' => 'application/vnd.lotus-approach',
    'arc' => 'application/x-freearc',
    'arj' => 'application/x-arj',
    'asc' => 'application/pgp-signature',
    'asf' => 'video/x-ms-asf',
    'asm' => 'text/x-asm',
    'aso' => 'application/vnd.accpac.simply.aso',
    'asx' => 'video/x-ms-asf',
    'atc' => 'application/vnd.acucorp',
    'atom' => 'application/atom+xml',
    'atomcat' => 'application/atomcat+xml',
    'atomdeleted' => 'application/atomdeleted+xml',
    'atomsvc' => 'application/atomsvc+xml',
    'atx' => 'application/vnd.antix.game-component',
    'au' => 'audio/x-au',
    'avci' => 'image/avci',
    'avcs' => 'image/avcs',
    'avi' => 'video/x-msvideo',
    'avif' => 'image/avif',
    'aw' => 'application/applixware',
    'azf' => 'application/vnd.airzip.filesecure.azf',
    'azs' => 'application/vnd.airzip.filesecure.azs',
    'azv' => 'image/vnd.airzip.accelerator.azv',
    'azw' => 'application/vnd.amazon.ebook',
    'b16' => 'image/vnd.pco.b16',
    'bat' => 'application/x-msdownload',
    'bcpio' => 'application/x-bcpio',
    'bdf' => 'application/x-font-bdf',
    'bdm' => 'application/vnd.syncml.dm+wbxml',
    'bdoc' => 'application/x-bdoc',
    'bed' => 'application/vnd.realvnc.bed',
    'bh2' => 'application/vnd.fujitsu.oasysprs',
    'bin' => 'application/octet-stream',
    'blb' => 'application/x-blorb',
    'blorb' => 'application/x-blorb',
    'bmi' => 'application/vnd.bmi',
    'bmml' => 'application/vnd.balsamiq.bmml+xml',
    'bmp' => 'image/bmp',
    'book' => 'application/vnd.framemaker',
    'box' => 'application/vnd.previewsystems.box',
    'boz' => 'application/x-bzip2',
    'bpk' => 'application/octet-stream',
    'bpmn' => 'application/octet-stream',
    'bsp' => 'model/vnd.valve.source.compiled-map',
    'btif' => 'image/prs.btif',
    'buffer' => 'application/octet-stream',
    'bz' => 'application/x-bzip',
    'bz2' => 'application/x-bzip2',
    'c' => 'text/x-c',
    'c4d' => 'application/vnd.clonk.c4group',
    'c4f' => 'application/vnd.clonk.c4group',
    'c4g' => 'application/vnd.clonk.c4group',
    'c4p' => 'application/vnd.clonk.c4group',
    'c4u' => 'application/vnd.clonk.c4group',
    'c11amc' => 'application/vnd.cluetrust.cartomobile-config',
    'c11amz' => 'application/vnd.cluetrust.cartomobile-config-pkg',
    'cab' => 'application/vnd.ms-cab-compressed',
    'caf' => 'audio/x-caf',
    'cap' => 'application/vnd.tcpdump.pcap',
    'car' => 'application/vnd.curl.car',
    'cat' => 'application/vnd.ms-pki.seccat',
    'cb7' => 'application/x-cbr',
    'cba' => 'application/x-cbr',
    'cbr' => 'application/x-cbr',
    'cbt' => 'application/x-cbr',
    'cbz' => 'application/x-cbr',
    'cc' => 'text/x-c',
    'cco' => 'application/x-cocoa',
    'cct' => 'application/x-director',
    'ccxml' => 'application/ccxml+xml',
    'cdbcmsg' => 'application/vnd.contact.cmsg',
    'cdf' => 'application/x-netcdf',
    'cdfx' => 'application/cdfx+xml',
    'cdkey' => 'application/vnd.mediastation.cdkey',
    'cdmia' => 'application/cdmi-capability',
    'cdmic' => 'application/cdmi-container',
    'cdmid' => 'application/cdmi-domain',
    'cdmio' => 'application/cdmi-object',
    'cdmiq' => 'application/cdmi-queue',
    'cdr' => 'application/cdr',
    'cdx' => 'chemical/x-cdx',
    'cdxml' => 'application/vnd.chemdraw+xml',
    'cdy' => 'application/vnd.cinderella',
    'cer' => 'application/pkix-cert',
    'cfs' => 'application/x-cfs-compressed',
    'cgm' => 'image/cgm',
    'chat' => 'application/x-chat',
    'chm' => 'application/vnd.ms-htmlhelp',
    'chrt' => 'application/vnd.kde.kchart',
    'cif' => 'chemical/x-cif',
    'cii' => 'application/vnd.anser-web-certificate-issue-initiation',
    'cil' => 'application/vnd.ms-artgalry',
    'cjs' => 'application/node',
    'cla' => 'application/vnd.claymore',
    'class' => 'application/octet-stream',
    'clkk' => 'application/vnd.crick.clicker.keyboard',
    'clkp' => 'application/vnd.crick.clicker.palette',
    'clkt' => 'application/vnd.crick.clicker.template',
    'clkw' => 'application/vnd.crick.clicker.wordbank',
    'clkx' => 'application/vnd.crick.clicker',
    'clp' => 'application/x-msclip',
    'cmc' => 'application/vnd.cosmocaller',
    'cmdf' => 'chemical/x-cmdf',
    'cml' => 'chemical/x-cml',
    'cmp' => 'application/vnd.yellowriver-custom-menu',
    'cmx' => 'image/x-cmx',
    'cod' => 'application/vnd.rim.cod',
    'coffee' => 'text/coffeescript',
    'com' => 'application/x-msdownload',
    'conf' => 'text/plain',
    'cpio' => 'application/x-cpio',
    'cpl' => 'application/cpl+xml',
    'cpp' => 'text/x-c',
    'cpt' => 'application/mac-compactpro',
    'crd' => 'application/x-mscardfile',
    'crl' => 'application/pkix-crl',
    'crt' => 'application/x-x509-ca-cert',
    'crx' => 'application/x-chrome-extension',
    'cryptonote' => 'application/vnd.rig.cryptonote',
    'csh' => 'application/x-csh',
    'csl' => 'application/vnd.citationstyles.style+xml',
    'csml' => 'chemical/x-csml',
    'csp' => 'application/vnd.commonspace',
    'csr' => 'application/octet-stream',
    'css' => 'text/css',
    'cst' => 'application/x-director',
    'csv' => 'text/csv',
    'cu' => 'application/cu-seeme',
    'curl' => 'text/vnd.curl',
    'cww' => 'application/prs.cww',
    'cxt' => 'application/x-director',
    'cxx' => 'text/x-c',
    'dae' => 'model/vnd.collada+xml',
    'daf' => 'application/vnd.mobius.daf',
    'dart' => 'application/vnd.dart',
    'dataless' => 'application/vnd.fdsn.seed',
    'davmount' => 'application/davmount+xml',
    'dbf' => 'application/vnd.dbf',
    'dbk' => 'application/docbook+xml',
    'dcr' => 'application/x-director',
    'dcurl' => 'text/vnd.curl.dcurl',
    'dd2' => 'application/vnd.oma.dd2+xml',
    'ddd' => 'application/vnd.fujixerox.ddd',
    'ddf' => 'application/vnd.syncml.dmddf+xml',
    'dds' => 'image/vnd.ms-dds',
    'deb' => 'application/x-debian-package',
    'def' => 'text/plain',
    'deploy' => 'application/octet-stream',
    'der' => 'application/x-x509-ca-cert',
    'dfac' => 'application/vnd.dreamfactory',
    'dgc' => 'application/x-dgc-compressed',
    'dic' => 'text/x-c',
    'dir' => 'application/x-director',
    'dis' => 'application/vnd.mobius.dis',
    'disposition-notification' => 'message/disposition-notification',
    'dist' => 'application/octet-stream',
    'distz' => 'application/octet-stream',
    'djv' => 'image/vnd.djvu',
    'djvu' => 'image/vnd.djvu',
    'dll' => 'application/octet-stream',
    'dmg' => 'application/x-apple-diskimage',
    'dmn' => 'application/octet-stream',
    'dmp' => 'application/vnd.tcpdump.pcap',
    'dms' => 'application/octet-stream',
    'dna' => 'application/vnd.dna',
    'doc' => 'application/msword',
    'docm' => 'application/vnd.ms-word.template.macroEnabled.12',
    'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'dot' => 'application/msword',
    'dotm' => 'application/vnd.ms-word.template.macroEnabled.12',
    'dotx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
    'dp' => 'application/vnd.osgi.dp',
    'dpg' => 'application/vnd.dpgraph',
    'dra' => 'audio/vnd.dra',
    'drle' => 'image/dicom-rle',
    'dsc' => 'text/prs.lines.tag',
    'dssc' => 'application/dssc+der',
    'dtb' => 'application/x-dtbook+xml',
    'dtd' => 'application/xml-dtd',
    'dts' => 'audio/vnd.dts',
    'dtshd' => 'audio/vnd.dts.hd',
    'dump' => 'application/octet-stream',
    'dvb' => 'video/vnd.dvb.file',
    'dvi' => 'application/x-dvi',
    'dwd' => 'application/atsc-dwd+xml',
    'dwf' => 'model/vnd.dwf',
    'dwg' => 'image/vnd.dwg',
    'dxf' => 'image/vnd.dxf',
    'dxp' => 'application/vnd.spotfire.dxp',
    'dxr' => 'application/x-director',
    'ear' => 'application/java-archive',
    'ecelp4800' => 'audio/vnd.nuera.ecelp4800',
    'ecelp7470' => 'audio/vnd.nuera.ecelp7470',
    'ecelp9600' => 'audio/vnd.nuera.ecelp9600',
    'ecma' => 'application/ecmascript',
    'edm' => 'application/vnd.novadigm.edm',
    'edx' => 'application/vnd.novadigm.edx',
    'efif' => 'application/vnd.picsel',
    'ei6' => 'application/vnd.pg.osasli',
    'elc' => 'application/octet-stream',
    'emf' => 'image/emf',
    'eml' => 'message/rfc822',
    'emma' => 'application/emma+xml',
    'emotionml' => 'application/emotionml+xml',
    'emz' => 'application/x-msmetafile',
    'eol' => 'audio/vnd.digital-winds',
    'eot' => 'application/vnd.ms-fontobject',
    'eps' => 'application/postscript',
    'epub' => 'application/epub+zip',
    'es' => 'application/ecmascript',
    'es3' => 'application/vnd.eszigno3+xml',
    'esa' => 'application/vnd.osgi.subsystem',
    'esf' => 'application/vnd.epson.esf',
    'et3' => 'application/vnd.eszigno3+xml',
    'etx' => 'text/x-setext',
    'eva' => 'application/x-eva',
    'evy' => 'application/x-envoy',
    'exe' => 'application/octet-stream',
    'exi' => 'application/exi',
    'exp' => 'application/express',
    'exr' => 'image/aces',
    'ext' => 'application/vnd.novadigm.ext',
    'ez' => 'application/andrew-inset',
    'ez2' => 'application/vnd.ezpix-album',
    'ez3' => 'application/vnd.ezpix-package',
    'f' => 'text/x-fortran',
    'f4v' => 'video/mp4',
    'f77' => 'text/x-fortran',
    'f90' => 'text/x-fortran',
    'fbs' => 'image/vnd.fastbidsheet',
    'fcdt' => 'application/vnd.adobe.formscentral.fcdt',
    'fcs' => 'application/vnd.isac.fcs',
    'fdf' => 'application/vnd.fdf',
    'fdt' => 'application/fdt+xml',
    'fe_launch' => 'application/vnd.denovo.fcselayout-link',
    'fg5' => 'application/vnd.fujitsu.oasysgp',
    'fgd' => 'application/x-director',
    'fh' => 'image/x-freehand',
    'fh4' => 'image/x-freehand',
    'fh5' => 'image/x-freehand',
    'fh7' => 'image/x-freehand',
    'fhc' => 'image/x-freehand',
    'fig' => 'application/x-xfig',
    'fits' => 'image/fits',
    'flac' => 'audio/x-flac',
    'fli' => 'video/x-fli',
    'flo' => 'application/vnd.micrografx.flo',
    'flv' => 'video/x-flv',
    'flw' => 'application/vnd.kde.kivio',
    'flx' => 'text/vnd.fmi.flexstor',
    'fly' => 'text/vnd.fly',
    'fm' => 'application/vnd.framemaker',
    'fnc' => 'application/vnd.frogans.fnc',
    'fo' => 'application/vnd.software602.filler.form+xml',
    'for' => 'text/x-fortran',
    'fpx' => 'image/vnd.fpx',
    'frame' => 'application/vnd.framemaker',
    'fsc' => 'application/vnd.fsc.weblaunch',
    'fst' => 'image/vnd.fst',
    'ftc' => 'application/vnd.fluxtime.clip',
    'fti' => 'application/vnd.anser-web-funds-transfer-initiation',
    'fvt' => 'video/vnd.fvt',
    'fxp' => 'application/vnd.adobe.fxp',
    'fxpl' => 'application/vnd.adobe.fxp',
    'fzs' => 'application/vnd.fuzzysheet',
    'g2w' => 'application/vnd.geoplan',
    'g3' => 'image/g3fax',
    'g3w' => 'application/vnd.geospace',
    'gac' => 'application/vnd.groove-account',
    'gam' => 'application/x-tads',
    'gbr' => 'application/rpki-ghostbusters',
    'gca' => 'application/x-gca-compressed',
    'gdl' => 'model/vnd.gdl',
    'gdoc' => 'application/vnd.google-apps.document',
    'ged' => 'text/vnd.familysearch.gedcom',
    'geo' => 'application/vnd.dynageo',
    'geojson' => 'application/geo+json',
    'gex' => 'application/vnd.geometry-explorer',
    'ggb' => 'application/vnd.geogebra.file',
    'ggt' => 'application/vnd.geogebra.tool',
    'ghf' => 'application/vnd.groove-help',
    'gif' => 'image/gif',
    'gim' => 'application/vnd.groove-identity-message',
    'glb' => 'model/gltf-binary',
    'gltf' => 'model/gltf+json',
    'gml' => 'application/gml+xml',
    'gmx' => 'application/vnd.gmx',
    'gnumeric' => 'application/x-gnumeric',
    'gpg' => 'application/gpg-keys',
    'gph' => 'application/vnd.flographit',
    'gpx' => 'application/gpx+xml',
    'gqf' => 'application/vnd.grafeq',
    'gqs' => 'application/vnd.grafeq',
    'gram' => 'application/srgs',
    'gramps' => 'application/x-gramps-xml',
    'gre' => 'application/vnd.geometry-explorer',
    'grv' => 'application/vnd.groove-injector',
    'grxml' => 'application/srgs+xml',
    'gsf' => 'application/x-font-ghostscript',
    'gsheet' => 'application/vnd.google-apps.spreadsheet',
    'gslides' => 'application/vnd.google-apps.presentation',
    'gtar' => 'application/x-gtar',
    'gtm' => 'application/vnd.groove-tool-message',
    'gtw' => 'model/vnd.gtw',
    'gv' => 'text/vnd.graphviz',
    'gxf' => 'application/gxf',
    'gxt' => 'application/vnd.geonext',
    'gz' => 'application/gzip',
    'gzip' => 'application/gzip',
    'h' => 'text/x-c',
    'h261' => 'video/h261',
    'h263' => 'video/h263',
    'h264' => 'video/h264',
    'hal' => 'application/vnd.hal+xml',
    'hbci' => 'application/vnd.hbci',
    'hbs' => 'text/x-handlebars-template',
    'hdd' => 'application/x-virtualbox-hdd',
    'hdf' => 'application/x-hdf',
    'heic' => 'image/heic',
    'heics' => 'image/heic-sequence',
    'heif' => 'image/heif',
    'heifs' => 'image/heif-sequence',
    'hej2' => 'image/hej2k',
    'held' => 'application/atsc-held+xml',
    'hh' => 'text/x-c',
    'hjson' => 'application/hjson',
    'hlp' => 'application/winhlp',
    'hpgl' => 'application/vnd.hp-hpgl',
    'hpid' => 'application/vnd.hp-hpid',
    'hps' => 'application/vnd.hp-hps',
    'hqx' => 'application/mac-binhex40',
    'hsj2' => 'image/hsj2',
    'htc' => 'text/x-component',
    'htke' => 'application/vnd.kenameaapp',
    'htm' => 'text/html',
    'html' => 'text/html',
    'hvd' => 'application/vnd.yamaha.hv-dic',
    'hvp' => 'application/vnd.yamaha.hv-voice',
    'hvs' => 'application/vnd.yamaha.hv-script',
    'i2g' => 'application/vnd.intergeo',
    'icc' => 'application/vnd.iccprofile',
    'ice' => 'x-conference/x-cooltalk',
    'icm' => 'application/vnd.iccprofile',
    'ico' => 'image/x-icon',
    'ics' => 'text/calendar',
    'ief' => 'image/ief',
    'ifb' => 'text/calendar',
    'ifm' => 'application/vnd.shana.informed.formdata',
    'iges' => 'model/iges',
    'igl' => 'application/vnd.igloader',
    'igm' => 'application/vnd.insors.igm',
    'igs' => 'model/iges',
    'igx' => 'application/vnd.micrografx.igx',
    'iif' => 'application/vnd.shana.informed.interchange',
    'img' => 'application/octet-stream',
    'imp' => 'application/vnd.accpac.simply.imp',
    'ims' => 'application/vnd.ms-ims',
    'in' => 'text/plain',
    'ini' => 'text/plain',
    'ink' => 'application/inkml+xml',
    'inkml' => 'application/inkml+xml',
    'install' => 'application/x-install-instructions',
    'iota' => 'application/vnd.astraea-software.iota',
    'ipfix' => 'application/ipfix',
    'ipk' => 'application/vnd.shana.informed.package',
    'irm' => 'application/vnd.ibm.rights-management',
    'irp' => 'application/vnd.irepository.package+xml',
    'iso' => 'application/x-iso9660-image',
    'itp' => 'application/vnd.shana.informed.formtemplate',
    'its' => 'application/its+xml',
    'ivp' => 'application/vnd.immervision-ivp',
    'ivu' => 'application/vnd.immervision-ivu',
    'jad' => 'text/vnd.sun.j2me.app-descriptor',
    'jade' => 'text/jade',
    'jam' => 'application/vnd.jam',
    'jar' => 'application/java-archive',
    'jardiff' => 'application/x-java-archive-diff',
    'java' => 'text/x-java-source',
    'jhc' => 'image/jphc',
    'jisp' => 'application/vnd.jisp',
    'jls' => 'image/jls',
    'jlt' => 'application/vnd.hp-jlyt',
    'jng' => 'image/x-jng',
    'jnlp' => 'application/x-java-jnlp-file',
    'joda' => 'application/vnd.joost.joda-archive',
    'jp2' => 'image/jp2',
    'jpe' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'jpf' => 'image/jpx',
    'jpg' => 'image/jpeg',
    'jpg2' => 'image/jp2',
    'jpgm' => 'video/jpm',
    'jpgv' => 'video/jpeg',
    'jph' => 'image/jph',
    'jpm' => 'video/jpm',
    'jpx' => 'image/jpx',
    'js' => 'application/javascript',
    'json' => 'application/json',
    'json5' => 'application/json5',
    'jsonld' => 'application/ld+json',
    'jsonml' => 'application/jsonml+json',
    'jsx' => 'text/jsx',
    'jxr' => 'image/jxr',
    'jxra' => 'image/jxra',
    'jxrs' => 'image/jxrs',
    'jxs' => 'image/jxs',
    'jxsc' => 'image/jxsc',
    'jxsi' => 'image/jxsi',
    'jxss' => 'image/jxss',
    'kar' => 'audio/midi',
    'karbon' => 'application/vnd.kde.karbon',
    'kdb' => 'application/octet-stream',
    'kdbx' => 'application/x-keepass2',
    'key' => 'application/x-iwork-keynote-sffkey',
    'kfo' => 'application/vnd.kde.kformula',
    'kia' => 'application/vnd.kidspiration',
    'kml' => 'application/vnd.google-earth.kml+xml',
    'kmz' => 'application/vnd.google-earth.kmz',
    'kne' => 'application/vnd.kinar',
    'knp' => 'application/vnd.kinar',
    'kon' => 'application/vnd.kde.kontour',
    'kpr' => 'application/vnd.kde.kpresenter',
    'kpt' => 'application/vnd.kde.kpresenter',
    'kpxx' => 'application/vnd.ds-keypoint',
    'ksp' => 'application/vnd.kde.kspread',
    'ktr' => 'application/vnd.kahootz',
    'ktx' => 'image/ktx',
    'ktx2' => 'image/ktx2',
    'ktz' => 'application/vnd.kahootz',
    'kwd' => 'application/vnd.kde.kword',
    'kwt' => 'application/vnd.kde.kword',
    'lasxml' => 'application/vnd.las.las+xml',
    'latex' => 'application/x-latex',
    'lbd' => 'application/vnd.llamagraphics.life-balance.desktop',
    'lbe' => 'application/vnd.llamagraphics.life-balance.exchange+xml',
    'les' => 'application/vnd.hhe.lesson-player',
    'less' => 'text/less',
    'lgr' => 'application/lgr+xml',
    'lha' => 'application/octet-stream',
    'link66' => 'application/vnd.route66.link66+xml',
    'list' => 'text/plain',
    'list3820' => 'application/vnd.ibm.modcap',
    'listafp' => 'application/vnd.ibm.modcap',
    'litcoffee' => 'text/coffeescript',
    'lnk' => 'application/x-ms-shortcut',
    'log' => 'text/plain',
    'lostxml' => 'application/lost+xml',
    'lrf' => 'application/octet-stream',
    'lrm' => 'application/vnd.ms-lrm',
    'ltf' => 'application/vnd.frogans.ltf',
    'lua' => 'text/x-lua',
    'luac' => 'application/x-lua-bytecode',
    'lvp' => 'audio/vnd.lucent.voice',
    'lwp' => 'application/vnd.lotus-wordpro',
    'lzh' => 'application/octet-stream',
    'm1v' => 'video/mpeg',
    'm2a' => 'audio/mpeg',
    'm2v' => 'video/mpeg',
    'm3a' => 'audio/mpeg',
    'm3u' => 'text/plain',
    'm3u8' => 'application/vnd.apple.mpegurl',
    'm4a' => 'audio/x-m4a',
    'm4p' => 'application/mp4',
    'm4s' => 'video/iso.segment',
    'm4u' => 'application/vnd.mpegurl',
    'm4v' => 'video/x-m4v',
    'm13' => 'application/x-msmediaview',
    'm14' => 'application/x-msmediaview',
    'm21' => 'application/mp21',
    'ma' => 'application/mathematica',
    'mads' => 'application/mads+xml',
    'maei' => 'application/mmt-aei+xml',
    'mag' => 'application/vnd.ecowin.chart',
    'maker' => 'application/vnd.framemaker',
    'man' => 'text/troff',
    'manifest' => 'text/cache-manifest',
    'map' => 'application/json',
    'mar' => 'application/octet-stream',
    'markdown' => 'text/markdown',
    'mathml' => 'application/mathml+xml',
    'mb' => 'application/mathematica',
    'mbk' => 'application/vnd.mobius.mbk',
    'mbox' => 'application/mbox',
    'mc1' => 'application/vnd.medcalcdata',
    'mcd' => 'application/vnd.mcd',
    'mcurl' => 'text/vnd.curl.mcurl',
    'md' => 'text/markdown',
    'mdb' => 'application/x-msaccess',
    'mdi' => 'image/vnd.ms-modi',
    'mdx' => 'text/mdx',
    'me' => 'text/troff',
    'mesh' => 'model/mesh',
    'meta4' => 'application/metalink4+xml',
    'metalink' => 'application/metalink+xml',
    'mets' => 'application/mets+xml',
    'mfm' => 'application/vnd.mfmp',
    'mft' => 'application/rpki-manifest',
    'mgp' => 'application/vnd.osgeo.mapguide.package',
    'mgz' => 'application/vnd.proteus.magazine',
    'mid' => 'audio/midi',
    'midi' => 'audio/midi',
    'mie' => 'application/x-mie',
    'mif' => 'application/vnd.mif',
    'mime' => 'message/rfc822',
    'mj2' => 'video/mj2',
    'mjp2' => 'video/mj2',
    'mjs' => 'application/javascript',
    'mk3d' => 'video/x-matroska',
    'mka' => 'audio/x-matroska',
    'mkd' => 'text/x-markdown',
    'mks' => 'video/x-matroska',
    'mkv' => 'video/x-matroska',
    'mlp' => 'application/vnd.dolby.mlp',
    'mmd' => 'application/vnd.chipnuts.karaoke-mmd',
    'mmf' => 'application/vnd.smaf',
    'mml' => 'text/mathml',
    'mmr' => 'image/vnd.fujixerox.edmics-mmr',
    'mng' => 'video/x-mng',
    'mny' => 'application/x-msmoney',
    'mobi' => 'application/x-mobipocket-ebook',
    'mods' => 'application/mods+xml',
    'mov' => 'video/quicktime',
    'movie' => 'video/x-sgi-movie',
    'mp2' => 'audio/mpeg',
    'mp2a' => 'audio/mpeg',
    'mp3' => 'audio/mpeg',
    'mp4' => 'video/mp4',
    'mp4a' => 'audio/mp4',
    'mp4s' => 'application/mp4',
    'mp4v' => 'video/mp4',
    'mp21' => 'application/mp21',
    'mpc' => 'application/vnd.mophun.certificate',
    'mpd' => 'application/dash+xml',
    'mpe' => 'video/mpeg',
    'mpeg' => 'video/mpeg',
    'mpf' => 'application/media-policy-dataset+xml',
    'mpg' => 'video/mpeg',
    'mpg4' => 'video/mp4',
    'mpga' => 'audio/mpeg',
    'mpkg' => 'application/vnd.apple.installer+xml',
    'mpm' => 'application/vnd.blueice.multipass',
    'mpn' => 'application/vnd.mophun.application',
    'mpp' => 'application/vnd.ms-project',
    'mpt' => 'application/vnd.ms-project',
    'mpy' => 'application/vnd.ibm.minipay',
    'mqy' => 'application/vnd.mobius.mqy',
    'mrc' => 'application/marc',
    'mrcx' => 'application/marcxml+xml',
    'ms' => 'text/troff',
    'mscml' => 'application/mediaservercontrol+xml',
    'mseed' => 'application/vnd.fdsn.mseed',
    'mseq' => 'application/vnd.mseq',
    'msf' => 'application/vnd.epson.msf',
    'msg' => 'application/vnd.ms-outlook',
    'msh' => 'model/mesh',
    'msi' => 'application/x-msdownload',
    'msl' => 'application/vnd.mobius.msl',
    'msm' => 'application/octet-stream',
    'msp' => 'application/octet-stream',
    'msty' => 'application/vnd.muvee.style',
    'mtl' => 'model/mtl',
    'mts' => 'model/vnd.mts',
    'mus' => 'application/vnd.musician',
    'musd' => 'application/mmt-usd+xml',
    'musicxml' => 'application/vnd.recordare.musicxml+xml',
    'mvb' => 'application/x-msmediaview',
    'mvt' => 'application/vnd.mapbox-vector-tile',
    'mwf' => 'application/vnd.mfer',
    'mxf' => 'application/mxf',
    'mxl' => 'application/vnd.recordare.musicxml',
    'mxmf' => 'audio/mobile-xmf',
    'mxml' => 'application/xv+xml',
    'mxs' => 'application/vnd.triscape.mxs',
    'mxu' => 'video/vnd.mpegurl',
    'n-gage' => 'application/vnd.nokia.n-gage.symbian.install',
    'n3' => 'text/n3',
    'nb' => 'application/mathematica',
    'nbp' => 'application/vnd.wolfram.player',
    'nc' => 'application/x-netcdf',
    'ncx' => 'application/x-dtbncx+xml',
    'nfo' => 'text/x-nfo',
    'ngdat' => 'application/vnd.nokia.n-gage.data',
    'nitf' => 'application/vnd.nitf',
    'nlu' => 'application/vnd.neurolanguage.nlu',
    'nml' => 'application/vnd.enliven',
    'nnd' => 'application/vnd.noblenet-directory',
    'nns' => 'application/vnd.noblenet-sealer',
    'nnw' => 'application/vnd.noblenet-web',
    'npx' => 'image/vnd.net-fpx',
    'nq' => 'application/n-quads',
    'nsc' => 'application/x-conference',
    'nsf' => 'application/vnd.lotus-notes',
    'nt' => 'application/n-triples',
    'ntf' => 'application/vnd.nitf',
    'numbers' => 'application/x-iwork-numbers-sffnumbers',
    'nzb' => 'application/x-nzb',
    'oa2' => 'application/vnd.fujitsu.oasys2',
    'oa3' => 'application/vnd.fujitsu.oasys3',
    'oas' => 'application/vnd.fujitsu.oasys',
    'obd' => 'application/x-msbinder',
    'obgx' => 'application/vnd.openblox.game+xml',
    'obj' => 'model/obj',
    'oda' => 'application/oda',
    'odb' => 'application/vnd.oasis.opendocument.database',
    'odc' => 'application/vnd.oasis.opendocument.chart',
    'odf' => 'application/vnd.oasis.opendocument.formula',
    'odft' => 'application/vnd.oasis.opendocument.formula-template',
    'odg' => 'application/vnd.oasis.opendocument.graphics',
    'odi' => 'application/vnd.oasis.opendocument.image',
    'odm' => 'application/vnd.oasis.opendocument.text-master',
    'odp' => 'application/vnd.oasis.opendocument.presentation',
    'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
    'odt' => 'application/vnd.oasis.opendocument.text',
    'oga' => 'audio/ogg',
    'ogex' => 'model/vnd.opengex',
    'ogg' => 'audio/ogg',
    'ogv' => 'video/ogg',
    'ogx' => 'application/ogg',
    'omdoc' => 'application/omdoc+xml',
    'onepkg' => 'application/onenote',
    'onetmp' => 'application/onenote',
    'onetoc' => 'application/onenote',
    'onetoc2' => 'application/onenote',
    'opf' => 'application/oebps-package+xml',
    'opml' => 'text/x-opml',
    'oprc' => 'application/vnd.palm',
    'opus' => 'audio/ogg',
    'org' => 'text/x-org',
    'osf' => 'application/vnd.yamaha.openscoreformat',
    'osfpvg' => 'application/vnd.yamaha.openscoreformat.osfpvg+xml',
    'osm' => 'application/vnd.openstreetmap.data+xml',
    'otc' => 'application/vnd.oasis.opendocument.chart-template',
    'otf' => 'font/otf',
    'otg' => 'application/vnd.oasis.opendocument.graphics-template',
    'oth' => 'application/vnd.oasis.opendocument.text-web',
    'oti' => 'application/vnd.oasis.opendocument.image-template',
    'otp' => 'application/vnd.oasis.opendocument.presentation-template',
    'ots' => 'application/vnd.oasis.opendocument.spreadsheet-template',
    'ott' => 'application/vnd.oasis.opendocument.text-template',
    'ova' => 'application/x-virtualbox-ova',
    'ovf' => 'application/x-virtualbox-ovf',
    'owl' => 'application/rdf+xml',
    'oxps' => 'application/oxps',
    'oxt' => 'application/vnd.openofficeorg.extension',
    'p' => 'text/x-pascal',
    'p7a' => 'application/x-pkcs7-signature',
    'p7b' => 'application/x-pkcs7-certificates',
    'p7c' => 'application/pkcs7-mime',
    'p7m' => 'application/pkcs7-mime',
    'p7r' => 'application/x-pkcs7-certreqresp',
    'p7s' => 'application/pkcs7-signature',
    'p8' => 'application/pkcs8',
    'p10' => 'application/x-pkcs10',
    'p12' => 'application/x-pkcs12',
    'pac' => 'application/x-ns-proxy-autoconfig',
    'pages' => 'application/x-iwork-pages-sffpages',
    'pas' => 'text/x-pascal',
    'paw' => 'application/vnd.pawaafile',
    'pbd' => 'application/vnd.powerbuilder6',
    'pbm' => 'image/x-portable-bitmap',
    'pcap' => 'application/vnd.tcpdump.pcap',
    'pcf' => 'application/x-font-pcf',
    'pcl' => 'application/vnd.hp-pcl',
    'pclxl' => 'application/vnd.hp-pclxl',
    'pct' => 'image/x-pict',
    'pcurl' => 'application/vnd.curl.pcurl',
    'pcx' => 'image/x-pcx',
    'pdb' => 'application/x-pilot',
    'pde' => 'text/x-processing',
    'pdf' => 'application/pdf',
    'pem' => 'application/x-x509-user-cert',
    'pfa' => 'application/x-font-type1',
    'pfb' => 'application/x-font-type1',
    'pfm' => 'application/x-font-type1',
    'pfr' => 'application/font-tdpfr',
    'pfx' => 'application/x-pkcs12',
    'pgm' => 'image/x-portable-graymap',
    'pgn' => 'application/x-chess-pgn',
    'pgp' => 'application/pgp',
    'phar' => 'application/octet-stream',
    'php' => 'application/x-httpd-php',
    'php3' => 'application/x-httpd-php',
    'php4' => 'application/x-httpd-php',
    'phps' => 'application/x-httpd-php-source',
    'phtml' => 'application/x-httpd-php',
    'pic' => 'image/x-pict',
    'pkg' => 'application/octet-stream',
    'pki' => 'application/pkixcmp',
    'pkipath' => 'application/pkix-pkipath',
    'pkpass' => 'application/vnd.apple.pkpass',
    'pl' => 'application/x-perl',
    'plb' => 'application/vnd.3gpp.pic-bw-large',
    'plc' => 'application/vnd.mobius.plc',
    'plf' => 'application/vnd.pocketlearn',
    'pls' => 'application/pls+xml',
    'pm' => 'application/x-perl',
    'pml' => 'application/vnd.ctc-posml',
    'png' => 'image/png',
    'pnm' => 'image/x-portable-anymap',
    'portpkg' => 'application/vnd.macports.portpkg',
    'pot' => 'application/vnd.ms-powerpoint',
    'potm' => 'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
    'potx' => 'application/vnd.openxmlformats-officedocument.presentationml.template',
    'ppa' => 'application/vnd.ms-powerpoint',
    'ppam' => 'application/vnd.ms-powerpoint.addin.macroEnabled.12',
    'ppd' => 'application/vnd.cups-ppd',
    'ppm' => 'image/x-portable-pixmap',
    'pps' => 'application/vnd.ms-powerpoint',
    'ppsm' => 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12',
    'ppsx' => 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
    'ppt' => 'application/powerpoint',
    'pptm' => 'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
    'pptx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'pqa' => 'application/vnd.palm',
    'prc' => 'model/prc',
    'pre' => 'application/vnd.lotus-freelance',
    'prf' => 'application/pics-rules',
    'provx' => 'application/provenance+xml',
    'ps' => 'application/postscript',
    'psb' => 'application/vnd.3gpp.pic-bw-small',
    'psd' => 'application/x-photoshop',
    'psf' => 'application/x-font-linux-psf',
    'pskcxml' => 'application/pskc+xml',
    'pti' => 'image/prs.pti',
    'ptid' => 'application/vnd.pvi.ptid1',
    'pub' => 'application/x-mspublisher',
    'pvb' => 'application/vnd.3gpp.pic-bw-var',
    'pwn' => 'application/vnd.3m.post-it-notes',
    'pya' => 'audio/vnd.ms-playready.media.pya',
    'pyv' => 'video/vnd.ms-playready.media.pyv',
    'qam' => 'application/vnd.epson.quickanime',
    'qbo' => 'application/vnd.intu.qbo',
    'qfx' => 'application/vnd.intu.qfx',
    'qps' => 'application/vnd.publishare-delta-tree',
    'qt' => 'video/quicktime',
    'qwd' => 'application/vnd.quark.quarkxpress',
    'qwt' => 'application/vnd.quark.quarkxpress',
    'qxb' => 'application/vnd.quark.quarkxpress',
    'qxd' => 'application/vnd.quark.quarkxpress',
    'qxl' => 'application/vnd.quark.quarkxpress',
    'qxt' => 'application/vnd.quark.quarkxpress',
    'ra' => 'audio/x-realaudio',
    'ram' => 'audio/x-pn-realaudio',
    'raml' => 'application/raml+yaml',
    'rapd' => 'application/route-apd+xml',
    'rar' => 'application/x-rar',
    'ras' => 'image/x-cmu-raster',
    'rcprofile' => 'application/vnd.ipunplugged.rcprofile',
    'rdf' => 'application/rdf+xml',
    'rdz' => 'application/vnd.data-vision.rdz',
    'relo' => 'application/p2p-overlay+xml',
    'rep' => 'application/vnd.businessobjects',
    'res' => 'application/x-dtbresource+xml',
    'rgb' => 'image/x-rgb',
    'rif' => 'application/reginfo+xml',
    'rip' => 'audio/vnd.rip',
    'ris' => 'application/x-research-info-systems',
    'rl' => 'application/resource-lists+xml',
    'rlc' => 'image/vnd.fujixerox.edmics-rlc',
    'rld' => 'application/resource-lists-diff+xml',
    'rm' => 'audio/x-pn-realaudio',
    'rmi' => 'audio/midi',
    'rmp' => 'audio/x-pn-realaudio-plugin',
    'rms' => 'application/vnd.jcp.javame.midlet-rms',
    'rmvb' => 'application/vnd.rn-realmedia-vbr',
    'rnc' => 'application/relax-ng-compact-syntax',
    'rng' => 'application/xml',
    'roa' => 'application/rpki-roa',
    'roff' => 'text/troff',
    'rp9' => 'application/vnd.cloanto.rp9',
    'rpm' => 'audio/x-pn-realaudio-plugin',
    'rpss' => 'application/vnd.nokia.radio-presets',
    'rpst' => 'application/vnd.nokia.radio-preset',
    'rq' => 'application/sparql-query',
    'rs' => 'application/rls-services+xml',
    'rsa' => 'application/x-pkcs7',
    'rsat' => 'application/atsc-rsat+xml',
    'rsd' => 'application/rsd+xml',
    'rsheet' => 'application/urc-ressheet+xml',
    'rss' => 'application/rss+xml',
    'rtf' => 'text/rtf',
    'rtx' => 'text/richtext',
    'run' => 'application/x-makeself',
    'rusd' => 'application/route-usd+xml',
    'rv' => 'video/vnd.rn-realvideo',
    's' => 'text/x-asm',
    's3m' => 'audio/s3m',
    'saf' => 'application/vnd.yamaha.smaf-audio',
    'sass' => 'text/x-sass',
    'sbml' => 'application/sbml+xml',
    'sc' => 'application/vnd.ibm.secure-container',
    'scd' => 'application/x-msschedule',
    'scm' => 'application/vnd.lotus-screencam',
    'scq' => 'application/scvp-cv-request',
    'scs' => 'application/scvp-cv-response',
    'scss' => 'text/x-scss',
    'scurl' => 'text/vnd.curl.scurl',
    'sda' => 'application/vnd.stardivision.draw',
    'sdc' => 'application/vnd.stardivision.calc',
    'sdd' => 'application/vnd.stardivision.impress',
    'sdkd' => 'application/vnd.solent.sdkm+xml',
    'sdkm' => 'application/vnd.solent.sdkm+xml',
    'sdp' => 'application/sdp',
    'sdw' => 'application/vnd.stardivision.writer',
    'sea' => 'application/octet-stream',
    'see' => 'application/vnd.seemail',
    'seed' => 'application/vnd.fdsn.seed',
    'sema' => 'application/vnd.sema',
    'semd' => 'application/vnd.semd',
    'semf' => 'application/vnd.semf',
    'senmlx' => 'application/senml+xml',
    'sensmlx' => 'application/sensml+xml',
    'ser' => 'application/java-serialized-object',
    'setpay' => 'application/set-payment-initiation',
    'setreg' => 'application/set-registration-initiation',
    'sfd-hdstx' => 'application/vnd.hydrostatix.sof-data',
    'sfs' => 'application/vnd.spotfire.sfs',
    'sfv' => 'text/x-sfv',
    'sgi' => 'image/sgi',
    'sgl' => 'application/vnd.stardivision.writer-global',
    'sgm' => 'text/sgml',
    'sgml' => 'text/sgml',
    'sh' => 'application/x-sh',
    'shar' => 'application/x-shar',
    'shex' => 'text/shex',
    'shf' => 'application/shf+xml',
    'shtml' => 'text/html',
    'sid' => 'image/x-mrsid-image',
    'sieve' => 'application/sieve',
    'sig' => 'application/pgp-signature',
    'sil' => 'audio/silk',
    'silo' => 'model/mesh',
    'sis' => 'application/vnd.symbian.install',
    'sisx' => 'application/vnd.symbian.install',
    'sit' => 'application/x-stuffit',
    'sitx' => 'application/x-stuffitx',
    'siv' => 'application/sieve',
    'skd' => 'application/vnd.koan',
    'skm' => 'application/vnd.koan',
    'skp' => 'application/vnd.koan',
    'skt' => 'application/vnd.koan',
    'sldm' => 'application/vnd.ms-powerpoint.slide.macroenabled.12',
    'sldx' => 'application/vnd.openxmlformats-officedocument.presentationml.slide',
    'slim' => 'text/slim',
    'slm' => 'text/slim',
    'sls' => 'application/route-s-tsid+xml',
    'slt' => 'application/vnd.epson.salt',
    'sm' => 'application/vnd.stepmania.stepchart',
    'smf' => 'application/vnd.stardivision.math',
    'smi' => 'application/smil',
    'smil' => 'application/smil',
    'smv' => 'video/x-smv',
    'smzip' => 'application/vnd.stepmania.package',
    'snd' => 'audio/basic',
    'snf' => 'application/x-font-snf',
    'so' => 'application/octet-stream',
    'spc' => 'application/x-pkcs7-certificates',
    'spdx' => 'text/spdx',
    'spf' => 'application/vnd.yamaha.smaf-phrase',
    'spl' => 'application/x-futuresplash',
    'spot' => 'text/vnd.in3d.spot',
    'spp' => 'application/scvp-vp-response',
    'spq' => 'application/scvp-vp-request',
    'spx' => 'audio/ogg',
    'sql' => 'application/x-sql',
    'src' => 'application/x-wais-source',
    'srt' => 'application/x-subrip',
    'sru' => 'application/sru+xml',
    'srx' => 'application/sparql-results+xml',
    'ssdl' => 'application/ssdl+xml',
    'sse' => 'application/vnd.kodak-descriptor',
    'ssf' => 'application/vnd.epson.ssf',
    'ssml' => 'application/ssml+xml',
    'sst' => 'application/octet-stream',
    'st' => 'application/vnd.sailingtracker.track',
    'stc' => 'application/vnd.sun.xml.calc.template',
    'std' => 'application/vnd.sun.xml.draw.template',
    'stf' => 'application/vnd.wt.stf',
    'sti' => 'application/vnd.sun.xml.impress.template',
    'stk' => 'application/hyperstudio',
    'stl' => 'model/stl',
    'stpx' => 'model/step+xml',
    'stpxz' => 'model/step-xml+zip',
    'stpz' => 'model/step+zip',
    'str' => 'application/vnd.pg.format',
    'stw' => 'application/vnd.sun.xml.writer.template',
    'styl' => 'text/stylus',
    'stylus' => 'text/stylus',
    'sub' => 'text/vnd.dvb.subtitle',
    'sus' => 'application/vnd.sus-calendar',
    'susp' => 'application/vnd.sus-calendar',
    'sv4cpio' => 'application/x-sv4cpio',
    'sv4crc' => 'application/x-sv4crc',
    'svc' => 'application/vnd.dvb.service',
    'svd' => 'application/vnd.svd',
    'svg' => 'image/svg+xml',
    'svgz' => 'image/svg+xml',
    'swa' => 'application/x-director',
    'swf' => 'application/x-shockwave-flash',
    'swi' => 'application/vnd.aristanetworks.swi',
    'swidtag' => 'application/swid+xml',
    'sxc' => 'application/vnd.sun.xml.calc',
    'sxd' => 'application/vnd.sun.xml.draw',
    'sxg' => 'application/vnd.sun.xml.writer.global',
    'sxi' => 'application/vnd.sun.xml.impress',
    'sxm' => 'application/vnd.sun.xml.math',
    'sxw' => 'application/vnd.sun.xml.writer',
    't' => 'text/troff',
    't3' => 'application/x-t3vm-image',
    't38' => 'image/t38',
    'taglet' => 'application/vnd.mynfc',
    'tao' => 'application/vnd.tao.intent-module-archive',
    'tap' => 'image/vnd.tencent.tap',
    'tar' => 'application/x-tar',
    'tcap' => 'application/vnd.3gpp2.tcap',
    'tcl' => 'application/x-tcl',
    'td' => 'application/urc-targetdesc+xml',
    'teacher' => 'application/vnd.smart.teacher',
    'tei' => 'application/tei+xml',
    'teicorpus' => 'application/tei+xml',
    'tex' => 'application/x-tex',
    'texi' => 'application/x-texinfo',
    'texinfo' => 'application/x-texinfo',
    'text' => 'text/plain',
    'tfi' => 'application/thraud+xml',
    'tfm' => 'application/x-tex-tfm',
    'tfx' => 'image/tiff-fx',
    'tga' => 'image/x-tga',
    'tgz' => 'application/x-tar',
    'thmx' => 'application/vnd.ms-officetheme',
    'tif' => 'image/tiff',
    'tiff' => 'image/tiff',
    'tk' => 'application/x-tcl',
    'tmo' => 'application/vnd.tmobile-livetv',
    'toml' => 'application/toml',
    'torrent' => 'application/x-bittorrent',
    'tpl' => 'application/vnd.groove-tool-template',
    'tpt' => 'application/vnd.trid.tpt',
    'tr' => 'text/troff',
    'tra' => 'application/vnd.trueapp',
    'trig' => 'application/trig',
    'trm' => 'application/x-msterminal',
    'ts' => 'video/mp2t',
    'tsd' => 'application/timestamped-data',
    'tsv' => 'text/tab-separated-values',
    'ttc' => 'font/collection',
    'ttf' => 'font/ttf',
    'ttl' => 'text/turtle',
    'ttml' => 'application/ttml+xml',
    'twd' => 'application/vnd.simtech-mindmapper',
    'twds' => 'application/vnd.simtech-mindmapper',
    'txd' => 'application/vnd.genomatix.tuxedo',
    'txf' => 'application/vnd.mobius.txf',
    'txt' => 'text/plain',
    'u3d' => 'model/u3d',
    'u8dsn' => 'message/global-delivery-status',
    'u8hdr' => 'message/global-headers',
    'u8mdn' => 'message/global-disposition-notification',
    'u8msg' => 'message/global',
    'u32' => 'application/x-authorware-bin',
    'ubj' => 'application/ubjson',
    'udeb' => 'application/x-debian-package',
    'ufd' => 'application/vnd.ufdl',
    'ufdl' => 'application/vnd.ufdl',
    'ulx' => 'application/x-glulx',
    'umj' => 'application/vnd.umajin',
    'unityweb' => 'application/vnd.unity',
    'uoml' => 'application/vnd.uoml+xml',
    'uri' => 'text/uri-list',
    'uris' => 'text/uri-list',
    'urls' => 'text/uri-list',
    'usdz' => 'model/vnd.usdz+zip',
    'ustar' => 'application/x-ustar',
    'utz' => 'application/vnd.uiq.theme',
    'uu' => 'text/x-uuencode',
    'uva' => 'audio/vnd.dece.audio',
    'uvd' => 'application/vnd.dece.data',
    'uvf' => 'application/vnd.dece.data',
    'uvg' => 'image/vnd.dece.graphic',
    'uvh' => 'video/vnd.dece.hd',
    'uvi' => 'image/vnd.dece.graphic',
    'uvm' => 'video/vnd.dece.mobile',
    'uvp' => 'video/vnd.dece.pd',
    'uvs' => 'video/vnd.dece.sd',
    'uvt' => 'application/vnd.dece.ttml+xml',
    'uvu' => 'video/vnd.uvvu.mp4',
    'uvv' => 'video/vnd.dece.video',
    'uvva' => 'audio/vnd.dece.audio',
    'uvvd' => 'application/vnd.dece.data',
    'uvvf' => 'application/vnd.dece.data',
    'uvvg' => 'image/vnd.dece.graphic',
    'uvvh' => 'video/vnd.dece.hd',
    'uvvi' => 'image/vnd.dece.graphic',
    'uvvm' => 'video/vnd.dece.mobile',
    'uvvp' => 'video/vnd.dece.pd',
    'uvvs' => 'video/vnd.dece.sd',
    'uvvt' => 'application/vnd.dece.ttml+xml',
    'uvvu' => 'video/vnd.uvvu.mp4',
    'uvvv' => 'video/vnd.dece.video',
    'uvvx' => 'application/vnd.dece.unspecified',
    'uvvz' => 'application/vnd.dece.zip',
    'uvx' => 'application/vnd.dece.unspecified',
    'uvz' => 'application/vnd.dece.zip',
    'vbox' => 'application/x-virtualbox-vbox',
    'vbox-extpack' => 'application/x-virtualbox-vbox-extpack',
    'vcard' => 'text/vcard',
    'vcd' => 'application/x-cdlink',
    'vcf' => 'text/x-vcard',
    'vcg' => 'application/vnd.groove-vcard',
    'vcs' => 'text/x-vcalendar',
    'vcx' => 'application/vnd.vcx',
    'vdi' => 'application/x-virtualbox-vdi',
    'vds' => 'model/vnd.sap.vds',
    'vhd' => 'application/x-virtualbox-vhd',
    'vis' => 'application/vnd.visionary',
    'viv' => 'video/vnd.vivo',
    'vlc' => 'application/videolan',
    'vmdk' => 'application/x-virtualbox-vmdk',
    'vob' => 'video/x-ms-vob',
    'vor' => 'application/vnd.stardivision.writer',
    'vox' => 'application/x-authorware-bin',
    'vrml' => 'model/vrml',
    'vsd' => 'application/vnd.visio',
    'vsf' => 'application/vnd.vsf',
    'vss' => 'application/vnd.visio',
    'vst' => 'application/vnd.visio',
    'vsw' => 'application/vnd.visio',
    'vtf' => 'image/vnd.valve.source.texture',
    'vtt' => 'text/vtt',
    'vtu' => 'model/vnd.vtu',
    'vxml' => 'application/voicexml+xml',
    'w3d' => 'application/x-director',
    'wad' => 'application/x-doom',
    'wadl' => 'application/vnd.sun.wadl+xml',
    'war' => 'application/java-archive',
    'wasm' => 'application/wasm',
    'wav' => 'audio/x-wav',
    'wax' => 'audio/x-ms-wax',
    'wbmp' => 'image/vnd.wap.wbmp',
    'wbs' => 'application/vnd.criticaltools.wbs+xml',
    'wbxml' => 'application/wbxml',
    'wcm' => 'application/vnd.ms-works',
    'wdb' => 'application/vnd.ms-works',
    'wdp' => 'image/vnd.ms-photo',
    'weba' => 'audio/webm',
    'webapp' => 'application/x-web-app-manifest+json',
    'webm' => 'video/webm',
    'webmanifest' => 'application/manifest+json',
    'webp' => 'image/webp',
    'wg' => 'application/vnd.pmi.widget',
    'wgt' => 'application/widget',
    'wif' => 'application/watcherinfo+xml',
    'wks' => 'application/vnd.ms-works',
    'wm' => 'video/x-ms-wm',
    'wma' => 'audio/x-ms-wma',
    'wmd' => 'application/x-ms-wmd',
    'wmf' => 'image/wmf',
    'wml' => 'text/vnd.wap.wml',
    'wmlc' => 'application/wmlc',
    'wmls' => 'text/vnd.wap.wmlscript',
    'wmlsc' => 'application/vnd.wap.wmlscriptc',
    'wmv' => 'video/x-ms-wmv',
    'wmx' => 'video/x-ms-wmx',
    'wmz' => 'application/x-msmetafile',
    'woff' => 'font/woff',
    'woff2' => 'font/woff2',
    'word' => 'application/msword',
    'wpd' => 'application/vnd.wordperfect',
    'wpl' => 'application/vnd.ms-wpl',
    'wps' => 'application/vnd.ms-works',
    'wqd' => 'application/vnd.wqd',
    'wri' => 'application/x-mswrite',
    'wrl' => 'model/vrml',
    'wsc' => 'message/vnd.wfa.wsc',
    'wsdl' => 'application/wsdl+xml',
    'wspolicy' => 'application/wspolicy+xml',
    'wtb' => 'application/vnd.webturbo',
    'wvx' => 'video/x-ms-wvx',
    'x3d' => 'model/x3d+xml',
    'x3db' => 'model/x3d+fastinfoset',
    'x3dbz' => 'model/x3d+binary',
    'x3dv' => 'model/x3d-vrml',
    'x3dvz' => 'model/x3d+vrml',
    'x3dz' => 'model/x3d+xml',
    'x32' => 'application/x-authorware-bin',
    'x_b' => 'model/vnd.parasolid.transmit.binary',
    'x_t' => 'model/vnd.parasolid.transmit.text',
    'xaml' => 'application/xaml+xml',
    'xap' => 'application/x-silverlight-app',
    'xar' => 'application/vnd.xara',
    'xav' => 'application/xcap-att+xml',
    'xbap' => 'application/x-ms-xbap',
    'xbd' => 'application/vnd.fujixerox.docuworks.binder',
    'xbm' => 'image/x-xbitmap',
    'xca' => 'application/xcap-caps+xml',
    'xcs' => 'application/calendar+xml',
    'xdf' => 'application/xcap-diff+xml',
    'xdm' => 'application/vnd.syncml.dm+xml',
    'xdp' => 'application/vnd.adobe.xdp+xml',
    'xdssc' => 'application/dssc+xml',
    'xdw' => 'application/vnd.fujixerox.docuworks',
    'xel' => 'application/xcap-el+xml',
    'xenc' => 'application/xenc+xml',
    'xer' => 'application/patch-ops-error+xml',
    'xfdf' => 'application/vnd.adobe.xfdf',
    'xfdl' => 'application/vnd.xfdl',
    'xht' => 'application/xhtml+xml',
    'xhtml' => 'application/xhtml+xml',
    'xhvml' => 'application/xv+xml',
    'xif' => 'image/vnd.xiff',
    'xl' => 'application/excel',
    'xla' => 'application/vnd.ms-excel',
    'xlam' => 'application/vnd.ms-excel.addin.macroEnabled.12',
    'xlc' => 'application/vnd.ms-excel',
    'xlf' => 'application/xliff+xml',
    'xlm' => 'application/vnd.ms-excel',
    'xls' => 'application/vnd.ms-excel',
    'xlsb' => 'application/vnd.ms-excel.sheet.binary.macroEnabled.12',
    'xlsm' => 'application/vnd.ms-excel.sheet.macroEnabled.12',
    'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'xlt' => 'application/vnd.ms-excel',
    'xltm' => 'application/vnd.ms-excel.template.macroEnabled.12',
    'xltx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
    'xlw' => 'application/vnd.ms-excel',
    'xm' => 'audio/xm',
    'xml' => 'application/xml',
    'xns' => 'application/xcap-ns+xml',
    'xo' => 'application/vnd.olpc-sugar',
    'xop' => 'application/xop+xml',
    'xpi' => 'application/x-xpinstall',
    'xpl' => 'application/xproc+xml',
    'xpm' => 'image/x-xpixmap',
    'xpr' => 'application/vnd.is-xpr',
    'xps' => 'application/vnd.ms-xpsdocument',
    'xpw' => 'application/vnd.intercon.formnet',
    'xpx' => 'application/vnd.intercon.formnet',
    'xsd' => 'application/xml',
    'xsl' => 'application/xml',
    'xslt' => 'application/xslt+xml',
    'xsm' => 'application/vnd.syncml+xml',
    'xspf' => 'application/xspf+xml',
    'xul' => 'application/vnd.mozilla.xul+xml',
    'xvm' => 'application/xv+xml',
    'xvml' => 'application/xv+xml',
    'xwd' => 'image/x-xwindowdump',
    'xyz' => 'chemical/x-xyz',
    'xz' => 'application/x-xz',
    'yaml' => 'text/yaml',
    'yang' => 'application/yang',
    'yin' => 'application/yin+xml',
    'yml' => 'text/yaml',
    'ymp' => 'text/x-suse-ymp',
    'z' => 'application/x-compress',
    'z1' => 'application/x-zmachine',
    'z2' => 'application/x-zmachine',
    'z3' => 'application/x-zmachine',
    'z4' => 'application/x-zmachine',
    'z5' => 'application/x-zmachine',
    'z6' => 'application/x-zmachine',
    'z7' => 'application/x-zmachine',
    'z8' => 'application/x-zmachine',
    'zaz' => 'application/vnd.zzazz.deck+xml',
    'zip' => 'application/zip',
    'zir' => 'application/vnd.zul',
    'zirz' => 'application/vnd.zul',
    'zmm' => 'application/vnd.handheld-entertainment+xml',
    'zsh' => 'text/x-scriptzsh',
];

?>