<?php
//******************************************************
// HTML head
//******************************************************
function printHtmlPageStart()
{
	global $sitetitle;

	return <<<HTMLPAGESTART
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="en-US" dir="ltr" class="chrome windows fontawesome-i2svg-active fontawesome-i2svg-complete">
<head>
	<title>$sitetitle</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
HTMLPAGESTART;
}

function printHtmlStyles()
{
	return <<<FALCONSTYLESEND
	<script src="/ozekiservices/system/attachments/1/ozeki.4.js"></script>
	<script src="/ozekiservices/system/attachments/1/jquery-3.6.0.min.js" type="text/javascript"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/assets/js/config.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/overlayscrollbars/OverlayScrollbars.min.js"></script>
	<link href="/ozekiservices/system/attachments/1/falcon/vendors/glightbox/glightbox.min.css" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700%7cPoppins:300,400,500,600,700,800,900&amp;display=swap" rel="stylesheet">
	<link href="/ozekiservices/system/attachments/1/falcon/vendors/overlayscrollbars/OverlayScrollbars.min.css" rel="stylesheet">
	<link href="/ozekiservices/system/attachments/1/falcon/assets/css/theme-rtl.min.css" rel="stylesheet" id="style-rtl">
	<link href="/ozekiservices/system/attachments/1/falcon/assets/css/theme.min.css" rel="stylesheet" id="style-default">
	<link href="/ozekiservices/system/attachments/1/falcon/assets/css/user-rtl.min.css" rel="stylesheet" id="user-style-rtl">
	<link href="/ozekiservices/system/attachments/1/falcon/assets/css/user.min.css" rel="stylesheet" id="user-style-default">
	<link href="/ozekiservices/system/attachments/1/ozeki.3.css" rel="stylesheet" id="user-style-default">
	<link href="/ozekiservices/system/attachments/1/falcon/vendors/flatpickr/flatpickr.min.css" rel="stylesheet" />
	<link rel="stylesheet" type="text/css" id="mce-u0" href="/ozekiservices/system/attachments/1/falcon/vendors/tinymce/skins/ui/oxide/skin.min.css">	
	<link rel="shortcut icon" type="image/png" href="/ozekiservices/system/attachments/1/ozeki-logo.png">
FALCONSTYLESEND;
}

function printIsRTL()
{

$htmlheader =<<<HTMLHEAD
	
	
	<script>
	  var isRTL = false;
	  if (isRTL) {
		var linkDefault = document.getElementById('style-default');
		var userLinkDefault = document.getElementById('user-style-default');
		linkDefault.setAttribute('disabled', true);
		userLinkDefault.setAttribute('disabled', true);
		document.querySelector('html').setAttribute('dir', 'rtl');
	  } else {
		var linkRTL = document.getElementById('style-rtl');
		var userLinkRTL = document.getElementById('user-style-rtl');
		linkRTL.setAttribute('disabled', true);
		userLinkRTL.setAttribute('disabled', true);
	  } 
	</script>


	
HTMLHEAD;
	return $htmlheader;
}

function printHtmlHeader()
{
	$pagestart = printHtmlPageStart();
	$falconstyles = printHtmlStyles();
	$rtl = printIsRTL();
	
	$htmlheader = "$pagestart\r\n$falconstyles\r\n$rtl\r\n</head>\r\n<body>\r\n"; 
	return $htmlheader;
}

function printMainContainerStart()
{
	return '<main class="main" id="top"><div class="container-fluid" data-layout="container">';
}

function printMainContentStart()
{
	return '<div class="content" style="min-width:300px">';
}

//******************************************************
// HTML footer
//******************************************************

function printMainContainerEnd()
{
	return '</main>';
}

function printMainContentEnd()
{
	return '</div>';
}

function printHtmlClosingScripts()
{
	$htmlscripts =<<<HTMLFOOT

	<!-- ===============================================-->
	<!--    JavaScripts-->
	<!-- ===============================================-->
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/popper/popper.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/bootstrap/bootstrap.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/anchorjs/anchor.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/is/is.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/glightbox/glightbox.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/assets/js/emoji-button.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/fontawesome/all.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/lodash/lodash.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/vendors/list.js/list.min.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/assets/js/theme.js"></script>
	<script src="/ozekiservices/system/attachments/1/falcon/assets/js/flatpickr.js" referrerpolicy="origin"></script>
    <script>
        flatpickr('input[type=datetime-local]', {
            enableTime: true,
            dateFormat: 'Y-m-d H:i',
            altInput: true
        });
    </script>
HTMLFOOT;
	return $htmlscripts;
}

function printHtmlFooter()
{
	$scripts = printHtmlClosingScripts();

$htmlfooter =<<<HTMLFOOT
	$scripts
</body>    
</html>
HTMLFOOT;
	
	return $htmlfooter;
}

//******************************************************
// Simple card
//******************************************************

function cardbegin($classcard="mb-3",$classbody="bg-light",$stylecard="",$stylebody="")
{
    $ret = "<div class='card $classcard' style='$stylecard'>";
    $ret .= "<div class='card-body $classbody' style='$stylebody'>";
	return $ret;
}
function cardend()
{
    $ret = "</div>";
    $ret .= "</div>";
	return $ret;
}

//******************************************************
// Card with header
//******************************************************
function card($title,$right="",$headercolor = "",$classcard="",$classbody="",$stylebody="")
{
	if ($headercolor=="") $headercolor="#c9daff";
	if ($classcard=="") $classcard="mb-3";
	if ($classbody=="") $classbody="bg-light p-2 pb-3 pt-2";
	$r = "";
	if (!isEmpty($right))
	{
		$r = '<div class="pe-0">';
		$r .= $right;
		$r .= '</div>';
	}

    $ret = '<div class="card '.$classcard.'" style="background-color: '.$headercolor.'">';
    $ret .= '<div class="card-header mt-0 ps-2 pb-0 mb-2 pt-2 pe-2 d-block d-flex justify-content-between">';
    $ret .= "    <h3 class='m-0 mt-1 mb-1'>$title</h3>";
	$ret .= $r;
    $ret .= '</div>';
    $ret .= '<div class="card-body '.$classbody.'" style="'.$stylebody.'">';
	return $ret;
}


function cardmin($title,$right="",$headercolor = "#acffa0")
{
	$r = "";
	if (!isEmpty($right))
	{
		$r = '<div class="m-0 position-absolute w-100"><div class="float-end pe-3" style="z-index:2000">';
		$r .= $right;
		$r .= '</div></div>';
	}

	$card =<<<CARD
	<div class="col-md-6 col-xxl-3 mb-3">
		<div class="card h-md-100 ecommerce-card-min-width" style="background-color: $headercolor;">
			<div class="card-header mt-0 ps-2 pt-2 pb-2 pe-2">
			$r	
			<h3 class='float-sm-start m-0 mt-1 mb-1'>$title </h3>
			</div>
			<div class="card-body d-flex flex-column bg-light p-2">
CARD;

	return $card;
}

function cardmincenter($title,$right="",$headercolor = "#acffa0")
{
	$ret = cardmin($title,$right="",$headercolor);
	$ret = str_replace('float-sm-start','text-center',$ret);
	return $ret;
}

function cardminhalf($title,$right="",$headercolor = "#acffa0")
{
	$ret = cardmin($title,$right="",$headercolor);
	$ret = str_replace('col-xxl-3','mb-3',$ret);
	return $ret;
}


function cardminend()
{
    $ret = "</div>";
    $ret .= "</div>";
	$ret .= "</div>";
	return $ret;
}


//******************************************************
// Display tabs
// -------------
// $tabpage1["Caption"] = "Tab 1";
// $tabpage1["Content"] = "Hello world 1";
//
// $tabpage2["Caption"] = "Tab 2";
// $tabpage2["Content"] = "Hello world 2";
//
// $tabpages[] = $tabpage1;
// $tabpages[] = $tabpage2;
// echo displayTabs($tabpages);
//******************************************************

function displayTabs($tabPages)
{
	$tablabels = "";
	$tabcontents = "";
	foreach ($tabPages as $tab_key => $tab_value) {
		$label = str_replace(" ", "", $tab_value["Caption"]);
		$tablabels .= '<li class="nav-item" onclick="changeTabs();"><a style="border-top: 1px solid var(--falcon-border-color); border-left: 1px solid var(--falcon-border-color); border-right: 1px solid var(--falcon-border-color);" class="nav-link'.($tab_key == 0 ? " active" : "").'" id="'.$label.'-tab" data-bs-toggle="tab" href="#tab-'.$label.'" role="tab" aria-controls="tab-'.$label.'" aria-selected="false">'.$tab_value["Caption"].'</a></li>';
		$tabcontents .= '<div class="tab-pane fade'.($tab_key == 0 ? " show active" : "").'" id="tab-'.$label.'" role="tabpanel" aria-labelledby="'.$label.'-tab">'.$tab_value["Content"].'</div>';
	}

	$ret = '<ul class="nav nav-tabs" id="myTab" role="tablist">'.
		$tablabels
	.'</ul>
	<div class="tab-content border-x border-bottom p-3" id="myTabContent">'.
		$tabcontents	
	.'</div>';
	$ret .= '<script>
	function changeTabs() {
		var myTab = document.getElementById("myTab");
		var children = myTab.children;
		for (var i = 0; i < children.length; i++) {
			var li = children[i];
			var link = li.firstElementChild;
			if (!link.classList.contains("active")) {
				link.style.backgroundColor = "#e7e7e7";
			} else {
				link.style.backgroundColor = "transparent";
			}
		}
	}
	
	changeTabs();
	</script>';

	return $ret;
}

//******************************************************
// Commmon success notification
//******************************************************

function displayFeedback($title,$svg,$message,$button1text=null,$button1page=null,$button2text=null,$button2page=null,$button1type = "btn-primary",$button2type="btn-primary") : string
{
	$ret = '
	<div class="card-body bg-light">
	<div class="d-flex flex-column justify-content-center align-items-center">
	<div style="font-size:3em; text-align:center;">
	'.$title.'
	</div>
	<div class="mt-2 mb-2" style="font-size:2em">
	'.$svg.'
	</div>
	';

	if (!isempty($message))
	{
		$ret.= "<div>$message</div>";
	}

	if ($button1page!=null) 
	{
		$ret.= '<div style="margin-top:2em"><a class="btn '.$button1type.'" href="index.php?owpn='.$button1page.'&nocache='.ozrndstr().'">'.$button1text.'</a></div>';
	}
	if ($button2page!=null) 
	{
		$ret.= '<div style="margin-top:2em"><a class="btn '.$button2type.'" href="index.php?owpn='.$button2page.'&nocache='.ozrndstr().'">'.$button2text.'</a></div>';
	}

	$ret.= '
	</div>
	</div>
	';

    return $ret;
}

function displaySuccessCheckmark($width)
{
	$svg = '<svg xmlns="http://www.w3.org/2000/svg" width="'.$width.'" height="'.$width.'" viewBox="0 0 64 64" enable-background="new 0 0 64 64"><circle cx="32" cy="32" r="30" fill="#fff"/><path d="M32,2C15.431,2,2,15.432,2,32c0,16.568,13.432,30,30,30c16.568,0,30-13.432,30-30C62,15.432,48.568,2,32,2z M25.025,50
	l-0.02-0.02L24.988,50L11,35.6l7.029-7.164l6.977,7.184l21-21.619L53,21.199L25.025,50z" fill="#43a047">
	</svg>';
	return $svg;
}

function displaySuccess($title,$message,$button1text=null,$button1page=null,$button2text=null,$button2page=null,$button1type = "btn-primary",$button2type="btn-primary")
{

	$svg = displaySuccessCheckmark("6em");
	return displayFeedback($title,$svg,$message,$button1text,$button1page,$button2text,$button2page,$button1type,$button2type);
}

function displayErrorCross($width)
{
	$svg = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	width="'.$width.'" height="'.$width.'" viewBox="0 0 450 450" enable-background="new 0 0 450 450" xml:space="preserve">
	<circle fill="#CC3333" cx="225" cy="225" r="225"/>
	<g>
	<line fill="#FFFFFF" stroke="#FFFFFF" stroke-width="70" x1="106.742" y1="110.083" x2="343.258" y2="346.599"/>
	<line fill="#FFFFFF" stroke="#FFFFFF" stroke-width="70" x1="106.742" y1="346.599" x2="343.258" y2="110.084"/>
	</g>
	</svg>';
	return $svg;
}

function displayError($title,$message,$button1text=null,$button1page=null,$button2text=null,$button2page=null,$button1type = "btn-primary",$button2type="btn-primary")
{
	$svg =  displayErrorCross("6em");
	return displayFeedback($title,$svg,$message,$button1text,$button1page,$button2text,$button2page,$button1type,$button2type);
}

function displayErrorCard($cardtitle,$title,$message,$button1text=null,$button1page=null)
{
	$content = displayError($title,$message,$button1text,$button1page);
	return displayErrorBar($content,$cardtitle);
}

function displayErrorBar($message,$cardtitle="Error")
{
	$ret = card($cardtitle,"","#ffc9c9");
    $ret .= $message;
    $ret .= cardend();
	return $ret;
}

function displayWarningBar($message)
{
	$ret = card("Warning","","#f0dbbb");
    $ret .= $message;
    $ret .= cardend();
	return $ret;
}

function displayHintBar($message)
{
	$ret = card("Hint","","#00ffbb");
    $ret .= $message;
    $ret .= cardend();
	return $ret;
}

function displayInfoBar($message,$caption="Information")
{
	$ret = card($caption,"","#bbf0bb");
    $ret .= $message;
    $ret .= cardend();
	return $ret;
}

function printErrorCard($title,$message,$button1text=null,$button1page=null,$button2text=null,$button2page=null,$button1type = "btn-primary",$button2type="btn-primary")
{
	$ret = card("Error");
	$ret .= displayError($title,$message,$button1text,$button1page,$button2text,$button2page,$button1type,$button2type);
	$ret .= cardend();
	return $ret;
}

function displayAlert(string $error) : string {
    $id = uniqid();
    return <<<ENDALERT
        <script>
              
        </script>
        <div id="alert-$id" class="alert alert-danger d-flex justify-content-between" role="alert">
            <div>
                $error
            </div>
            <button type="button" class="btn-close" aria-label="Close" onclick="removeDOMElementById('alert-$id')"></button>
        </div>
ENDALERT;
}


//******************************************************
// Form sections
//******************************************************
function printSectionHeader($title)
{
	$ret = '<div class="mt-5" style="max-width:600px">';
	$ret .= '<div class="mb-0">';
	$ret .= '<h3 class="mb-0" style="color:gray">'.$title."</h3>";
    $ret .= '<HR class="mt-0">';
	$ret .= "</div>";
	return $ret;
}

function printSectionFooter()
{
	$ret = '</div>';
	return $ret;
}

function printSectionHR()
{
	$ret = '<div class="mt-3" style="max-width:600px">';
    $ret .= '<HR class="mt-0">';
	$ret .= "</div>";
	return $ret;
}

?>