<?php
function isWindows()
{
	if (!array_key_exists("SystemRoot",$_SERVER)) return false;
	return (strpos(strtoupper($_SERVER["SystemRoot"]),"WINDOWS")!==false);
}

function isLinux()
{
    return (PHP_OS == "Linux");
}

function isMyOzekiSite()
{
	global $siteurl;
	if ($siteurl == "https://myozeki.com") return true;
	return false;
}

function isDebug()
{
    if (!isWindows()) return false;
    global $debug;    
    return $debug;
}

function isDashboard()
{
	global $owpn;
	global $page_dashboard;
    return ($owpn==$page_dashboard);
}

function isOzeki10()
{
    if (!isset($_SERVER['SERVEDBY'])) return false;
    return true;
}

function isOzeki10Debug()
{
    if (!isset($_SERVER['SERVEDAS'])) return false;
    if ($_SERVER['SERVEDAS']=="DEBUG") return true;
    return false;
}

function isOzeki10Frame()
{
	if (!isset($_SERVER['HTTP_REFERER'])) return false;
	if (getSessionData("Ozeki10Frame","false")=="true") return true;
	if (ozstrcontains($_SERVER['HTTP_REFERER'],"&ncrefresh")) 
	{
		addSessionData("Ozeki10Frame","true",true);
		return true;
	}
    return false;
}

//**********************************************************
// Request information
//**********************************************************

function isHttps()
{ 
    if ($_SERVER["REQUEST_SCHEME"]=="https") return true;

    if (isset($_SERVER['HTTPS']) &&    
        ($_SERVER['HTTPS'] == 'on' || 
        $_SERVER['HTTPS'] == 1) || 
        (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) return true;
    return false;
}

function isApiRequest()
{
    $query = $_SERVER["QUERY_STRING"];
    return mb_strpos($query, "api=") !== false;
}

//**********************************************************
// Browser information
//**********************************************************

function isBrowserChrome()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	if (isBrowserOpera()) return false;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"Chrome")) return true;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"CriOS")) return true;
	return false;
}

function isBrowserFirefox()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"Firefox")) return true;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"FxiOS")) return true;
	return false;
}

function isBrowserEdge()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"Edg/")) return true;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"Edge")) return true;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"EdgiOS")) return true;
	return false;
}

function isBrowserOpera()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"OPR/")) return true;
	if (str_contains($_SERVER['HTTP_USER_AGENT'],"OPT/")) return true;
	return false;
}

function isBrowserSafari()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	if (isBrowserOpera()) return false;
	if (isBrowserChrome()) return false;
	if (isBrowserEdge()) return false;
	if (isBrowserFirefox()) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"Safari");
}

function isBrowserCef()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"CEF");
}

function isBrowserWindows()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"Windows");
}

function isBrowserAndroid()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"Android");
}

function isBrowserIPhone()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"iPhone");
}

function isBrowserIPad()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"iPad");
}


function isBrowserMac()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	if (isBrowserWindows()) return false;
	if (isBrowserAndroid()) return false;
	if (isBrowserIPhone()) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"Macintosh");
}

function isBrowserApple()
{
	if (isBrowserMac()) return true;
	if (isBrowserIPhone()) return true;
	if (isBrowserIPad()) return true;
	if (isBrowserSafari()) return true;
	return false;
}

function isBrowserOzeki()
{
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
	return str_contains($_SERVER['HTTP_USER_AGENT'],"Ozeki/");
}

function isBrowserLocal()
{
	$clientIp = $_SERVER['REMOTE_ADDR'];
    if (in_array($clientIp, ['127.0.0.1', '::1'])) return true;
	return false;
}

function isBrowserWindowsChatClient() {
	if (!isset($_SERVER['HTTP_USER_AGENT'])) return false;
   if (!str_contains($_SERVER['HTTP_USER_AGENT'],"Ozeki/")) return false;
   if (!str_contains($_SERVER['HTTP_USER_AGENT'],"CEF")) return false;
   return true;
}

//*****************************************************
// User flags
//*****************************************************

function isUserQualifedAs($userid,$qualified)
{
    global $regdir;
    $dir = "$regdir/$userid/qualification/$qualified.txt";
    return file_exists($dir);
}

function isAdmin($userid=null)
{
	global $myuserid,$adminuser;
	if ($userid==null) $userid = $myuserid;
	if (isEmpty($adminuser)) return false;
	if ($userid==$adminuser) return true;
	if ($userid==md5($adminuser)) return true;
	return false; 
}

function isDecisionMaker($userid=null)
{
	global $adminstaff,$myuserid;
	if ($userid==null) $userid = $myuserid;
	if (isUserQualifedAs($userid,"exstaff")) return false;
	if (isUserQualifedAs($userid,"decisionmaker")) return true;
	if (isAdmin($userid)) return true;
	if (!is_array($adminstaff)) return false;
	if (in_array($userid,$adminstaff)) return true;
	return false;
}

function isDeveloper($userid=null)
{
	global $myuserid,$developerstaff;
	if ($userid==null) $userid = $myuserid;
	if (isUserQualifedAs($userid,"exstaff")) return false;
	if (isUserQualifedAs($userid,"developer")) return true;
	if (!is_array($developerstaff)) return false;
	if (in_array($userid,$developerstaff)) return true;
	return false;
}

function isTestUser($userid=null)
{
	global $myuserid,$testuserstaff;
	if ($userid==null) $userid = $myuserid;
	if (isUserQualifedAs($userid,"exstaff")) return false;
	if (isUserQualifedAs($userid,"testuser")) return true;
	if (!is_array($testuserstaff)) return false;
	if (in_array($userid,$testuserstaff)) return true;
	return false;
}

function isStaff($userid=null)
{
	global $myuserid,$staff;
	if ($userid==null) $userid = $myuserid;
	if (isUserQualifedAs($userid,"exstaff")) return false;
	if (in_array($userid,$staff)) return true;
	if (isUserQualifedAs($userid,"staff")) return true;
	if (isDeveloper($userid)) return true;
	if (isTestUser($userid)) return true;
	if (isDecisionMaker($userid)) return true;
	return false;
}

function isExStaff($userid=null)
{
	global $myuserid;
	if ($userid==null) $userid = $myuserid;
	if (isUserQualifedAs($userid,"exstaff")) return true;
	return false;
}

function isNormalUser($userid=null)
{
	if (isStaff($userid)) { return false; }
	if (isUserQualifedAs($userid,"exstaff")) return false;
	if (isUserQualifedAs($userid,"serviceuser")) return false;
	return true;
}

function isServiceUser($userid=null)
{
	if (isUserQualifedAs($userid,"serviceuser")) return true;
	return false;
}

?>