<?php
// Time profiling
// -----------------------------------------------
// Examples use:
//
// prof_flag("Start");
// 
// include '../lib/database.php';
// include '../lib/helper_func.php';
// 
// prof_flag("Connect to DB");
//
// connect_to_db();
// 
// prof_flag("Done");
// prof_print();


// Call this at each point of interest, passing a descriptive string
function prof_flag($str)
{
    global $prof_timing, $prof_names;
    $prof_timing[] = microtime(true);
    $prof_names[] = $str;
}

// Call this when you're done and want to see the results
function prof_print()
{
    global $prof_timing, $prof_names;
    $size = count($prof_timing);
    $sum = 0;
    for($i=0;$i<$size - 1; $i++)
    {
        $diff = $prof_timing[$i+1]-$prof_timing[$i];
        $sum += $diff;
        echo "<b>{$prof_names[$i]}</b><br>";
        echo sprintf("&nbsp;&nbsp;&nbsp;%f<br>", $diff);
    }
    echo "<b>{$prof_names[$size-1]}</b><br>";

    echo sprintf("<b style='color:red'>Total: %f seconds</b><br>",$sum);

}
?>