<?php
//******************************************************
// Service registrations
//******************************************************

function addservice($servicename,$startpagenumber,$img)
{
	global $app,$pageicon;
	$pageicon[$startpagenumber] = $img;
	$app[$servicename]["startpage"] = $startpagenumber;
}

function addsrv($service,$title=null)
{
	global $dirprefix,$root,$servicename,$attachments,$img,$startpagenumber,$servicetitle,$app,$pagename,$pagedebug,$servicetitles;
	//service name
	$servicename = $service;
	$servicevarname ="servicename_$service";
	global $$servicevarname;
	$$servicevarname = $service;

	//version
	$versionvarname = "version_$service";
	global $$versionvarname;
	
	//page numbers
	$varname ="page_service_$service";
	$varnamestart ="page_servicestart_$service";
	global $$varname,$$varnamestart,$nextpage;
	if ($$varnamestart==0) $$varnamestart = $$varname;
	$startpagenumber = $$varnamestart;
	if ($startpagenumber>0) $nextpage = $startpagenumber+1;
	$$varnamestart = $nextpage;

	//directories
	$versiondir = "";
	if (isset($$versionvarname) && $$versionvarname!="1.0")
	{
		$versiondir = "/".$$versionvarname;
	}
	$root = "$dirprefix/ozekiservices/$service$versiondir";
	$serviceroot ="root_$service";
	global $$serviceroot;
	$$serviceroot = $root;
	
	$attachments = "/ozekiservices/$servicename/attachments";
	$serviceattachments ="attachments_$service";
	global $$serviceattachments;
	$$serviceattachments = $attachments;

	global $configdir,$serviceconfig;
	$serviceconfig = $configdir."/".$servicename.".php";
	$configfilevarname ="config_$service";
	global $$configfilevarname;
	$$configfilevarname = $serviceconfig;

	$img = "$attachments/app.svg";
	if (!file_exists($dirprefix.$img)) $img="";
	$usersrvdir = "userdir_".$service;
	global $$usersrvdir,$userdir;
	$$usersrvdir = $userdir."/".$servicename;

	//service title
	$servicetitle = ($title == null) ? ucfirst($service) : $title;
	$pagename[$startpagenumber] = $servicetitle;
	$servicetitles[$service] = $servicetitle;

	//add service
	addservice($servicename,$$varname,$img);
}

function issrvpageloaded()
{
	global $owpn,$servicename;
	$varname ="page_service_$servicename";
	global $$varname; 
	if ($owpn>=$$varname && $owpn<$$varname+100) return true;
	if (ozstartswith($owpn,"page_$servicename"."_")) return true;
	return false;
}

function createdatadirforsrv()
{
	global $servicename,$datadir;
	$dir = "datadir_$servicename";
	global $$dir;
	$$dir = "$datadir/services/".$servicename;

	if (!ozmkdir($$dir,$error))
	{
		echo "Cannot create data dir ($dir) ".$$dir." ". $error;
		exit;
	}	
}

function createdatasubdirforsrv($subdirname)
{
	global $servicename,$datadir;
	$dir = "datadir_$servicename"."_$subdirname";
	global $$dir;
	$$dir = "$datadir/services/".$servicename."/".$subdirname;

	if (!ozmkdir($$dir,$error))
	{
		echo "Cannot create data dir ($dir) ".$$dir." ". $error;
		exit;
	}	
}

function createuserdirforsrv()
{
	global $servicename,$userdir;
	$usersrvdir = "userdir_$servicename";
	global $$usersrvdir;
	$$usersrvdir = $userdir."/".$servicename;

	if (!ozisdir($userdir))
	{
		return;
	}

	if (!ozmkdir($$usersrvdir,$error))
	{
		echo "Cannot create dir ($usersrvdir) ".$$usersrvdir." ". $error;
		exit;
	}	
}

function createusersubdirforsrv($subdirname)
{
	global $servicename,$userdir;
	$usersrvdir = "userdir_".$servicename."_".$subdirname;
	global $$usersrvdir;
	$$usersrvdir = $userdir."/".$servicename."/".$subdirname;

	if (!ozmkdir($$usersrvdir,$error))
	{
		echo "Cannot create sub dir ($usersrvdir) ".$$usersrvdir." ". $error;
		exit;
	}	
}

//******************************************************
// Page registrations
//******************************************************

function addp($file,$title="",$navbarsectionname="",$hidden=false,$labelfunc=null)
{
	global $servicename,$nextpage,$attachments,$root,$dirprefix,$app,$page,$pagename,$pagehidden,$pageicon,$pageservice,$navbarsection,$pagelink;	
	
	//Setup page number
	$pagenumber = $nextpage++;

	//Setup page name
	$pathparts = pathinfo($file);
	$extlen = strlen($pathparts['extension'])+1;
	$filebase = substr($pathparts['basename'],0,strlen($pathparts['basename'])-$extlen);
	$pagelinkname = "page_".$servicename."_".$filebase;
	global $$pagelinkname;
	$$pagelinkname = $pagenumber;

	//Setup path
	$path = "$root/$file";
	
	//Setup image
	$newimg = "$attachments/".$filebase.".svg";
	$imgpath = $dirprefix.$newimg;
	$img = (file_exists($imgpath)) ? $newimg : "";

	//Setup title
	if ($title=="") $title = ucfirst($filebase);
	if ($labelfunc!=null) $title = $labelfunc();
	
	//Global arrays
	if (!is_array($page)) {
		//error_log("MyOzeki Error: \$page is not an array. Serving: ".$_SERVER['REQUEST_URI']); 
		$page=array();
	}
	$page[$pagenumber] = $path;
	$pagename[$pagenumber] = ($title!="")?$title:basename($path);
	$pagelink[$pagenumber] = $pagelinkname;
	$pagehidden[$pagenumber] = $hidden; 
	$pageicon[$pagenumber] = $img;
	$app[$servicename]["pages"][] = $pagenumber;
	$pageservice[$pagenumber] = $servicename;
	$navbarsection[$pagenumber] = $navbarsectionname;

	//Service start
	$varnamestart ="page_servicestart_$servicename";
	global $$varnamestart;
	$$varnamestart = $pagenumber;
	
	return $pagenumber;
}

function addphidden($file,$title="")
{
	addp($file,$title,"",true);
}

$disablesession = false;
function addapi($pagename,$file,$sessionenabled=true)
{
	addp($file,"","",true);
	global $nextpage,$pagealias,$pageapi;
	$pagealias[$pagename] = $nextpage-1;
	$pageapi[$pagename] = $nextpage-1;

	if ($sessionenabled) return;
	if (!isset($_REQUEST["api"])) return;
	if ($_REQUEST["api"]!=$pagename) return;
	global $sessionsenabled;
	$sessionsenabled=false; 
}

function isapi()
{
	global $owpn,$pageapi;
	if (!is_array($pageapi)) return false;
	if (!in_array($owpn,$pageapi)) return false;
	return true;
}

//******************************************************
// Service directories
//******************************************************

function isInMyServiceDir($service,$path)
{
	global $userdir;
	$sd = $userdir."/$service";
	return isInDir($sd,$path,$error);
}

function isMyServiceDir($service,$path)
{
	global $userdir;
	$sd = $userdir."/$service";
	if (!allowedDirectory($path,$sd)) return false;
	return true;
}

function isServiceDirOf($service,$email,$path)
{
	global $regdir;
	$userid = md5($email);
	$sd = "$regdir/$userid/$service";
	if (!allowedDirectory($path,$sd)) return false;
	return true;
}

//******************************************************
// Service dependencies
//******************************************************
$srvdeps = array();

function addDep($service, $dependsOnService)
{
	global $srvdeps;
	$srvdeps[$service][$dependsOnService] = true;
}

//******************************************************
// Config management
//******************************************************

function addSectionToConfigFile($configfile,$configname,$defaultconfig)
{
    global $configdir;
    $configfile = "$configdir/$configfile.php";
	if (file_exists($configfile)) {
    	$configdata = file_get_contents($configfile);  
	} else
	{
		$configdata = "";
	}
    if (str_contains($configdata,"// $configname")) return;

	$configdata = trim($configdata);
	$phpstartneeded = true;
	if (ozendswith($configdata,"?>")) 
	{
		$phpstartneeded = false;
		$configdata = substr($configdata,0,strlen($configdata)-2)."\r\n";
	}

    if ($phpstartneeded) $configdata .= "<"."?php\r\n";
	$configdata .= "\r\n";
    $configdata .= $defaultconfig;
    $configdata .= "\r\n?".">";
    file_put_contents($configfile,$configdata);
}

function addSectionToServiceConfig($defaultconfig,$srvname=null)
{
	global $servicename;
	if ($srvname==null) $srvname=$servicename;
	addSectionToConfigFile($srvname,$srvname,$defaultconfig);
}

function addSectionToConfig($configname,$defaultconfig)
{
	addSectionToConfigFile("config",$configname,$defaultconfig);
}

function getVersionFromServiceDescription($servicename,$userid)
{
	global $servicedescription,$servicesdir,$regdir;
	if (!isset($servicedescription[$servicename]))
	{
		include_once("$servicesdir/$servicename/description.php");
	}
	$sd = $servicedescription[$servicename];
	if (!isset($sd["versions"])) return "";
	$v = $sd["versions"];

	$file = "$regdir/$userid/subscriptions/versions/$servicename.txt";
    if (ozreadfile($file,$preferredversion,$error))
    {
		if ($preferredversion=="default")
		{
			return $v["default"];
		} 
		else if ($preferredversion=="dev")
		{
			return $v["dev"];
		}
		else if ($preferredversion=="kamikaze")
		{
			return $v["kamikaze"];
		}
		
		if (in_array($preferredversion,$sd["versions"]["published"]))
		{
			return $preferredversion;
		}
	}
	
	if (isDeveloper($userid) && isset($v["dev"])) return $v["dev"];
	if (!isset($v["default"])) return "";
	return $v["default"];
}

function loadServiceVersions($servicename)
{
    global$servicesdir;
    if(!ozlsdir("$servicesdir/$servicename",$files,$dirs,$error))
    {
        return [];
    }
    $versiondirs=[];
    foreach($dirs as $dir)
    {
        if(!preg_match('/^\d+(?:\.\d+)+$/',$dir))continue;
        $versiondirs[]=$dir;
    }
    return$versiondirs;
}
?>
