<?php
//******************************************************
// Ozeki base library
//******************************************************
$postdata = file_get_contents("php://input");

//******************************************************
// Ozeki base library partial classes
//******************************************************
include_once("$dirprefix/ozeki/sys/base/base.srv.php");
include_once("$dirprefix/ozeki/sys/base/base.files.php");
include_once("$dirprefix/ozeki/sys/base/base.dirs.php");
include_once("$dirprefix/ozeki/sys/base/base.sort.php");
include_once("$dirprefix/ozeki/sys/base/flags.php");

//******************************************************
// Load GET and POST var with default
//******************************************************
function loadvar($varname,$default="")
{
    $a=null;
	unset($a);
    if (isset($_GET[$varname])) $a = $_GET[$varname];
    if (!isset($a) && isset($_POST[$varname])) $a = $_POST[$varname];
    if (!isset($a)) $a=$default;
	return $a;
}

//******************************************************
// Execute user function with global variables
// example: ozExec("funcname(varname1,varname2)");
//******************************************************
function ozExecFunc($funcnameWithVariables,$inputparams=null)
{
    preg_match("/^([^(]*)[(]([^(]*)[)]$/",$funcnameWithVariables,$matches);
    $funcname = $matches[1];
    $params = $matches[2];
    $paramnames = explode(',',$params);
    $paramstoexec = array();
    foreach($paramnames as $param)
    {
		if ($inputparams!=null && array_key_exists($param,$inputparams))
		{
			$paramstoexec[] = $inputparams[$param];
		} else {
        	global $$param;
        	$paramstoexec[] = $$param;
		}
    }
    return call_user_func_array($funcname,$paramstoexec);
}

//******************************************************
// Value validation
//******************************************************
function isdate($date, $format = 'Y-m-d H:i:s')
{
	if (isempty($date)) return false;
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) === $date;
}

function ismd5($str)
{
	if (isempty($str)) return false;
	if (strlen($str)!=32) return false;
	if (!preg_match('/^[A-Za-z0-9]{32}$/', $str)) return false;
	return true;
}

function issha512($str)
{
	if (strlen($str)!=128) return false;
	if (!preg_match('/^[A-Fa-f0-9]*$/', $str)) return false;
	return true;
}

function isaccesskey($str)
{
	if (strlen($str)!=16) return false;
	return true;
}

function isemail($email)
{
	return filter_var($email, FILTER_VALIDATE_EMAIL);
}

function isemail2($email) 
{
    $pattern = '/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+$/';
    return preg_match($pattern, $email);
}

function isdigits($s, $minDigits = 1, $maxDigits = 14) : bool 
{
    return preg_match('/^[0-9]{'.$minDigits.','.$maxDigits.'}\z/', $s);
}

function isvalidtelephonenumber(string $telephone, int $minDigits = 7, int $maxDigits = 14): bool 
{
    if (preg_match('/^[+][0-9]/', $telephone)) { //is the first character + followed by a digit
        $count = 1;
        $telephone = str_replace(['+'], '', $telephone, $count); //remove +
    } else {
		return false;
	}
    
    //remove white space, dots, hyphens and brackets
    $telephone = str_replace([' ', '.', '-', '(', ')'], '', $telephone); 

    //are we left with digits only?
    return isdigits($telephone, $minDigits, $maxDigits); 
}

function isPhoneNumberInternational($s) {
    if(strlen($s) < 6) return false;
    if($s[0] !== '+') return false;
    for ($i = 1, $len = strlen($s); $i < $len; $i++) {
        if ($s[$i] < '0' || $s[$i] > '9') {
            return false;
        }
    }
    return true;
}

function isPasswordTooShort(&$password, &$error)
{
	$error = "";
	$password = trim($password);
	if (strlen($password) >= 6) return true;
	if (isOzeki10() && isBrowserLocal()) return true; 
	if (isOzeki10Debug()) return true;
	$error = "The password is too short. It should be minimum 6 characters long.";
	return false;	
}

function isvalidpasswords(&$password1,&$password2,&$error) 
{
	global $debug;
	$password1 = trim($password1);
	$password2 = trim($password2);

    if (!isPasswordTooShort($password1,$error))
	{
		return false;
	}

	if ($password1 != $password2)
	{
		$error = "The two passwords do not match";
		return false;
	}
	return true;
}

function isvaliddomain($domain_name,&$error) {
    if (!preg_match("/^([a-z\d]+)(\\.([a-z\d]+))+$/i", $domain_name)) 
	{
		$error = "Invalid characters in domain name.";
		return false;
	} 
    
	if (!preg_match("/^.{1,253}$/", $domain_name))
	{
		$error = "The domain name is longer then 253 characters.";
		return false;
	} 

	if (!preg_match("/^[^\\.]{1,63}(\\.[^\\.]{1,63})*$/", $domain_name))
	{
		$error = "The domain name parts cannot be longer then 63 character.";
		return false;
	} 
    
	$error = "";
	return true;
}

function crc16($data)
{
   $crc = 0xFFFF;
   for ($i = 0; $i < strlen($data); $i++)
   {
     $x = (($crc >> 8) ^ ord($data[$i])) & 0xFF;
     $x ^= $x >> 4;
     $crc = (($crc << 8) ^ ($x << 12) ^ ($x << 5) ^ $x) & 0xFFFF;
   }
   return $crc;
}


function createGuid()
{
    if (function_exists('com_create_guid')){
		$guid = com_create_guid();
        return substr($guid,1,strlen($guid)-2);
    }else{
        mt_srand((double)microtime()*10000);//optional for php 4.2.0 and up.
        $charid = strtoupper(md5(uniqid(rand(), true)));
        $hyphen = chr(45);// "-"
        $uuid = substr($charid, 0, 8).$hyphen
            .substr($charid, 8, 4).$hyphen
            .substr($charid,12, 4).$hyphen
            .substr($charid,16, 4).$hyphen
            .substr($charid,20,12);
        return $uuid;
    }
}

function oz_array_key_exists($key,$array)
{
	if (!isset($key)) return false;
	if (!isset($array)) return false;
	if (!is_array($array)) return false;
	return array_key_exists($key,$array);
}

//******************************************************
// String manipulation
//******************************************************
function arrget($varname,$array,$default="")
{
	if (isnullarr($varname,$array)) return $default;
	$ret = $array[$varname];
	if (is_string($ret)) 
	{
		$ret = trim($ret);
	}
	if (isEmpty($ret)) return $default;
	return $ret;
}

function arrfind($varname,$arr,&$value)
{
	$value = null;
	if (isnullarre($varname,$arr,$e)) 
	{
		echo $e;
		return false;
	}
	$value = $arr[$varname];
	return true;
}

function isnullarr($varname,$array)
{
	if (!is_array($array)) return true;
	if (!array_key_exists($varname,$array)) return true;
    if (!isset($array[$varname])) return true;
	if (isempty($array[$varname])) return true;
	return false;
}

function isnullarre($varname,$array,&$error)
{
	if (!is_array($array)) {$error = "Input is not an array"; return true; }
	if (!array_key_exists($varname,$array)) {$error = "Array key does not exist"; return true; }
    if (!isset($array[$varname])) {$error = "Array key not set"; return true; }
	if (isempty($array[$varname])){$error = "Value is empty"; return true; }
	$error = "";
	return false;
}

function isempty($var)
{
	if ($var==null) return true;
	if (!isset($var)) return true;
	if (empty($var)) return true;
	if ($var=="") return true;
	return false;
}

function ozfrontwithdots($str,$len)
{
	if (strlen($str)<$len) return $str;
	return substr($str,0,$len)."...";
}

function ozstartswith($haystack,$needle) 
{
	if (isempty($haystack)) return false;
  	return strpos($haystack , $needle ) === 0;
}

function ozendswith($haystack, $needle) 
{
	$length = strlen($needle);
	return $length > 0 ? substr($haystack, -$length) === $needle : true;
}

function ozstrcontains($haystack,$needle)
{
	return $needle !== '' && mb_strpos($haystack, $needle) !== false;
}

function ozsingleline($var)
{
	$safevar = preg_replace('/[\n\r]/', ' ', $var);
	$safevar = trim(preg_replace('/\s+/', ' ', $safevar));
	return $safevar;
}

function nocache()
{
	return "&nocache=".ozrndstr();
}

function areyousure($text="")
{
	if (isEmpty($text)) $text = "Are you sure you want to delete this item?";
	return " onclick=\"return confirm('$text');\"";
}

function ozrndstr($len=10,$secure=false,$input = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789')
{
	$input_length = strlen($input);
	$random_string = '';
	for($i = 0; $i < $len; $i++) {
		if($secure) {
            $random_character = $input[random_int(0, $input_length - 1)];
        } else {
            $random_character = $input[mt_rand(0, $input_length - 1)];
        }
		$random_string .= $random_character;
	}
	return $random_string;
}

if (!function_exists('str_contains')) 
{
    function str_contains($haystack, $needle) {
        return $needle !== '' && strpos($haystack, $needle) !== false;
    }
}

function getRealHost() 
{
	if (!isset($_SERVER['HTTP_HOST'])) return null;
    list($realHost) = explode(':', $_SERVER['HTTP_HOST']);
    return $realHost;
}

function strToHex($string){
    $hex='';
    for ($i=0; $i < strlen($string); $i++){
        $hex .= dechex(ord($string[$i]));
    }
    return strtoupper($hex);
}

function hexToStr($hex){
	$hex = strtolower($hex);
    $string='';
    for ($i=0; $i < strlen($hex)-1; $i+=2){
        $string .= chr(hexdec($hex[$i].$hex[$i+1]));
    }
    return $string;
}

function ozclone($o)
{
	return json_decode(json_encode($o),true); 
}

function localizepage($pagename)
{
	if (!preg_match("/page_([^_]+)_(.*)$/",$pagename,$matches)) return $pagename;
	global $owpname;
	if (!preg_match("/page_([^_]+)_(.*)$/",$owpname,$matcheslocal)) return $pagename;
	$localpage = "page_".$matcheslocal["1"]."_".$matches["2"];
	return $localpage;
}

function serviceFromPagename()
{
	global $owpname;
	if (!preg_match("/page_([^_]+)_(.*)$/",$owpname,$matcheslocal)) return $owpname;
	$service = $matcheslocal["1"];
	return $service;
}


//**********************************************************
// Date functions
//**********************************************************
function mysqldate()
{
	return date("Y-m-d H:i:s");
} 

function mysqldateutc()
{
	return gmdate("Y-m-d H:i:s");
}

function mysqldate2day($date)
{
	$d =  strtotime($date);
	return date('Y-m-d',$d);
}

function mysqldateadd($datestr,$add='+ 1 days')
{
	if (is_numeric($add)) $add = '+ '.$add.' days';
	return date('Y-m-d H:i:s', strtotime($datestr.' '.$add));
}

function mysqldatediff($mysqlDate1,$mysqlDate2,&$interval)
{
	// Create DateTime objects from the MySQL dates
	$date1 = new DateTime($mysqlDate1);
	$date2 = new DateTime($mysqlDate2);
	
	// Calculate the difference between the dates
	$interval = $date1->diff($date2);

	$ret = mysqlintevalformat($interval);
	return $ret;
}

function mysqlintevalformat($interval)
{
	$ret = "";
	if ($interval->days>0) $ret .= $interval->days." days ";
	$ret .= str_pad($interval->h,2,'0',STR_PAD_LEFT ) .":" . 
	str_pad($interval->i,2,'0',STR_PAD_LEFT ) . ":" . 
	str_pad($interval->s,2,'0',STR_PAD_LEFT );
	return $ret;
}

function tomysqldate($phpdate)
{
	return date("Y-m-d H:i:s",$phpdate);
} 

function frommysqldate($mysqldate)
{
	return strtotime($mysqldate);
}

function formatDate($originalDate) 
{
	if (strtotime($originalDate < strtotime("-1 year"))) {
        return date("d M Y, H:i:s", strtotime("-1 year"));
    }
    return date("d M, H:i:s", strtotime($originalDate));
}

function olderThanDays($mysqldate,$days)
{
    $inspect = strtotime($mysqldate);
    $cutoff = strtotime(mysqldate()."-$days day");
    return ($inspect<$cutoff);
}

//******************************************************
// Directory management
//******************************************************

function isUserDataFile($path)
{
	global $regdir;
	if (!isInDir($regdir,$path,$error)) return false;
	return true;
}

function isEncryptedFile($path)
{
	if (ozendswith($path,"_aes")) return true;
	if (ozendswith($path,"_rsa")) return true;
	return false;
}

function cleanupFilesOlderThenMinutes($path,$minutes,$allowedroot="")
{
	if($allowedroot != "" && !allowedDirectory($path,$allowedroot)) return;
	$files = glob($path."/*");
  	$now   = time();

	foreach ($files as $file) 
	{
		if (!is_file($file)) continue;
		if ($now - filemtime($file) < 60 * $minutes) continue;
		unlink($file);
	}
}

//******************************************************
// Hack attempt
//******************************************************
function reportHackAttempt()
{
	//Implement hack attempt warnings here	
}

//******************************************************
// Templates
//******************************************************

function evalTemplate($template,$keys)
{
	$ks = array_keys($keys);
	usort($ks,"cmpLength");
	foreach($ks as $k)
	{
		if (isEmpty($k)) continue;
		$val = $keys[$k];
		if ($val==null) $val="";
		$template = str_replace("[$k]",$val,$template);
	}
	return $template;
}


//******************************************************
// Request management
//******************************************************

function loadRequestParameter($paramName,&$paramValue,&$error)
{
    if (!isset($_REQUEST[$paramName])) 
    {
        $error = "Cannot load parameter $paramName";
        return false;
    }
    
	if (isEmpty($_REQUEST[$paramName]))
    {
        $error = "Request parameter $paramName is empty";
        return false;
    }

    $paramValue = $_REQUEST[$paramName];
    return true;
}

function loadRequestParameterGlobal($paramName,&$error)
{
	global $_OZREQUEST;
	if (isset($_OZREQUEST) && is_array($_OZREQUEST) && array_key_exists($paramName,$_OZREQUEST))
	{
		global $$paramName;
		$$paramName = $_OZREQUEST[$paramName];
		//echo "Global OZ '$paramName'=".$$paramName."<BR>";
		return true;
	}

    if (!isset($_REQUEST[$paramName])) 
    {
        $error = "Request parameter $paramName is not set";
        return false;
    }
    if (empty($_REQUEST[$paramName]) && $_REQUEST[$paramName] !== "0")
    {
        $error = "Request parameter $paramName is empty";
        return false;
    }
    
	global $$paramName;
	$$paramName = $_REQUEST[$paramName];
	//echo "Global '$paramName'=".$$paramName."<BR>";
    return true;
}

function loadReqParams()
{
    $numargs = func_num_args();
	$arg_list = func_get_args();
    for ($i = 0; $i < $numargs; $i++) {
		$paramName = $arg_list[$i];
		if (!loadRequestParameterGlobal($paramName,$error))
		{
			//echo "<b>$error</b><br>";
		}
    }
}

function loadRequiredReqParams(&$error,...$arg_list)
{
    $numargs = count($arg_list);
    for ($i = 0; $i < $numargs; $i++) {
		$paramName = $arg_list[$i];
		if (!loadRequestParameterGlobal($paramName,$errorm))
		{
			$error = $errorm;
			return false;
		}
    }
	return true;
}

function loadOptionalRequestParameters(...$arg_list)
{
    $numargs = count($arg_list);
    for ($i = 0; $i < $numargs; $i++) {
		$paramName = $arg_list[$i];
		loadRequestParameterGlobal($paramName,$errorm);

    }
	return true;
}


function loadSessionReqParams()
{
	global $browsersession;

	$numargs = func_num_args();
	$arg_list = func_get_args();
	$sessionDirty = false;
    for ($i = 0; $i < $numargs; $i++) {
		$paramName = $arg_list[$i];
		
		$sessionParamName = "request_$paramName";
		$sessionValue = array_key_exists($sessionParamName,$browsersession) ? $browsersession[$sessionParamName] : null;

		global $$paramName;
		if (!isset($_REQUEST[$paramName])) 
		{
			$$paramName = $sessionValue;
		} else
		{
			$$paramName = $_REQUEST[$paramName];
		}

		if ($$paramName != $sessionValue)
		{
			$sessionDirty = true;
			addSessionData($sessionParamName, $$paramName, false);
		}
    }

	if ($sessionDirty)
	{
		saveBrowserSession();
	}
}

function setSessionRequestParameter($paramname,$paramvalue)
{
	$sessionParamName = "request_$paramname";
	addSessionData($sessionParamName, $paramvalue, true);
	global $$sessionParamName;
	$$sessionParamName = $paramvalue;
}

//**************************************************************
// User / Service exists
//**************************************************************
function serviceExists($servicename)
{
	global $dirprefix;
	if (!isfilesafe($servicename,$error))
	{
		return false;
	}
	if (!is_dir("$dirprefix/ozekiservices/$servicename"))
	{
		return false;
	}
	return true;
}

function userExists($userid)
{
	global $regdir;
	if (!ismd5($userid)) 
	{
		return false;
	}
	
	$userdir = "$regdir/$userid";
	if (!is_dir($userdir)) 
	{
		return false;
	}
	
	return true;
}

function isUserEnabled($userid)
{
    global $regdir;
    if (!userExists($userid)) return false;
    $disabledfile = "$regdir/$userid/disabled.txt";
    if (file_exists($disabledfile)) return false;
    return true;
}

function disableUser($userid)
{
    global $regdir;
    if (!userExists($userid)) return;
    $disabledfile = "$regdir/$userid/disabled.txt";
    if (file_exists($disabledfile)) return;
	touch($disabledfile);
}

function enableUser($userid)
{
    global $regdir;
    if (!userExists($userid)) return;
    $disabledfile = "$regdir/$userid/disabled.txt";
    if (!file_exists($disabledfile)) return;
	unlink ($disabledfile);
}

//*************************************************
// User initials, nick and name
//*************************************************

function getName($userid)
{
	getNameAndNick($userid,$fullname,$nick);
	return $fullname;
}

function getNameAndNick($userid,&$fullname,&$nick)
{
	global $regdir,$siteid,$usernamecache;
	if (!is_array($usernamecache)) $usernamecache = array();

	if (array_key_exists($userid,$usernamecache))
	{
		$fullname = trim($usernamecache[$userid]["fullname"]);
		$nick = trim($usernamecache[$userid]["nick"] ?? "");
		return true;
	}

	$publicfile = "$regdir/$userid/public.txt";
	if (!file_exists($publicfile) && (!file_exists($publicfile.".aes")))
	{
		$fullname =	"Unknown";
		$nick = "";
		return false;
	}

	if (file_exists($publicfile) && ozreadfile($publicfile,$json,$error))
	{
		$publicdetails = json_decode($json,true);
		$fullname = trim($publicdetails["fullname"]);
		$nick = trim($publicdetails["nick"]);
		$usernamecache[$userid] = $publicdetails;
		updatePublicDetails($userid, $fullname, $nick);
		return true;
	}

	if (ozloadencryptedjson($siteid,$publicfile.".aes",$publicdetails,$error) && is_array($publicdetails))
	{
		$fullname = trim($publicdetails["fullname"]);
		$nick = array_key_exists("nick",$publicdetails) ? $publicdetails["nick"] : "";
		$nick = trim($nick);
		$usernamecache[$userid] = $publicdetails;
		return true;
	}

	$fullname = "Unknown";
	$nick = "";
	return false;
}

function getNick($userid)
{
	getNameAndNick($userid,$fullname,$nick);
	if (!isempty($nick)) return $nick;
	return $fullname;
}

function getNameAndNickOrName($userid,&$fullname,&$nick)
{
	getNameAndNick($userid,$fullname,$nick);
	if (!isempty($nick)) return true;
	$nick = $fullname;
	return true;
}

//******************************************************
// Ez a függvény adja vissza az elsődleges user ID-t
// Meg lehet hívni az alábbi módon:
//******************************************************
// getRealUserID("gyula@ozeki.hu")
// getRealUserID("+36201234567");
// getRealUserID("gyularabai@gmail.com")
//
// Nálam az elődleges user id: md5("gyula@ozeki.hu") alapján: d0eafbf473d60808db0a36d53b251b10
// A három fenti függvény ezt adja vissza.
// A másodlagos azonosítóknak is létre kell hozni egy mappát, abban viszont csak egy redirect.txt van, amibe be van írva az érintett azonosítóhoz tartozó 
// elsődleges azonosító

function getRealUserID($emailOrPhoneOrOther)
{
	global $regdir;
	$uid = md5($emailOrPhoneOrOther);
	$userdir = "$regdir/$uid";
	if (!ozreadfile("$userdir/forward.txt", $forward, $error)) return $uid;
	return (ismd5($forward) ? $forward : $uid);
}

//******************************************************
// HTTP support
//******************************************************
function getParamsExtra(&$out_params,$ignoreparams=[])
{
	global $paramsExtra;
	$ret = false;
	$out_params = array();
	foreach($_GET as $key=>$value)
    {
		if ($key=="api") continue;
        if ($key=="owpn") continue;
        if ($key=="nocache") continue;
		if ($key=="objid") continue;
		if ($key=="setupservice") continue;
		if ($key=="registrationview") continue;
        if (ozstartswith($key,"formaction")) continue;
		if (ozstartswith($key,"tableaction")) continue;
		if (in_array($key,$ignoreparams)) continue;
		if (isempty($value)) continue;
        $paramname = $key;
        $paramvalue = $value;
		$out_params[$paramname] = $paramvalue;
		$ret = true;
    }

	if (is_array($paramsExtra)) 
	{	
		foreach($paramsExtra as $paramname=>$paramvalue)
		{
			$out_params[$paramname] = $paramvalue;
			$ret = true;
		}
	}

	return $ret;
}

function getFormExtra($ignoreparams=[])
{
	if (!getParamsExtra($extraparams,$ignoreparams)) return "";

	$ret = "";
	foreach($extraparams as $paramname=>$value)
	{
		$paramvalue = htmlspecialchars($value);
        $ret .= "<input type='hidden' name='$paramname' value='$paramvalue'>\r\n";
    }
    return $ret;
}

function getLinkExtra($ignoreparams=[])
{
	if (!is_array($ignoreparams) && !isEmpty($ignoreparams)) $ignoreparams = array($ignoreparams);

	if (!getParamsExtra($extraparams,$ignoreparams)) return "";

	$ret = "";
	foreach($extraparams as $paramname=>$value)
	{
        $paramvalue = urlencode($value);
        $ret .= "&$paramname=$paramvalue";
    }
    return $ret;
}

//******************************************************
// Global variabls
//******************************************************
function toglobals($assoc,$prefix="")
{
	foreach($assoc as $key=>$val)
	{
		$varname = $prefix.$key;
		global $$varname;
		$$varname = $val;
	}
}

//******************************************************
// General form target
//******************************************************
function getFormTarget()
{
    if (isset($_REQUEST["api"]))
    {
        return "<input type='hidden' name='api' value='".$_REQUEST["api"]."'>";
    }

    global $owpname;
    return "<input type='hidden' name='owpn' value='$owpname'>";
}

//******************************************************
// File upload error
//******************************************************
function fileuploaderr2str($error)
{
	switch($error)
	{
		case UPLOAD_ERR_OK:
			return"There is no error, the file uploaded with success.";
		case UPLOAD_ERR_INI_SIZE:
			return"The uploaded file exceeds the upload_max_filesize directive in php.ini.";
		case UPLOAD_ERR_FORM_SIZE:
			return"The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.";
		case UPLOAD_ERR_PARTIAL:
			return"The uploaded file was only partially uploaded.";
		case UPLOAD_ERR_NO_FILE:
			return"No file was uploaded.";
		case UPLOAD_ERR_NO_TMP_DIR:
			return"Missing a temporary folder.";
		case UPLOAD_ERR_CANT_WRITE:
			return"Failed to write file to disk.";
		case UPLOAD_ERR_EXTENSION:
			return"A PHP extension stopped the file upload.";
		default:
			return"Unknown upload error.";
	}
}

//******************************************************
// Debug
//******************************************************
function oztrace() {

	ob_start();
	echo '<pre style="background-color:#efcccc">';
	debug_print_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,7);
	echo '</pre>';
	$trace = ob_get_contents();
	ob_end_clean();
	return $trace;
}

function ozdump($var) {

	ob_start();
	echo '<pre style="background-color:#efeccc">';
	debug_print_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,5);
	var_dump($var);
	echo '</pre>';
	$trace = ob_get_contents();
	ob_end_clean();
	return $trace;
}

function displayDebugLog() 
{
	if (!isWindows()) return;
	global $debuglog;
	if (isempty($debuglog)) return;
	echo "<br>";
	echo $debuglog;
}

function printByteArray($byteArray, $dec=false)
{
	ob_start();
	foreach ($byteArray as $byte) {
		if ($dec)
			echo ((int)$byte)."-";
		else
			printf("%02X-", $byte);
	}	
	$ret = ob_get_contents();
	ob_end_clean();
	return substr($ret,0,strlen($ret)-1);
}

function printByteString($string,$dec=false)
{
	$byteArray = unpack('C*', $string);
	return printByteArray($byteArray,$dec);
}

function getApacheDir()
{
    $apachedir = "";
    if (isWindows() && !isOzeki10()) 
    {
        $apachedir = "C:/wamp64/bin/apache/apache2.4.51";
        if (!is_dir($apachedir))
        {
            ozlsdir("C:/wamp64/bin/apache",$files,$dirs,$error);
            foreach($dirs as $dir)
            {
                if (!ozstartswith($dir,"apache")) continue;
                $apachedir = "C:/wamp64/bin/apache/$dir";
                break;
            }
        }
    }
    return $apachedir;
}

function getOpenSSLConfigOnWindows()
{
	global $sysdir;
	if (isOzeki10())
	{
		$opensslloc = $sysdir."/setup/openssl.cnf";
	} else {
		$opensslloc = getApacheDir()."/conf/openssl.cnf";
		if (!file_exists($opensslloc))
		{
			$opensslloc = $sysdir."/setup/openssl.cnf";
		}
	}
	return $opensslloc;
}

function isWebofficeServerHost($hostname) {
    $host = $_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? '';
    $host = preg_replace('/:\d+$/', '', $host);
    $host = rtrim($host, '.');
    $host = strtolower($host);
  
    if ($host === 'localhost') return true;
    if ($host === $hostname) return true;
    return false;
}

?>