<?php

//**********************************************************
// Directory management
//**********************************************************
function ozmkdir($path, &$error)
{
	$path = trim($path);

	if (is_dir($path))
	{
		$error = "";
		return true;
	}

	if (!isInValidDataDir($path))
	{
		$error = "Cannot create dir outside the data dir. $path";
		return false;
	}

	if (!mkdir($path, 0777, true)) 
	{
		$e = error_get_last();
    	$error = "Could not create directory; ".$path."; ".$e["message"];
		return false;
	}

	$error = "";
	return true;
}

function isdirempty($path)
{
	if (!is_dir($path))
		return true;

	if (!ozlsdir($path, $files, $dirs, $error))
		return true;

	if (count($files)+count($dirs)==0) 
		return true;

	return false;
}

function ozlsdir($path, &$files, &$dirs, &$error)
{
	if (!is_dir($path))
	{
		$error = "Directory does not exist; ".$path;
		return false;
	}

	$dirs = array();
	$files = array();
	$dir = new DirectoryIterator($path);
	foreach ($dir as $fileinfo) {
	    if ($fileinfo->isDot()) { continue; }
		if ($fileinfo->isDir()) 
		{ 
			$dirs[] = $fileinfo->getFilename();
			continue; 
		}
	    $files[] = $fileinfo->getFilename();
	}
	sort($files);
	sort($dirs);
	return true;
}

function ozrmdirifempty($d,$recursive=true)
{
	if ($recursive) 
	{
		if (!ozlsdir($d,$files,$dirs,$error)) return;
		if (count($files)>0 ) return;
		foreach($dirs as $dir)
		{
			ozrmdirifempty("$d/$dir",$recursive);
		}
	}

	if (!ozlsdir($d,$files,$dirs,$error)) return;
	if (count($files)>0 ) return;
	if (count($dirs)>0) return;
	rmdir($d);
}

function ozrmdir($path,$allowedroot="")
{
	if (!isInValidDataDir($path))
	{
		$error = "Cannot remove from outside the data dir.";
		return false;
	}

	if (!isEmpty($allowedroot) && !allowedDirectory($path,$allowedroot)) return false;
	
	if (!is_dir($path)) return true;

	$files = glob($path . '/*');
	foreach ($files as $file) 
	{
		is_dir($file) ? ozrmdir($file,$allowedroot) : unlink($file);
	}

	if (is_dir($path))
		rmdir($path);
	else
		unlink($path);

	return true;
}

function allowedDirectory($path,$allowedroot)
{
	$rproot = realpath($allowedroot);
	$rp = realpath($path);

	if (strlen($rp)<8) return false;
	if (strlen($rproot)<8) return false;
	if (strpos($rp,$rproot)===false) return false;
	if (strlen($rp)<strlen($rproot)) return false;
	if (!ozstartswith(strtolower($rp),strtolower($rproot))) return false;
	return true;
}

function isSubDirOf($root,$subdirfullpath)
{
	if (!allowedDirectory($subdirfullpath,$root)) return false;
	$r = realpath($root);
	$s = realpath($subdirfullpath);
	if (!is_dir($r)) return false;
	if (!is_dir($s)) return false;
	$r = str_replace("\\","/",$r);
	$s = str_replace("\\","/",$s);
	if (!ozendswith($r,"/")) $r.="/";
	if (!ozendswith($s,"/")) $s.="/";
	if (strtolower($r)==strtolower($s)) return false;
	if (strlen($r)>=strlen($s)) return false;
	return true;
}

function isInDir($root,$fullfilepath,&$error)
{
	$r = realpath($root);
	$s = ozrealpath($fullfilepath);
	if ($s==$r) 
	{
		$error = "The dirs are the same.";
		return false;
	}
	if (!is_dir($r)) 
	{
		$error = "Root is not a dir.";
		return false;
	}
	$r = str_replace("\\","/",$r);
	$s = str_replace("\\","/",$s);
	if (!ozendswith($r,"/")) $r.="/";
	if (!ozendswith($s,"/")) $s.="/";
	if (strtolower($r)==strtolower($s)) 
	{
		$error = "The dirs are the same after examination.";
		return false;
	}
	if (strlen($r)>=strlen($s)) 
	{
		$error = "The root dir is shorter.";
		return false;
	}
	return true;
}

function isInValidDataDir($file)
{
	global $datadir;
	if (isInDir("$datadir/registrations",$file,$error)) return true;
	if (isInDir("$datadir/services",$file,$error)) return true;
	if (isInDir("$datadir/logs",$file,$error)) return true;
	if (isInDir("$datadir/tmp",$file,$error)) return true;
	if (isInDir("$datadir/sessions",$file,$error)) return true;
	return false;
}

function ozRename($from,$to,&$error)
{
	if (!isInValidDataDir($from))
	{
		$error = "Cannot rename from outside the data dir.";
		return false;
	}

	if (!isInValidDataDir($to))
	{
		$error = "Cannot rename to outside the data dir.";
		return false;
	}

	if (!rename($from, $to)) {
		if (is_file($to)) unlink($to);
		if (is_dir($to)) ozrmdir($to);
		if (!rename($from, $to)) 
		{
			$error = error_get_last()["message"];
			return false;
		}
	}
	return true;
}

//************************************************************************
// Path name
//************************************************************************

function ozpathcombine() 
{
    $paths = array();

    foreach (func_get_args() as $arg) {
        if ($arg !== '') { $paths[] = $arg; }
    }

	$combined = join('/', $paths);
    return preg_replace('#/+#','/',$combined);
}

function ozrealpath(string $path): string
{
	// Cleaning path regarding OS
	$path = mb_ereg_replace('\\\\|/', DIRECTORY_SEPARATOR, $path, 'msr');
	// Check if path start with a separator (UNIX)
	$startWithSeparator = $path[0] === DIRECTORY_SEPARATOR;
	// Check if start with drive letter
	preg_match('/^[a-z]:/', $path, $matches);
	$startWithLetterDir = isset($matches[0]) ? $matches[0] : false;
	// Get and filter empty sub paths
	$subPaths = array_filter(explode(DIRECTORY_SEPARATOR, $path), 'mb_strlen');

	$absolutes = [];
	foreach ($subPaths as $subPath) {
		if ('.' === $subPath) {
			continue;
		}
		// if $startWithSeparator is false
		// and $startWithLetterDir
		// and (absolutes is empty or all previous values are ..)
		// save absolute cause that's a relative and we can't deal with that and just forget that we want go up
		if ('..' === $subPath
			&& !$startWithSeparator
			&& !$startWithLetterDir
			&& empty(array_filter($absolutes, function ($value) { return !('..' === $value); }))
		) {
			$absolutes[] = $subPath;
			continue;
		}
		if ('..' === $subPath) {
			array_pop($absolutes);
			continue;
		}
		$absolutes[] = $subPath;
	}

	return
		(($startWithSeparator ? DIRECTORY_SEPARATOR : $startWithLetterDir) ?
			$startWithLetterDir.DIRECTORY_SEPARATOR : ''
		).implode(DIRECTORY_SEPARATOR, $absolutes);
}

function relativedatadir($dir)
{
	global $datadir;
	$ddr = realpath($datadir);
	$r = realpath($dir);
	if (!ozstartswith($r,$ddr)) return $dir;
	return substr($r,strlen($ddr));
}

//************************************************************************
// glogal dirs
//************************************************************************

function getRegDir()
{
	global $regdir;
	return $regdir;
}


function getUserDir($userid,&$userdir,&$error)
{
	global $regdir;
	if (!userExists($userid))
	{
		$userdir = "";
		$error = "User not found";
		return false;
	}
	$userdir = "$regdir/$userid";
	$error = "";
	return true;
}

?>