<?php

//**********************************************************
// Security questions for password reset service 
//**********************************************************

$secquestionset1 = array(
	"In which city did your parents meet?",
	"What city were you born in?",
	"What is the name of your first/current/favorite pet?",
	"What is your mother's maiden name?",
	"In which city was your mother born in?",
	"What was the make of your first car?",
	"What was your favorite food as a child?",
	"Where did you meet your spouse?",
	"In which city did you have your first kiss?",
	"What is the first name of the boy or girl that you first kissed?",
	"What is the name of a college you applied to but didn’t attend?",
	"What was the name of your first stuffed animal?",
	"What is the coolest landmark you have ever visited?",
	"What was your first phone number? (e.g. +36201234567)",
	"What is the nickname of your favorite cusin?",
	"When is your favorite sea animal?",
	"What is the most distant city you have ever visited?",
	"When you were young what did you want to be when you grew up?",
	"What is the name of the city you first visited with an airplane?",
	"What was the name of your first manager at your first job?"
);

$secquestionset2 = array(
	"What is the name of your grandmother's dog?",
	"What was your childhood nickname?",
	"What is the name of your favorite childhood friend?",
	"What street did you live on in first grade?",
	"What is your oldest sibling’s birthday month and year? (e.g., January 1900)",
	"What is the middle name of your youngest child?",
	"What is your oldest sibling’s middle name?",
	"What was your childhood phone number including area code? (e.g. +36201234567)",
	"What is your favorite cusin's phone number? (e.g. +36201234567)",
	"What is your oldest cousin’s first and last name?",
	"In what city or town was your first job?",
	"What is the name of the place your wedding reception was held?",
	"Where were you when you first heard about 9/11?",
	"What is the name of the road you grew up on?",
	"What is the name of your favorite teacher?",
	"What it the name of the person who first betrayed you?",
	"What was the first concert you attended?",
	"In what city and country do you want to retire?",
	"What time of the day was your first child born? (hh:mm)",
	"What time of the day were you born? (hh:mm)"
);

function comboSecurityQuestionSet1($inputname,$selected=null)
{
	global $secquestionset1;
	$ret = "<select class=\"form-select\" style=\"font-size:0.8rem\" name=\"$inputname\">";
	foreach($secquestionset1 as $secquestion1option)
	{
		$selected = ($secquestion1option==$selected)?"selected":"";
		$ret .= "<OPTION $selected>$secquestion1option</OPTION>\r\n";
	}
	$ret .= "</select>";
	return $ret;
}

function comboSecurityQuestionSet2($inputname,$selected=null)
{
	global $secquestionset2;
	$ret = "<select class=\"form-select\" style=\"font-size:0.8rem\" name=\"$inputname\">";
	foreach($secquestionset2 as $secquestion2option)
	{
		$selected = ($secquestion2option==$selected)?"selected":"";
		$ret .= "<OPTION $selected>$secquestion2option</OPTION>\r\n";
	}
	$ret .= "</select>";
	return $ret;
}

function updateSecurityQuestions($userid,$userprivatekey, $secquestion1,$secanswer1,$secquestion2,$secanswer2,&$error)
{
	$datavalid = true;

	if (strlen($secquestion1)<3) 
	{
		$error = "Security question 1 is too short.";
		return false;
	}

	if (strlen($secanswer1)<3) 
	{
		$error = "Security answer 1 is too short.";
		return false;
	}

	if (strlen($secquestion2)<3) 
	{
		$error = "Security question 2 is too short.";
		return false;
	}

	if (strlen($secanswer2)<3) 
	{
		$error = "Security answer 2 is too short.";
		return false;
	}

	if (!ismd5($userid))
	{
		$error = "Invalid user id. Cannot update security questoins.";
		return false;
	}

	if (!is_resource($userprivatekey) && !is_object($userprivatekey))
	{
		$error = "Invalid private key. Cannot update security questoins.";
		return false;
	}

	global $regdir;
	$userdir = "$regdir/$userid";

	//Security questions 
	$secquestionsfile = $userdir."/secquestions.txt";
	$secquestions = $secquestion1."\r\n".$secquestion2;
	if ($datavalid && !file_put_contents($secquestionsfile,$secquestions))
	{
		$errorPassword = "Cannot write security questions file ".error_get_last()["message"];
		return false;
	}

	$passwordsecquestions = strtolower(trim($secanswer1).trim($secanswer2));
	$pemprivatesecquestions = exportRsaPrivateKeyToPEM($userprivatekey,$passwordsecquestions);
	$pemprivatefilesecquestions = $userdir."/recoverykey.txt";
	if (!file_put_contents($pemprivatefilesecquestions,$pemprivatesecquestions))
	{
		$errorPassword = "Cannot write recovery key ".error_get_last()["message"];
		return false;
	}

	return true;
}

function getSecurityQuestions($userid,&$secquestion1,&$secquestion2,&$error)
{
    global $datadir;
    $secquestionsfile = $datadir."/registrations/".$userid."/secquestions.txt";
    if (file_exists($secquestionsfile))
    {
        $lines = file($secquestionsfile);
        if (!is_array($lines) || count($lines)<2)
        {
            $error = "Invalid security questions file";
            return false;
        } 
        $secquestion1 = $lines[0];
        $secquestion2 = $lines[1];
        return true;
    } 

    $error = "Cannot find security questions for your account";
    return false;
}

//**********************************************************
// Reset password
//**********************************************************
function resetPassword($useremailhash,$secanswer1,$secanswer2,$password1,&$error)
{
    if (!ismd5($useremailhash))
    {
        $error = "Invalid user id";
        return false;
    }

    global $datadir;
    $userdir = $datadir."/registrations/".$useremailhash;
    if (!is_dir($userdir)) 
    {
        $error  = "Could not find this user";
        return false;
    } 

    if (!isPasswordTooShort($password1,$error)) 
    {
        $error = "Invalid password $error";
        return false;
    } 

    if ($secanswer1=="" || $secanswer2 =="") 
    {
        $error = "The security answers cannot be empty";
        return false;
    } 
    
    $pemprivatefilesecquestions = $userdir."/recoverykey.txt";
    if (!file_exists($pemprivatefilesecquestions))
    {
        $error = "Cannot find stored security answers";
        return false;
    }

    $password = strtolower(trim($secanswer1).trim($secanswer2));
    $recoveryprivatekeypem = file_get_contents($pemprivatefilesecquestions);
  
    if (!importRsaPrivateKeyFromPEM($recoveryprivatekeypem, $password, $userprivatekey, $userpublickey,$error))
    {
      $error = "Invalid answer to the security questions";
      return false;
    }

    //Create new password for user
    //$pwhash = generateSha512Hash($password1);
    $pwhash = sha512($password1);
    $pemprivate = exportRsaPrivateKeyToPEM($userprivatekey,$password1);
    $pempublic = exportRsaPublicKeyToPEM($userpublickey);

    ozlsdir($userdir, $files, $dirs, $error);
    foreach($files as $file) 
    {
      if (ozstartswith($file,"privatekey_"))
      {
        $pemprivatefiletodel = $userdir."/".$file;
        unlink($pemprivatefiletodel);
      }
    }

    $pemprivatefile = $userdir."/privatekey_".$pwhash.".txt";
    if (!file_put_contents($pemprivatefile,$pemprivate))
    {
      $error = "Cannot write user private key ".error_get_last()["message"];
      return false;
    }
    
    $pempublicfile = $userdir."/publickey.txt";
    if (!file_put_contents($pempublicfile,$pempublic))
    {
      $error = "Cannot write user public key ".error_get_last()["message"];
      return false;
    }

    global $savepasswords,$adminuserid,$adminpublickeypem;
    if ($savepasswords) 
    {
        $pwtoadminfile = $userdir."/sharedto/".$adminuserid."_p.txt";
        if (!importRsaPublicKeyFromPEM($adminpublickeypem, $adminpublickey,$error))
        {
            $error = "Cannot save password $error";
            return false;
        }

        $pwtoadmin = encryptTextRSA($adminpublickey,$password1);
        if (!file_put_contents($pwtoadminfile,$pwtoadmin))
        {
          $error = "Cannot write admin p file ".error_get_last()["message"];
          return false;
        }
    }

	return true;
}

?>