<?php

include_once("$sysdir/authentication/registrationcreateuser.php");

//*************************************************
// Update 
//*************************************************

function updateUserRegistration($userid, $password, $email, $fullname,$mobile,&$error)
{
	global $regdir,$adminpublickey,$adminuserid;

    $userdir = $regdir."/".$userid;

	if (!ismd5($userid)) 
	{
		$error = "Invalid user id";
		return false;
	} 
	
	if (!isPasswordTooShort($password,$error)) 
	{
		$error = "Invalid existing password. $error";
		return false;
	} 


	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$error = "Invalid e-mail address: $email";
		return false;
	} 

	if (strlen($fullname)<3) 
	{
		$error = "The full name is too short";
		return false;
	} 

	if (!is_dir($userdir))
	{
		$error = "This user account does not exist";
		return false;
	}

	date_default_timezone_set('UTC');

	$pwhash = sha512($password);
	$pemprivatefile = $userdir."/privatekey_".$pwhash.".txt";
	if (!file_exists($pemprivatefile))
	{
		$error = "The current password is invalid $pemprivatefile";
		return false;
	}

	$pem = file_get_contents($pemprivatefile);
	importRsaPrivateKeyFromPEM($pem, $password, $userprivatekey, $userpublickey,$error);
		
	$aessharedfile = $userdir."/aesshared.txt";
	$aessharedencrypted = file_get_contents($aessharedfile);
	if (!decryptTextRSA($userprivatekey,$aessharedencrypted,$aesshared,$error))
	{
		$error = "Cannot decrypt aes shared key- ".$error;
		return false;
	}

	//Load the registration details
	if (!loadUserDetails($userid,$myreg,$error,$aesshared))
	{
		$error = "Cannot load user details to update. $error";
		return false;
	}

	$myreg["email"]=$email;
	$myreg["mobile"]=$mobile;
	$myreg["fullname"]=$fullname;

	updateUserDetails($userid, $myreg, $error, $aesshared);
	updatePublicDetails($userid, $fullname);
	
	if (!CallOnUserUpdated($userid,$myreg,$error,$aesshared))
	{
		return false;
	}
	
	return true;
}

?>