<?php
function addSecondaryUser($emailorphoneorother, $type, $password, &$privatekey, &$error){
    date_default_timezone_set('UTC');
    if(!validateSecondaryUserCreateReq($type, $primaryuserid, $error)) return false;

    $secondaryuserid = md5($emailorphoneorother);

    $createdate = date('Y-m-d H:i:s');

    $detailsPrimary = [
        "secondaryuserid" => $secondaryuserid,
        "type" => $type,
        "emailorphoneorother" => $emailorphoneorother,
        "createdate" => $createdate,
    ];

    $detailsSecondary = [
        "primaryuserid" => $primaryuserid,
        "type" => $type,
        "createdate" => $createdate,
    ];

    if(!writeSecondaryUser($primaryuserid,$secondaryuserid,$detailsSecondary, $password,$publickey,$error)) return false;
    if(!writeSecondaryUserToPrimary($primaryuserid,$secondaryuserid, $publickey, $detailsPrimary, $error)) return false;
    return true;
}

function validateSecondaryUserCreateReq($type, &$primaryuserid, &$error) {
    global $myuserid;
    $primaryuserid = $myuserid;
    if(!$myuserid) {
        $error = "No user logged in";
        return false;
    }
    $validtypes = ["apple","google","email","phone"];
    if(!in_array($type,$validtypes)) {
        $error = "Invalid type: $type";
        return false;
    }
    return true;
}

function writeSecondaryUser($primaryuserid,$secondaryuserid,$details, $password,&$publickey,&$error){
    global $regdir;
    $secondaryuserdir = "$regdir/$secondaryuserid";
    $publickey = null;

     if(!userExists($primaryuserid)) {
        $error = "Primary user account not found.";
        return false;
    }

    if(userExists($secondaryuserid)) {
        $error = "Secondary user account already exists.";
        return false;
    }

    if(!ozmkdir($secondaryuserdir, $error)) {
        $error = "Failed to create secondary user directory: $error";
        return false;
    }

    if (!ozsavejson("$secondaryuserdir/details.json", $details, $error)) {
        $error = "Failed to save details JSON: $error";
        return false;
    }

    if(!ozsavefile("$secondaryuserdir/forward.txt", $primaryuserid, $error)) {
        $error = "Failed to save forward file: $error";
        return false;
    }
    if(!$password) return true;

    if (!generateRsaKeypair($privatekey,$publickey,$error))
    {
        $error = "Could not create user. RSA key pair generation failed. $error";
        return false;
    }
    $pemprivate = exportRsaPrivateKeyToPEM($privatekey,$password);
    $pempublic = exportRsaPublicKeyToPEM($publickey);

    $pwhash = sha512($password);

    if (!ozsavefile("$secondaryuserdir/privatekey_$pwhash.txt", $pemprivate, $error)) {
        $error = "Failed to save private key: $error";
        return false;
    }
    if (!ozsavefile("$secondaryuserdir/publickey_$pwhash.txt", $pempublic, $error)) {
        $error = "Failed to save public key: $error";
        return false;
    }
    return true;
}

function writeSecondaryUserToPrimary($primaryuserid,$secondaryuserid, $publickey, $details, &$error) {
    global $regdir,$myaesshared,$mypassword;
    $primarydir = "$regdir/$primaryuserid";

    if(!ozmkdir("$primarydir/secondary", $error)) {
        $error = "Failed to create secondary user directory: $error";
        return false;
    }

    $primarysecdir = "$primarydir/secondary/$secondaryuserid";

    if(!ozmkdir($primarysecdir, $error)) {
        $error = "Failed to create secondary user directory: $error";
        return false;
    }

    $enrypteddetailsjson = encryptTextAES($myaesshared, json_encode($details));
    if (!ozsavefile("$primarysecdir/details.json.enc", $enrypteddetailsjson, $error)) {
        $error = "Failed to save details JSON: $error";
        return false;
    }

    if($publickey){
        $sharedtoprimary = "$primarydir/sharedto/";

        if(!ozmkdir($sharedtoprimary, $error)) {
            $error = "Failed to create secondary user directory: $error";
            return false;
        }

        $encryptedpassword = encryptTextRSA($publickey, $mypassword);
        if (!ozsavefile("$sharedtoprimary/$secondaryuserid"."_p.txt", $encryptedpassword, $error)) {
            $error = "Failed to save password: $error";
            return false;
        }
    }

    if(!ozfileaddtolist("$primarydir/secondary.txt",$secondaryuserid,$error)) {
        $error = "Failed to add secondary user to primary user list: $error";
        return false;
    }
    $error = "";
    return true;
}

function getMySecondaryUsers(){
    global $myuserid,$regdir,$myaesshared;
    $secondaryusers = [];
    if(!$myuserid) return $secondaryusers;
    $secondaries = "$regdir/$myuserid/secondary";
    if(!is_dir($secondaries)) return $secondaryusers;
    foreach (scandir($secondaries) as $file) {
        if ($file === '.' || $file === '..') continue;
        $details = "$secondaries/$file/details.json.enc";
        if(!is_file($details)) continue;
        $details = file_get_contents($details);
        if(empty($details)) continue;
        $details = decryptTextAES($myaesshared, $details);
        if(empty($details)) continue;
        $details = json_decode($details, true);
        if(empty($details)) continue;
        $secondaryusers[$file] = $details;
    }
    return $secondaryusers;
}

function isSecondaryUser($userid){
    global $regdir;
    $userdir = "$regdir/$userid";
    if(!is_dir($userdir)) return false;
    if(!is_file("$userdir/forward.txt")) return false;
    return true;
}

function getSecondaryUserType($userid){
    global $regdir;
    $userdir = "$regdir/$userid/";
    if(!is_dir($userdir)) return false;
    $detailsfile = "$userdir/details.json";
    if(!is_file($detailsfile)) return false;
    $details = file_get_contents($detailsfile);
    if(empty($details)) return false;
    $details = json_decode($details, true);
    if(empty($details)) return false;
    if(!isset($details["type"]) || !is_string($details["type"])) return false;
    return $details["type"];
}

function isGoogleUser($userid){
    global $regdir;
    $userdir = "$regdir/$userid/google";
    if(!is_dir($userdir)) return false;
    $refreshtokenfile = "$userdir/refreshtoken.txt";
    if(!is_file($refreshtokenfile)) return false;
    return true;
}

function isAppleUser($userid){
    global $regdir;
    $userdir = "$regdir/$userid/apple";
    if(!is_dir($userdir)) return false;
    $refreshtokenfile = "$userdir/refreshtoken.txt";
    if(!is_file($refreshtokenfile)) return false;
    return true;
}

function getUserSecondaryUserIds($userid){
    global $regdir,$myaesshared;
    $secondaryusers = [];
    $secondaries = "$regdir/$userid/secondary.txt";
    if(!is_file($secondaries)) return $secondaryusers;
    ozreadlines($secondaries, $secondaryusers, $error);
    return $secondaryusers;
}

function forwardIfSecondaryUser(&$uid,&$pwd,&$error){
    global $regdir;
    $userdir = "$regdir/$uid";
    if(!is_dir($userdir)) return true;
    if(!is_file("$userdir/forward.txt")) return true;
    if(!ozreadfile("$userdir/forward.txt",$primaryid,$error)) return false;
    
    $primarydir = "$regdir/$primaryid";
    if(!is_dir($primarydir)){
        $error="Primary user account not found.";
        return false;
    }
    $pwhash = sha512($pwd);
    
    $keyfile = "$userdir/privatekey_$pwhash.txt";
    if(ozreadfile($keyfile,$pemprivate,$error)){
        if(!importRsaPrivateKeyFromPEM($pemprivate, $pwd, $privateKey, $publicKey, $error)) return false;
        $passwordfile = "$primarydir/sharedto/$uid"."_p.txt";
        if(!ozreadfile($passwordfile,$passwordencrypted,$error)) return false;
        if(!decryptTextRSA($privateKey,$passwordencrypted,$password,$error)) return false;
        $pwd=$password;
    }
    $uid=$primaryid;
    $error = "";
    return true;
}

function deleteSecondaryUser($uid,&$error){
    global $regdir,$myuserid;
    $forwardf = "$regdir/$uid/forward.txt";
    if(!ozreadfile($forwardf,$parentid,$error)) return false;
    $parentdir = "$regdir/$parentid";
    if(!is_dir($parentdir))
    {
        $error="Parent user account not found.";
        return false;
    }
    if($myuserid!=$parentid)
    {
        $error="You are not allowed to delete this secondary user.";
        return false;
    }
    ozfiledelfromlist("$parentdir/secondary.txt",$uid,$error);
    ozfileclear("$parentdir/sharedto/$uid"."_p.txt");
    ozfileclear("$parentdir/secondary/$uid/details.json.enc");
    ozrmdir("$parentdir/secondary/$uid");
    delete_account($uid);
    return true;
}

?>