<?php
global $sysdir;
include_once("$sysdir/events/_include.php");
include_once("$sysdir/encryption/encryption.php");
include_once("$sysdir/encryption/encryption_user.php");

//*************************************************
// Registration from GUI
//*************************************************

function createPasswordForUser($userid,$userprivatekey,$userpassword,$overwrite,&$error,$prefix="privatekey")
{
	global $regdir, $savepasswords, $adminpublickey, $adminuserid, $testuserstaff;

	if (!isset($userpassword) || strlen($userpassword)<3)
	{
		$error = "Cannot create password for user. Provided password is too short";
		return false;
	}

	$pwhash = sha512($userpassword);
	$pemprivate = exportRsaPrivateKeyToPEM($userprivatekey,$userpassword);
	$pempublic = exportRsaPublicKeyToPEM($userprivatekey);
	$userdir = "$regdir/$userid";

	if (!isset($pemprivate) || strlen($pemprivate)<3)
	{
		$error = "Cannot create password for user. Could not export user's private key.";
		return false;
	}

	if ($overwrite) 
	{
		ozlsdir($userdir, $files, $dirs, $error);
		foreach($files as $file) {
			if (!ozstartswith($file,$prefix."_")) continue;
			if (file_exists($userdir."/".$file.".readonly")) continue;
			if (ozendswith($file,".readonly")) continue;
			$pemprivatefiletodel = $userdir."/".$file;
			unlink($pemprivatefiletodel);
		}
	}

	$pemprivatefile = $userdir."/".$prefix."_".$pwhash.".txt";
	if (!file_put_contents($pemprivatefile,$pemprivate))
	{
		$error = "Cannot write user private key ".error_get_last()["message"];
		return false;
	}
	
	$pempublicfile = $userdir."/publickey.txt";
	if (!file_put_contents($pempublicfile,$pempublic))
	{
		$error = "Cannot write user public key ".error_get_last()["message"];
		return false;
	}

	//Password shared for admin login access
	if ($savepasswords || (is_array($testuserstaff) && in_array($userid,$testuserstaff)))
	{
		$save = $overwrite;
		$pwtoadminfile = "$userdir/sharedto/$adminuserid"."_p.txt";
		if (!file_exists($pwtoadminfile)) $save = true;
		if ($save) {

			$pwtoadmin = encryptTextRSA($adminpublickey,$userpassword);
			if (!file_put_contents($pwtoadminfile,$pwtoadmin))
			{
				$error = "Cannot write admin p file ".error_get_last()["message"];
				return false;
			}
		}
	}

	//Keys shared for admin password reset
	$prstoadminfile =  "$userdir/sharedto/$adminuserid"."_rsa.txt";
	if (!file_exists($prstoadminfile))
	{
		$pemprivate = exportRsaPrivateKeyToPEM($userprivatekey);
		$prstoadmin = encryptTextRSAAES($adminpublickey,$pemprivate);
		if (!file_put_contents($prstoadminfile,$prstoadmin))
		{
			$error = "Cannot write admin prs file ".error_get_last()["message"];
			return false;
		}
	}

	$error = "";
	return true;
}

function createUser($userid, $email,$fullname,$password,&$privatekey,&$error,$mobile="notrequired",$country=null,$nick=null)
{
	global $regdir,$adminpublickey,$adminuserid,$debug;

	if (!isPasswordTooShort($password,$error)) 
	{
		return false;
	} 

	if (isBrowserApple()) //Az apple app approval-nél kérték, hogy ne kelljen mobilt megadni.
	{
		$mobile = "notrequired";
	}

	if (!isValidTelephoneNumber($mobile) && $mobile!="notrequired") 
	{
		$error = "Invalid mobile phone";
		return false;
	} 

	if ($mobile=="notrequired") $mobile="";
	
	$userdir = $regdir."/".$userid;
	$pwhash = sha512($password);
	if (!generateRsaKeypair($privatekey,$publickey,$error))
	{
		$error = "Could not create user. RSA key pair generation failed. $error";
		return false;
	}

	$pemprivate = exportRsaPrivateKeyToPEM($privatekey,$password);
	$pempublic = exportRsaPublicKeyToPEM($publickey);
	
	if (!createUserEncrypted($userid,$email,$fullname,$mobile,$pwhash,$pemprivate,$pempublic,$country,$error,$nick,$privatekey))
	{
		return false;
	}

	if (!createPasswordForUser($userid,$privatekey,$password,false,$error))
	{
		return false;
	}

	if (!isapirequest()) 
	{
		addEncryptedSessionData("lastusername", $email);
		if (isDebug()) 
		{
			addEncryptedSessionData("lastpassword", $password);
		}
	}

	return true;
}


//*************************************************
// Registration from API
//*************************************************

function createUserEncrypted($userid, $email, $fullname,$mobile,$pwhash,$pemprivate,$pempublic,$country,&$error,$nick=null,$privatekey=null)
{
	global $regdir,$adminpublickey,$adminuserid;

	$userid = $userid; 
	$userdir = $regdir."/".$userid;

	if (!ismd5($userid)) 
	{
		$error = "Invalid user id";
		return false;
	} 

	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$error = "Invalid e-mail address: $email";
		return false;
	} 

	if (strlen($fullname)<3) 
	{
		$error = "The full name is too short";
		return false;
	} 

	if (is_dir($userdir))
	{
		$error = "This e-mail account is already registered";
		return false;
	}
	
	if (!ozmkdir($userdir,$error))
	{
		$error = "Cannot register this email. $error";
		return false;
	}

	if (isset($country) && strlen($country)==2)
	{
		include_once("$sysdir/form/attrext/combocountry.php");
		$country = findCountryByAlphaCode2($countrycode);
	}

	$aeskeyshared = generateAesKey();
	$aeskeyprivate = generateAesKey();

	date_default_timezone_set('UTC');
	$myreg = [];		
	$myreg["email"]=$email;
	$myreg["mobile"]=$mobile;
	$myreg["fullname"]=$fullname;
	$myreg["country"]=$country;
	$myreg["dateregistered"]=date('Y-m-d H:i:s');
	$myreg["datesuspended"]="";
	$myreg["dateterminated"]="";
	$myreg["regip"]=$_SERVER['REMOTE_ADDR'];
	$myreg["issuspended"]=false;
	$myreg["isterminated"]=false;
	$myreg["accesskey"]=ozrndstr(16,true);
	$myreg["reason"]="";

	//write encryption keys
	$pemprivatefile = $userdir."/privatekey_".$pwhash.".txt";
	if (!file_put_contents($pemprivatefile,$pemprivate))
	{
		$error = "Cannot write private key ".error_get_last()["message"];
		return false;
	}
	
	$pempublicfile = $userdir."/publickey.txt";
	if (!file_put_contents($pempublicfile,$pempublic))
	{
		$error= "Cannot write public key ".error_get_last()["message"];
		return false;
	}
	
	if (!importRsaPublicKeyFromPEM($pempublic, $publickey,$error))
	{
		return false;
	}

	$aeskeysharedencrypted = encryptTextRSA($publickey, $aeskeyshared);
	$aessharedfile = $userdir."/aesshared.txt";
	if (!file_put_contents($aessharedfile,$aeskeysharedencrypted))
	{
		$error = "Cannot write aes shared key ".error_get_last()["message"];
		return false;
	}
	
	$aeskeyprivateencrypted = encryptTextRSA($publickey, $aeskeyprivate);
	$aesprivatefile = $userdir."/aesprivate.txt";
	if (!file_put_contents($aesprivatefile,$aeskeyprivateencrypted))
	{
		$error = "Cannot write aes priate key ".error_get_last()["message"];
		return false;
	}
	
	//Write registration details
	if (!updateUserDetails($userid, $myreg, $error, $aeskeyshared))
	{
		return false;
	}

	updatePublicDetails($userid, $fullname, $nick);

	//Share AES key to admin		
	$shareddir = $userdir."/sharedto";
	if (!ozmkdir($shareddir,$error))
	{
		$error = "Cannot create shared directory ".$error;
		return false;
	}

	$aessharedtoadminfile = $shareddir."/".$adminuserid."_aesshared.txt";
	$aessharedtoadmin = encryptTextRSA($adminpublickey,$aeskeyshared);
	if (!file_put_contents($aessharedtoadminfile,$aessharedtoadmin))
	{
		$error = "Cannot write admin aes file ".error_get_last()["message"];
		return false;
	}

	$aesprivatetoadminfile = $shareddir."/".$adminuserid."_aesprivate.txt";
	$aesprivatetoadmin = encryptTextRSA($adminpublickey,$aeskeyprivate);
	if (!file_put_contents($aesprivatetoadminfile,$aesprivatetoadmin))
	{
		$error = "Cannot write admin aes file ".error_get_last()["message"];
		return false;
	}

	if (!CallOnUserCreated($userid,$myreg,$error,$privatekey,$aeskeyshared))
	{
		$error = "While executing OnUserCreated events. $error";
		return false;
	}

	return true;
}

//*************************************************
// Public details
//*************************************************
function updatePublicDetails($userid, $fullname, $nick=null)
{
	if (isempty($fullname) && isempty($nick)) return;

	global $regdir,$siteid;
	$writeneeded = false;
	$publicdetails = [];
	$publicfile = $regdir."/".$userid."/public.txt";
	if (file_exists($publicfile) && ozreadfile($publicfile,$json,$error))
	{
		$publicdetails = json_decode($json,true);
		if (!array_key_exists("nick",$publicdetails)) $publicdetails["nick"]="";
		$storedfullname = $publicdetails["fullname"];
		$storednick = $publicdetails["nick"];
		$writeneeded = true;
		//if ($storedfullname == $fullname && $storednick==$nick) return;
	}

	if (!$writeneeded && file_exists($publicfile.".aes") && ozloadencryptedjson($siteid,$publicfile.".aes",$publicdetails,$error))
	{
		if (!array_key_exists("nick",$publicdetails)) $publicdetails["nick"]="";
		$storedfullname = $publicdetails["fullname"];
		$storednick = $publicdetails["nick"];
		if ($storedfullname == $fullname && $storednick==$nick) return;
	}
	
	if (!isempty($fullname)) 
	{
		$publicdetails["fullname"] = $fullname;
		$writeneeded = true;
	}
	if (!isempty($nick)) 
	{
		$publicdetails["nick"] = $nick;
		$writeneeded = true;
	}

	if (!$writeneeded) return;
	//$json = json_encode($publicdetails);
	//file_put_contents($publicfile,$json);

	ozsaveencryptedjson($siteid,$publicfile.".aes",$publicdetails,$error);
	if (file_exists($publicfile)) unlink($publicfile);
}

function getNickLink($userid)
{
	global $userAccessLink;

	if (!isEmpty($userAccessLink))
		return $userAccessLink($userid);

	getNameAndNick($userid,$fullname,$nick);
	if (!isempty($nick)) return $nick;
	return $fullname;
}

function getInitials($fullname)
{
	$initials="";
	$fullnameparts=explode(" ",$fullname);
	if(count($fullnameparts)==1)
		$initials=$fullname[0];
	else
		$initials=$fullnameparts[0][0].$fullnameparts[1][0];
	$initials=strtoupper($initials);
	return$initials;
}

//*************************************************
// Private details
//*************************************************
function loadUserDetails($userid,&$details,&$error,$aeskey=null) : bool
{
	global $regdir;
	$filename = "$regdir/$userid/registration.txt";
	if (!file_exists($filename))
	{
		$error = "User details data not found.";
		return false;
	}

	global $myuserid;
	if ($myuserid != $userid) 
	{
		if ($aeskey==null && !ozloadaessharedkeyof($userid,$aeskey,$error)) return false;
		if (!ozloadencrypted($aeskey,$filename,$content,$error)) return false;
	} 
	else if (!ozloadshared($filename,$content,$error))
	{
		return false;
	}
	$details =  json_decode($content,true);
	return true;
}


function updateUserDetails($userid, $details, &$error, $aeskeyshared=null)
{
	global $myuserid;
	if (isEmpty($aeskeyshared)) 
	{
		if ($myuserid != $userid) 
		{
			if (!ozloadaessharedkeyof($userid,$aeskeyshared,$error)) return false;
		} else
		{
			global $myaesshared;
			$aeskeyshared = $myaesshared;
		}
	}

	if (isempty($aeskeyshared)) 
	{
		$error = "Cannot get AES key of user $userid";
		return false;
	}
	global $regdir;
	$myregjson = json_encode($details);
	$myregjsonencrypted = encryptTextAES($aeskeyshared, $myregjson);
	$regfile = "$regdir/$userid/registration.txt";
	if (!file_put_contents($regfile,$myregjsonencrypted))
	{
		$error = "Cannot write registration file ".error_get_last()["message"];
		return false;
	}
	return true;
}

?>