<?php
//**********************************************************
// Login / User registration
//**********************************************************

$regdir = $datadir."/registrations";
if (!ozmkdir($regdir,$error))
{
	echo "Error: Cannot create ozeki account directory!";
}

//**************************************************************
// Robot protection
//**************************************************************
$errorCaptcha = "";
$displayCaptcha = false;
$resubmitflag = "off";
if ($LoginPageVisitedAt!="myozeki.com")
{
     if ($debug) $errorCaptcha = "Captcha requested because login page was not visited.<BR>";
     $displayCaptcha=true;
}

//***********************************************************************
// Registration form location support
//***********************************************************************
if (!isset($registrationtarget) || isEmpty($registrationtarget)) $registrationtarget="owpn";
if (!isset($registrationpage) || isEmpty($registrationpage)) $registrationpage="page_authentication_registration";
if (!isset($logintarget) || isEmpty($logintarget)) $logintarget="owpn";
if (!isset($loginpage) || isEmpty($loginpage)) $loginpage="page_authentication_login";

//**************************************************************
// Process registration form
//**************************************************************
$linkextra = getLinkExtra();
global $myaction;
loadMyAction();
if (!isset($setRegistrationAccepted) || $setRegistrationAccepted==null) $setRegistrationAccepted = false;
$registrationAccepted = $setRegistrationAccepted;

global $auth_allowregistration;
if (!$auth_allowregistration) {$myaction="";}

if ($myaction=='register')
{
    $datavalid = true;
    //robot protection
    $resubmitflag = "on";
    $resubmit =  $_POST["resubmit"];
    $firstinput =  $_POST["firstinput"];
    $lastinput =  $_POST["lastinput"];
    $jscheck =  $_POST["jscheck"];

    $inputdiff = intval($lastinput)-intval($firstinput);
    if ($inputdiff<2000 && $resubmit!="on")
    {
        if ($debug) 
        {
          $errorCaptcha .= "Captcha requested because input timing is not human.";
          $error = $errorCaptcha;
        }
        $datavalid = false;
        $displayCaptcha=true;
    }

    if ($jscheck!='human')
    {
        $errorCaptcha .= "This registration request seems to come from a bot. Please let us know that you are a human.";
        $error = $errorCaptcha;
        $datavalid = false;
        $displayCaptcha=true;
    }
    
    if (isset($captchaVerfiyFunc) && function_exists($captchaVerfiyFunc))
    {
        $enabled =  $_POST["captcha_enabled"];
        if ($enabled!="enabled" && $enabled!="disabled")
        {
           $errorCaptcha .= "Captcha error: captcha was disabled.";
           $error = $errorCaptcha;
           $datavalid = false;
           $displayCaptcha=true;
        }
        if ($enabled=="enabled")
        {
           $ispass = $captchaVerfiyFunc("captcha");
           if (!$ispass)
           {
              $errorCaptcha .= "Input is invalid. Please try again.";
              $error = $errorCaptcha;
              $datavalid = false;
              $displayCaptcha=true;
           }
        }
    }
	
    //to del
    //$datavalid = false;

    //input data verification
    $fullname = trim($_POST["myfullname"]);
    $email = strtolower(trim($_POST["myemail"]));
    $mobile =  trim($_POST["mymobile"]);
    $password1 =  $_POST["mypassword1"];
    $password2 =  $_POST["mypassword2"];
    $countrycode =  $_POST["countrycode"];
    $setupservice =  (isset($_POST["setupservice"])) ? $_POST["setupservice"] : "";

    $accept = array_key_exists("myaccept",$_POST) ? $_POST["myaccept"] : "";
    if ($accept=="on")
    {
      $myacceptchecked = "checked";
    }
    $userid = md5($email);
    $userdir = $regdir."/".$userid;

    //input data verification
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) 
    {
      $errorEmail = "Invalid e-mail address";
      $error = $errorEmail;
      $datavalid = false;
    } 

    if (strlen($countrycode)!=2)
    {
        $countrycode="";
	      $country="";
    } 
    else 
    {
        include_once("$sysdir/form/attrext/combocountry.php");
        $country = findCountryByAlphaCode2($countrycode);
    }
    
    if ($datavalid && $password1 != $password2) 
    {
      $errorPassword = "The two passwords do not match";
      $error = $errorPassword;
      $datavalid = false;
    } 

    if ($datavalid && !isPasswordTooShort($password1,$errorp)) 
    {
      $errorPassword = $errorp;
      $error = $errorPassword;
      $datavalid = false;
    } 

    if ($datavalid && $accept!="on") 
    {
      $errorPassword = "The terms and conditions must be accepted";
      $error = $errorPassword;
      $datavalid = false;
    } 

    if ($datavalid && strlen($fullname)<3) 
    {
      $errorFullname = "The full name is too short";
      $error = $errorFullname;
      $datavalid = false;
    } 

    if ($datavalid && !isValidTelephoneNumber($mobile) && !isBrowserApple()) //Az apple app approval-nél kérték, hogy ne kelljen mobilt megadni.
    {
      $errorMobile = "Invalid mobile number";
      $error = $errorMobile;
      $datavalid = false;
    } 

    

    if ($datavalid)
    {
      $registrationAccepted = createUser($userid, $email,$fullname,$password1,$out_privatekey,$errorPassword,$mobile,$country);
    }

    if ($registrationAccepted)
    {
      global $_OZREQUEST;
      $myaction = "login";
      $_OZREQUEST["myaction"] = "login";
      $_OZREQUEST["myemail"] = $email;
      $_OZREQUEST["mypassword"] = $password1;

      logoutFromSession();
      handleLoginFormRequest();
      handleLoginSessionRequest();
      if ($setupservice!=null) addSessionData("setupservicerequest",$setupservice);
      
      loadReqParams("afterlogintarget","afterloginpage");
      if (isEmpty($afterlogintarget)) $afterlogintarget = "owpn";
      if (isEmpty($afterloginpage)) $afterloginpage = "page_dashboard";

      $url = "index.php?$afterlogintarget=$afterloginpage$linkextra".nocache();
      $location = $url;
      global $debugredirects;
      if ($debugredirects) 
      {
        echo "Redirect after registration:<BR>";
        echo "<a href='$location'>$location</a>"; 
        exit;
      }

      $redirecturl = $url;
      error_log("sys/authentication/registration.php 196:  Redirecting browser to $redirecturl. Original request: ".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']);
      header("X-Ozeki-Redirect: registration 197");
      header("Location: $redirecturl");
    }
}

//***********************************************************************
// Left panel 
//***********************************************************************
$targeturl = "index.php?$registrationtarget=$registrationpage".nocache();
$formextra = getFormExtra();
$linkextra = getlinkExtra();

$leftpanel = <<<LEFTPANEL
<div class="col-md-5 text-center bg-card-gradient">
  <div class="position-relative p-4 pb-1 light">
    <div class="bg-holder bg-auth-card-shape" style="background-image:url(/ozekiservices/system/attachments/1/falcon/assets/img/icons/spot-illustrations/half-circle.png);">
    </div>
    <!--/.bg-holder-->

    <div class="z-index-1 position-relative mt-4">
<img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_portable_web_transparent_text.png" class="d-none d-md-inline" width="150px"/>
      <img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_web_transparent.png" class="d-md-none" width="200px"/> 
      <p class="mt-3 text-white text-center"><h3 class="text-white text-center">Account</h3></p>
    </div>
  </div>
  <div class="mt-1 mb-1 mt-md-0 mb-md-5 light">
    <p class="pt-3 text-white text-center">Have an account?<br>
    <form action="index.php?$logintarget=$loginpage" method="POST">
      $formextra
      <input type="hidden" name="registrationview" value="loginform">
      <input type="submit" class="btn btn-outline-light mt-2 px-4" value='Login'></button>
    </form>
    </p>
  </div>
</div>
LEFTPANEL;

//***********************************************************************
// Registration form / captcha
//***********************************************************************
$captcha = "";
$captcha_enabled = "disabled";
if ($displayCaptcha && isset($captchaInputFunc) && function_exists($captchaInputFunc))
{
    $captcha_enabled = "enabled";
    $captchainput = $captchaInputFunc("captcha",$hidden,$error);
    if ($hidden)
    {
      $captcha = $captchainput;
      $captcha .= "<span style='color:red; font-weight:bold'>$error</span>";
    } else {
    $captcha = <<<CAPFORM
  <div class="mb-3 p-2" style="background-color:#dbdbc0">
    <label class="form-label" for="card-email">Captcha</label><BR>
    $captchainput
    <span style="color:red; font-weight:bold">$errorCaptcha</span>
  </div>
CAPFORM;
    }
} else if (isDebug()) 
{
    //$captcha .= "<span style='color:red; font-weight:bold'>Captcha not requested</span>";
}

//***********************************************************************
// Registration form / default values
//***********************************************************************
if (!isset($myacceptchecked)) $myacceptchecked="";
if (!isset($password1)) $password1="";
if (!isset($password2)) $password2="";
if (!isset($errorPassword)) $errorPassword="";
if (!isset($mobile)) $mobile="";
if (!isset($errorMobile)) $errorMobile="";
if (!isset($fullname)) $fullname="";
if (!isset($errorFullname)) $errorFullname="";
if (!isset($errorEmail)) $errorEmail="";

if (isEmpty($email) && isDebug())
{
    $x=1;
    $testaccountavailable = false;
    while (!$testaccountavailable)
    {
        $nexttestaccount = "test$x@ozeki.hu";
        if (!userExists(md5($nexttestaccount))) break;
        $x++;
    }
    $email = $nexttestaccount;
    $fullname = "Ozeki $x"."Test";
    $mobile = "+3620111111$x";
    $password1 = "qwe123";
    $password2 = "qwe123";
    $myacceptchecked = "checked";
}

//***********************************************************************
// Registration form / form
//***********************************************************************
$phoneOptional = "";
if (isBrowserApple())
{
    $phoneOptional = "(Optional)";
}

if ($fullname=="Profile") $fullname=""; 

$regform = <<<REGFORM
<h3 class="text-center mb-3">Create an Ozeki Account</h3>
      <form action='$targeturl' method='POST'>
      $formextra
      <input type='hidden' name='myaction' value='register'>
      <input type='hidden' id='countrycode' name='countrycode' value=''>
      <input type='hidden' id='resubmit' name='resubmit' value='$resubmitflag'>
      <input type='hidden' id='firstinput' name='firstinput' value='0'>
      <input type='hidden' id='lastinput' name='lastinput' value='0'>
      <input type="hidden" id="jscheck" name='jscheck' value='bot'>
      <input type='hidden' name='captcha_enabled' value='$captcha_enabled'>
        <div class="mb-3">
          <label class="form-label" for="card-name">Full name</label>
          <input class="form-control" type="name" name="myfullname" autocomplete="on" id="card-name" value="$fullname" onkeypress="inputcheck();" onclick="inputcheck();"/>
          <span class="form-label" for="card-email" style="color:red; font-weight:bold">$errorFullname</span>
        </div>

        <div class="mb-3">
          <label class="form-label" for="card-email">Email address</label>
          <input class="form-control" type="email" name="myemail" autocomplete="on" id="card-email" value="$email" onkeypress="inputcheck();" onclick="inputcheck();"/>
          <span class="form-label" for="card-email" style="color:red; font-weight:bold">$errorEmail</span>
        </div>

        <div class="mb-3">
          <label class="form-label" for="card-mobile">Mobile phone $phoneOptional</label>
          <input class="form-control" type="mobile" name="mymobile" autocomplete="on" id="card-mobile" value="$mobile" onkeypress="inputcheck();" onclick="inputcheck();"/>
          <span class="form-label" for="card-mobile" style="color:red; font-weight:bold">$errorMobile</span>
          <div class="form-label" for="card-mobile">International format (e.g.: +36201234567)</div>
        </div>

        <div class="row gx-2">
          <div class="mb-3 col-sm-6">
            <label class="form-label" for="card-password">Password</label>
            <input class="form-control" type="password" name="mypassword1" autocomplete="on" id="card-password" value="$password1" onkeypress="inputcheck();" onclick="inputcheck();"/>
          </div>
          <div class="mb-3 col-sm-6">
            <label class="form-label" for="card-confirm-password">Confirm Password</label>
            <input class="form-control" type="password" name="mypassword2" autocomplete="on" id="card-confirm-password" value="$password2"  onkeypress="inputcheck();" onclick="inputcheck();"/>
          </div>
        </div>

        <div class="mb-3">
          <span class="form-label" for="card-email" style="color:red; font-weight:bold">$errorPassword</span>
        </div>

        $captcha

        <div class="form-check">
          <input class="form-check-input" type="checkbox" name="myaccept" id="card-register-checkbox"  onclick="inputcheck();" $myacceptchecked/>
          <label class="form-label" for="card-register-checkbox">I accept the <a href="https://ozeki.hu/index.php?owpn=3243" target="_blank">terms </a>and <a href="https://ozeki.hu/index.php?owpn=3242" target="_blank">privacy policy</a></label>
        </div>

        <div class="mb-3">
          <button class="btn btn-primary d-block w-100 mt-3" type="submit" name="submit" onclick="inputcheck()";>Register</button>
        </div>
      </form>

      <script>
          // Get the input element
          

          // Set timer to change input value after 500ms (0.5 seconds)
          setTimeout(() => {
            let jscheckinput = document.getElementById('jscheck');
            jscheckinput.value = 'human';
          }, 500);
      </script>

REGFORM;

//***********************************************************************
// Registration form / accepted
//***********************************************************************
$emailenc = htmlspecialchars($email);
$regaccepted = <<<REGOK
<h3 class="text-center">Registration accepted</h3>
<div class="mb-3">
    <form action="index.php?$logintarget=$loginpage$linkextra" method="POST">
    <input type="hidden" name="$logintarget" value="$loginpage">
    <input type="hidden" name="loginemail" value="$emailenc">
    <input type="submit" class="btn btn-primary d-block w-100 mt-3" value="Click here to login">
    </form>
</div>
REGOK;

if (!$registrationAccepted) 
{
  $rightcontent = $regform;
} 
else 
{
  $rightcontent = $regaccepted;
}

//***********************************************************************
// Registration form / disabled
//***********************************************************************
$regdisabled = <<<REGNOTALLOWED
<h3>Registration not allowed</h3>
<div class="mb-3">
    The system administrator has disabled
    user registration for this service.
    Only the system admin is allowed to
    create user accounts.
</div>
REGNOTALLOWED;

global $auth_allowregistration;
if (!$auth_allowregistration)
{
  $rightcontent = $regdisabled;
}

//***********************************************************************
// Registration form / right panel
//***********************************************************************
$signinextra = getSignInExtra();

$rightpanel =<<<RIGHTPANEL
  <div class="col-md-7 d-flex flex-center">
    <div class="p-4 p-md-5 flex-grow-1">
      $rightcontent
      $signinextra
    </div>
  </div>
RIGHTPANEL;

//***********************************************************************
// Registration form / determine country
//***********************************************************************
$visitorip = $_SERVER['REMOTE_ADDR'];
if (isDebug() || $visitorip=='::1') $visitorip="152.66.115.1";

$countryscript =<<<COUNTRYSCR
<SCRIPT>
  async function determinecoutnry() {
      let myip='$visitorip';
      let url="https://api.hostip.info/country.php?ip="+myip;
      console.log(url);
      let response = await fetch(url);
      if (response.status !== 200)  return;
      let data = await response.text();
      let countryinput=document.getElementById("countrycode");
      countryinput.value = data;
      console.log(data);
  }
 
  determinecoutnry();
</SCRIPT>
COUNTRYSCR;

//***********************************************************************
// Registration form / captcha script
//***********************************************************************

$inputscript =<<<INPUTSCR
<SCRIPT>
  function inputcheck() {
      let d = Date.now();
      let fi = document.getElementById("firstinput");
      if (!fi || !fi.value || fi.value=="0") 
      {
         document.getElementById("firstinput").value = d;
      }
      let li = document.getElementById("lastinput");
      li.value = d;

      let firstinput=document.getElementById("firstinput").value;
      let lastinput=document.getElementById("lastinput").value;
      console.log("Timing: "+firstinput+" - "+lastinput);
  }
  inputcheck();  
</SCRIPT>
INPUTSCR;

//***********************************************************************
// Registration page
//***********************************************************************
$linkselectdifferentworkspace = getLinkSelectDifferentWorkspace();

$main =<<<MAIN
<div style="max-width:800px; margin-left:auto; margin-right:auto; padding-top:20px">
    <div class="card overflow-hidden z-index-1">
      <div class="card-body p-0">
        <div class="row g-0 h-100">
          $leftpanel  
          $rightpanel
        </div>
      </div>
    </div>
    $linkselectdifferentworkspace
</div>
$countryscript
$inputscript
MAIN;

//***********************************************************************
// Display the page
//***********************************************************************
echo $main;
?>