<?php
include_once("$sysdir/authentication/registrationcreateuser.php");

//*************************************************
// Password reset by admin
//*************************************************
//$updatemode = "add" | "overwrite"
function passwordReset($useremail,$newpassword,$updatemode,&$error)
{
	global $datadir,$myprivatekey,$myuserid,$adminuser;
	$error = "";

	if (filter_var($useremail, FILTER_VALIDATE_EMAIL)) 
	{
		$useremailhash = md5($useremail);
	} else if (ismd5($useremail))
	{
		$useremailhash = $useremail;
	} else
	{
		$error = "Invalid e-mail format.";
		return false;
	}

	$userdir = $datadir."/registrations/".$useremailhash;
	
	$adminprivatekey = $myprivatekey;

	if ($useremailhash==md5($adminuser))
	{
		return passwordResetAdmin($useremailhash, $adminprivatekey, $newpassword,$updatemode,$error);
	}

	$overwrite = true;
	if ($updatemode=="add") $overwrite=false;

	if (!is_dir($userdir)) {
		$error  = "Could not find this user.";
		return false;
	} 

	$shareddir = $userdir."/sharedto";
	$prstoadminfile = $shareddir."/".$myuserid."_rsa.txt";
	$prstoadminfileold = $shareddir."/".$myuserid."_prs.txt";
	if (!file_exists($prstoadminfile) && file_exists($prstoadminfileold))
	{
		copy($prstoadminfileold,$prstoadminfile);
	}

	if (!file_exists($prstoadminfile )) {
		$error  = "I am not allowed to reset this password.";
		return false;
	} 

	$userpemencrypted = file_get_contents($prstoadminfile);
	if (!decryptTextRSAAES($myprivatekey,$userpemencrypted,$decryptedpem,$error))	
	{
		$error  = "Could not decrypt user pem.";
		return false;
	}

	importRsaPrivateKeyFromPEM($decryptedpem, null, $userprivatekey, $userpublickey,$error);
	$pwhash = sha512($newpassword);
	if (!createPasswordForUser($useremailhash,$userprivatekey,$newpassword,$overwrite,$errorPassword))
	{
		$error = "Password not created. $errorPassword";
		return false;
	}

	$pempublicfile = $userdir."/publickey.txt";
	if (is_resource($userpublickey) && !file_exists($pempublicfile))
	{
		$pempublic = exportRsaPublicKeyToPEM($userprivatekey);
		file_put_contents($pempublicfile,$pempublic);
	}

	return true;
}

function passwordResetAdmin($adminuserid, $adminprivatekey,$newpassword,$updatemode,&$error)
{
	$overwrite = true;
	if ($updatemode=="add") $overwrite=false;
	return createPasswordForUser($adminuserid,$adminprivatekey,$newpassword,$overwrite,$error);
}


//*************************************************
// Password reset by user
//*************************************************
//$updatemode = "add" | "overwrite"
function passwordResetByUser($useremail,$userpassword,$newpassword,$updatemode,&$error)
{
	global $regdir;
	$error = "";

	if (filter_var($useremail, FILTER_VALIDATE_EMAIL)) 
	{
		$userid = md5($useremail);
	} else if (ismd5($useremail))
	{
		$userid = $useremail;
	} else
	{
		$error = "Cannot reset password. Invalid e-mail format.";
		return false;
	}

	$pwhash = sha512($userpassword);
	$pemprivatefile = "$regdir/$userid/privatekey_".$pwhash.".txt";

	if (!file_exists($pemprivatefile))
	{
		$error = "Cannot reset password. Invalid user password.";
		return false;
	}

	$pemprivate = file_get_contents($pemprivatefile);
	if (!importRsaPrivateKeyFromPEM($pemprivate,$userpassword,$userprivatekey,$publickey,$error))
	{
		$error = "Cannot reset password. Could not import private key. $error";
		return false;
	}

	$overwrite = false;
	if ($updatemode=="overwrite") $overwrite = true;
	if (!createPasswordForUser($userid,$userprivatekey,$newpassword,$overwrite,$errorc))
	{
		$error = "Cannot reset password. $errorc";
		return false;
	}
	
	return true;
}

?>