<?php
//**********************************************************
// Login / forgot password
//**********************************************************
delSessionData("lastusername");
delSessionData("lastpassword");
logoutFromSession();

$debugforgot = true;
$datavalid = false;
$useremail="";
$errorEmail="";
global $myaction;
loadReqParams('myaction');
$content = "";

//**********************************************************
// Default functions
//**********************************************************

function redirectToSecurityQuestions($useremail,&$guicontent,&$error)
{
  $guicontent = "";
  $useremailhash = md5($useremail);
  $location = "index.php?owpn=page_authentication_passwordrecovery&h=$useremailhash&nocache=".ozrndstr();
  global $debugredirects;
  if ($debugredirects) 
  {
    echo "Redirect after password forgot:<BR>";
    echo "<a href='$location'>$location</a>"; 
    exit;
  }
  $redirecturl = $location;
  error_log("passwordforgot 34:  Redirecting browser to $redirecturl. Original request: ".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']);
  header("X-Ozeki-Redirect: passwordforgot 31");
  header("Location: $redirecturl");
  return true;
}

function displayPasswordResetError($error)
{
    global $owpn;
    $passwordResetForm = <<<EMAILERR
      <div class="text-center text-md-start">
        <h4 class="mb-4 text-center">Password reset error</h4>
      </div>

      <div>
        <p class='text-danger text-center'>$error</p>
        </p>
      </div>
EMAILERR;

    return $passwordResetForm;
}


$passwordRecoveryFunctionDefault = "redirectToSecurityQuestions";
if (!isset($passwordRecoveryFunction)) $passwordRecoveryFunction = $passwordRecoveryFunctionDefault;

//**********************************************************
// Process password recovery request
//**********************************************************

if ($myaction=="start")
{
	global $useremail;
	loadReqParams('useremail');
	$useremailhash = md5($useremail);
	$userdir = $datadir."/registrations/".$useremailhash;
	
	//input data verification
	$datavalid = true;
	if (!filter_var($useremail, FILTER_VALIDATE_EMAIL)) {
		$errorEmail = "Invalid e-mail address";
		$datavalid = false;
	} 

  if (!is_dir($userdir)) {
		$errorEmail = "User not found";
		$datavalid = false;
	} 

  if ($datavalid)
  {
    if (!$passwordRecoveryFunction($useremail,$content,$error))
    {
        if ($debugforgot)
        {
            $content = displayPasswordResetError($error);
        }
        error_log("passwordforgot 66: password recovery request failed. '$passwordRecoveryFunction' $error");
        if (!isDebug()) $passwordRecoveryFunctionDefault($useremail,$content,$error);
    }

    if (isEmpty($content)) return;
  }
}

if ($myaction=="reset" && $passwordRecoveryFunction != $passwordRecoveryFunctionDefault)
{
    if (!$passwordRecoveryFunction("",$content,$error))
    {
      if ($debugforgot)
      {
          $content = displayPasswordResetError($error);
      }
      error_log("passwordforgot 92: password recovery reset failed '$passwordRecoveryFunction' $error");
    }

    if (isEmpty($content)) return;
}

//**********************************************************
// Ask for user e-mail address
//**********************************************************

$contentEmailForm = <<<EMAILFORM
 <div class="text-center text-md-start">
      <h4 class="mb-0 text-center">Forgot your password?</h4>
        <p class="mb-4 text-center">Please enter your email to start</p>
      </div>

      <form action='index.php' method='POST'>
      <input type='hidden' name='owpn' value='$owpn'>
      <input type='hidden' name='myaction' value='start'>

        <div class="mb-3">
          <label class="form-label" for="card-email">Email address</label>
          <input class="form-control" type="email" name="useremail" autocomplete="on" id="card-email" value="$useremail" />
          <span class="form-label" for="card-email" style="color:red; font-weight:bold">$errorEmail</span>
        </div>

        <div class="mb-3">
          <button class="btn btn-primary d-block w-100 mt-3" type="submit" name="submit">Recover my password</button>
        </div>

        <div class="mb-3 text-center">
          <span class="form-label" for="card-email" >
          If you can't recover your account using this page, send us an e-mail to info@ozeki.hu
          </span>
        </div>
      </form>
EMAILFORM;


if (isEmpty($content)) $content = $contentEmailForm;
if (!isset($loginPage) || isEmpty($loginPage)) $loginPage = "page_authentication_login";

$page = <<<PAGE
<div style="max-width:800px; margin-left:auto; margin-right:auto; padding-top:20px">
  <div class="card overflow-hidden z-index-1">
    <div class="card-body p-0">
      <div class="row g-0 h-100">
        <div class="col-md-5 text-center bg-card-gradient">
          <div class="position-relative p-4 light">
            <div class="bg-holder bg-auth-card-shape" style="background-image:url(/ozekiservices/system/attachments/1/falcon/assets/img/icons/spot-illustrations/half-circle.png);">
            </div>
            <!--/.bg-holder-->

            <div class="z-index-1 position-relative">                    
            <img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_portable_web_transparent_text.png" class="d-none d-md-inline" width="150px"/>
            <img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_web_transparent.png" class="d-md-none" width="200px"/> 
              <p class="mt-5 opacity-75 text-white text-center d-none d-md-block">To recover your password, please enter your e-mail address and click on the "Recover my password" button.</p>
              <a class="btn btn-primary btn-sm mt-3  d-none d-md-block" href="index.php?owpn=$loginPage">Return to Login</a>
            </div>
          </div>
          <div class="mt-2 mb-4 mt-md-2 mb-md-4 light  d-none d-md-block">
            <p class="mb-0 mt-2 mt-md-1 fs--1 fw-semi-bold text-white opacity-75 text-center">Read our <a class="text-decoration-underline text-white" href="https://ozeki.hu/index.php?owpn=3243">terms</a> and <a class="text-decoration-underline text-white" href="https://ozeki.hu/index.php?owpn=3242">conditions </a></p>
          </div>
        </div>
        <div class="col-md-7 d-flex flex-center">
          <div class="p-4 p-md-5 flex-grow-1">
              $content
          </div>
        </div>
        <div class="col-md-5 text-center bg-card-gradient d-md-none">
          <div class="position-relative p-4 light">
            <div class="bg-holder bg-auth-card-shape">
            </div>
            <!--/.bg-holder-->
            <div class="z-index-1 position-relative">                    
            <a class="btn btn-primary btn-sm mt-3 " href="index.php?owpn=page_authentication_login">Return to Login</a>
            </div>
          </div>
          <div class="mt-2 mb-4 mt-md-2 mb-md-4 light">
            <p class="mb-0 mt-2 mt-md-1 fs--1 fw-semi-bold text-white opacity-75 text-center">Read our <a class="text-decoration-underline text-white" href="https://ozeki.hu/index.php?owpn=3243">terms</a> and <a class="text-decoration-underline text-white" href="https://ozeki.hu/index.php?owpn=3242">conditions </a></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

PAGE;

echo $page;

  ?>
