<?php
include_once("$sysdir/authentication/login.inc.php");
include_once("$sysdir/authentication/registrationsecondary.php");

//**********************************************************
// Login / login form
//**********************************************************

function handleLoginFormRequest()
{
	global $regdir,$userpasswordencrypted,$logincookiename,$regdir,$loggedin,$myaction,$loginmode,
	$myemail,$email,$password,$_OZREQUEST,$userid,$userdir,$pwhash,$pwhashnew,$errorEmail,$errorPassword,
	$pemprivatefile, $pemprivatefilenew,$mypassword,$auth_provider_func,$debugsession,$debuglog,$debugredirects;
	
	$myemail = strtolower($myemail ?? "");
	$loggedin = false;
	$email="";
	$userpasswordencrypted =(array_key_exists($logincookiename,$_COOKIE)) ? $_COOKIE[$logincookiename] : "";
	if (array_key_exists("setsessionaccount",$_POST) && isset($_POST["setsessionaccount"]) && !isempty($_POST["setsessionaccount"])) $userpasswordencrypted = $_POST["setsessionaccount"];

	loadReqParams("myaction","myemail","mypassword");
	if ($myaction !="login") return;
	
	$myemail = strtolower($myemail ?? "");
	$userid = ismd5($myemail)? $myemail : md5($myemail);
	$emailorphone = $myemail;
	$userdir = $regdir."/".$userid;
	$password = $mypassword;

	if(!forwardIfSecondaryUser($userid,$_,$error))
	{
		$errorPassword = "Cannot login with a secondary user account. Please use the primary user account to login.";
		return;
	}

	$datavalid=true;
	if (strlen($emailorphone)<4) 
	{
		$errorEmail = "Invalid e-mail address or username or phone number (too short)";
		$datavalid = false;
	} 

	if ($datavalid && !isPasswordTooShort($password, $error))
	{
		$errorPassword = "Invalid password. $error";
		$datavalid = false;
	}

	if (!isset($auth_allowregistration)) $auth_allowregistration = true;

	if ($auth_allowregistration && ! ( isemail2($emailorphone) || ismd5($emailorphone) || isPhoneNumberInternational($emailorphone))) {
		$errorEmail = "Invalid e-mail address or phone number";
		$datavalid  = false;
	}

	if ($datavalid && strlen($password)<4)
	{
		$errorPassword = "Invalid password (too short)";
		$datavalid = false;
	}

	$usersecret = "";
	if (!$auth_provider_func($userid,$password,$usersecret,$error))
	{
		$errorPassword = "Authentication error. $error";
		$datavalid = false;
	} 
	else 
	{
		$password = $usersecret;
	}

	if ($datavalid && !is_dir($userdir))
	{
		if (!isset($fullname) || isempty($fullname)) $fullname = $emailorphone;
		$emailaddress = $emailorphone;
		if (!filter_var($emailaddress, FILTER_VALIDATE_EMAIL)) $emailaddress = $emailaddress."@localhost.com";
		if (!createUser($userid,$emailaddress,$fullname,$password,$privatekey,$error))
		{
			$errorPassword = "First time login failed. $error";
			$datavalid = false;
		}
	}

	if ($datavalid && !is_dir($userdir))
	{
		$errorEmail = "Ozeki Account not found";
		$datavalid = false;
	}
	

	$pwhash = sha512($password);
	$pemprivatefile = $regdir."/".$userid."/privatekey_".$pwhash.".txt";

	if ($datavalid && !file_exists($pemprivatefile))
	{
		$errorPassword = "Could not load private key";
		$datavalid = false;
	}
	
	//echo "Login result: $datavalid; error: $errorPassword; userid: $userid; password: $password"; exit;

	if ($debugsession)
	{
		ob_start();
		echo "<hr><b>Login form request evaluation.</b><br>";
		echo "Login result: $datavalid<BR>";
		echo "Login error: $errorPassword<BR>";
		echo "Login userid: $userid<BR>";
		echo "Login password: $password<BR>";
		
		$debuglog .= ob_get_contents();
		ob_end_clean();
	}

	//Successful login
	if ($datavalid)
	{
		loginToSession($userid,$password);
		if ($debugsession) $debugredirects = true;
		redirectAfterLogin();
	} 
}

//**********************************************************
// logout
//**********************************************************
function handleLogoutRequest()
{
	global $loginmode;
	loadReqParams("loginmode");
	if ($loginmode=='logoutfirst')
	{
		logoutFromSession();
	}
}

//**********************************************************
// Login / login cookie
//**********************************************************

function handleLoginSessionRequest()
{
	global $regdir,$loggedin,$sessionkeyname,$loginsessionkey,$userpasswordencrypted,$userid,$myprivatekey,$mypublickey,$myaesprivate,$myaesshared,
	$mydetails,$loginerror,$logincookiename,$userdir,$mypublickeypem,$email,$myuserid,$debugsession,
	$myemail,$myfullname,$mymobile,$mynick,$myaccesskey,$mypassword,$debuglog;

	$loginpossible = true;

	if (!isset($loginsessionkey) || $loginsessionkey == "" || $loginsessionkey == "logout" || $userpasswordencrypted=="")
	{
		$loginerror = "Login session key is null";
		$loginpossible = false;
	}

	if ($loginpossible) 
	{
		$mypassword = decryptTextAES($loginsessionkey, $userpasswordencrypted);
		$loginpossible = loginUser($userid,$mypassword,$myprivatekey,$mypublickey,$myaesprivate,$myaesshared,$mydetails,$loginerror);
	}

	if ($debugsession)
	{
		ob_start();
		echo "<hr><b>Before session evaluation.</b><br>";
		echo "Session key: $loginsessionkey<br>";
		echo "Encrypted password: $userpasswordencrypted<br>";
		echo "Decrypted password: $mypassword<br>";
		echo "Login possible: $loginpossible<br>";
		echo "Login error: $loginerror<br>";
		echo "Ozeki 10 frame:".isOzeki10Frame();
		$debuglog .= ob_get_contents();
		ob_end_clean();
	}

	if ($loginpossible && !isPasswordTooShort($mypassword, $error))
	{
		$loginpossible = false;
	}

	if ($loginpossible) {
		$loggedin=true;

		//set global variables
		$userdir = $regdir."/".$userid;
		$mypublickeypem = exportRsaPublicKeyToPEM($mypublickey);
		$email = strtolower($mydetails["email"]);
		$myemail = strtolower($mydetails["email"]);
		$myuserid = $userid;
		$myfullname = $mydetails["fullname"];
		$mymobile = $mydetails["mobile"];
		$mynick = $mydetails["nick"];
		if (isEmpty($mynick)) $mynick = $mydetails["fullname"];
		$myaccesskey = array_key_exists("accesskey",$mydetails) ? $mydetails["accesskey"] : null;

		//refresh cookie
		setcookie($logincookiename, $userpasswordencrypted, time()+31556926, "/"); // 31556926 = 1 year

		//save browser session
		delSessionData("lastusername",false);
		delSessionData("lastpassword",true);
		saveBrowserSession();
	} 
	else 
	{
		$loginsessionkey = "logout";
		addSessionData($sessionkeyname, $loginsessionkey);
	} 

	if ($debugsession)
	{
		$debuglog .= displayLoginInfo("After session evaluation.");
	}
}

//**********************************************************
// Do the work
//**********************************************************

handleLoginFormRequest();
handleLogoutRequest();
handleLoginSessionRequest();

?>