<?php 

addSessionData("LoginPageVisitedAt", "myozeki.com");

$lastusername = getEncryptedSessionData("lastusername");
$lastpassword = getEncryptedSessionData("lastpassword");

if ($email=="" && !isEmpty($lastusername))
{
    $email = $lastusername;
}

if ((!isset($password) || $password=="") && (!isEmpty($lastpassword)))
{
    $password = $lastpassword;
}

if (!isset($errorEmail)) $errorEmail="";
if (!isset($errorPassword)) $errorPassword="";
if (!isset($email)) $email="";
if (!isset($password)) $password="";

//***********************************************************************
// login form location support
//***********************************************************************
if (!isset($registrationtarget) || isEmpty($registrationtarget)) $registrationtarget="owpn";
if (!isset($registrationpage) || isEmpty($registrationpage)) $registrationpage="page_authentication_registration";
if (!isset($logintarget) || isEmpty($logintarget)) $logintarget="owpn";
if (!isset($loginpage) || isEmpty($loginpage)) $loginpage=$page_authentication_login;

$formExtra = getFormExtra();
$linkextra = getLinkExtra();

//***********************************************************************
// Forget password offer
//***********************************************************************
if (!isset($forgotpasswordpage)) $forgotpasswordpage = "page_authentication_passwordforgot";
$forgetOffer = "";
global $auth_allowregistration;
if ($auth_allowregistration)
{
    $forgetgOffer = <<<FORGETOFFER
    <div class="col-auto"><a class="fs--1" href="index.php?owpn=$forgotpasswordpage">Forgot Password?</a></div>
FORGETOFFER;
}

//***********************************************************************
// User name
//***********************************************************************

$userNameLabel = "Email or phone number";
$userNameType = "type=\"email\"";
if (!$auth_allowregistration)
{
    $userNameLabel = "Username";
    $userNameType = "";
}

//***********************************************************************
// login form
//***********************************************************************
if (!isset($loginurl) || $loginurl=="") {
    $loginurl = "index.php?$logintarget=$loginpage".nocache();
}

if (isEmpty($email) && array_key_exists("loginemail",$_REQUEST))
{
    $email = strtolower($_REQUEST["loginemail"]);
}

if (isEmpty($password) && array_key_exists("loginpassword",$_REQUEST))
{
    $password = $_REQUEST["loginpassword"];
}

$form = <<<LOGINFORMEND
  <div class="row flex-between-center">
    <div class="col-auto">
      <h3>Account Login</h3>
    </div>
  </div>
  <form action="$loginurl" method="post">
      $formExtra
      <input type="hidden" name="registrationview" value="loginform">
      <input type="hidden" name="myaction" value="login">
        <div class="mb-3">
          <label class="form-label" for="card-email">$userNameLabel</label>
          <input class="form-control" id="card-email" type="text" name="myemail" value="$email" />
          <span style='color:red;font-weight:bold'>$errorEmail</span>
        </div>
        <div class="mb-3">
          <div class="d-flex justify-content-between">
            <label class="form-label" for="mypassword">Password</label>
          </div>
          <div class="d-flex justify-content-between">
          <input class="form-control" id="mypassword" type="password" name="mypassword" value="$password"/>
          <span style="margin-left:-28px; margin-top:7px; width:30px;height:24px;" onclick="convertType(mypassword)"><img src="/ozekiservices/system/attachments/1/img/visibility.svg"></span>
          </div>
          <span style='color:red;font-weight:bold'>$errorPassword</span>
          
        </div>
        <div class="row flex-between-center">
          <div class="col-auto">
            <div class="form-check mb-0">
              <input class="form-check-input" type="checkbox" id="card-checkbox" checked="checked" />
              <label class="form-check-label mb-0" for="card-checkbox">Remember me</label>
            </div>
          </div>
          $forgetgOffer
        </div>
        <div class="mb-3">
          <button class="btn btn-primary d-block w-100 mt-3" type="submit" name="submit">Login</button>
        </div>
  </form>
  <script>
      let emailInput = document.getElementById("card-email");
      emailInput.focus();

      function convertType(elem)
      {
          var input = document.createElement('input');
          input.id = elem.id;
          input.name = elem.name;
          input.value = elem.value;
          input.onfocus = elem.onfocus;
          input.onblur = elem.onblur;
          input.className = elem.className;
          if (elem.type == 'text' )
            { input.type = 'password'; }
          else
            { input.type = 'text'; }
      
          elem.parentNode.replaceChild(input, elem);         
        return input;
      }

  </script>
LOGINFORMEND;

//***********************************************************************
// login buttons
//***********************************************************************
$fullname="";
if ($mydetails != null) 
{
	$fullname = $mydetails["fullname"];
}

if (!isset($logouturl) || $logouturl=="") $logouturl = "index.php?owpn=page_authentication_logout";
if (!isset($dashboardurl) || $dashboardurl=="") $dashboardurl = "index.php?owpn=page_dashboard";
if (!isset($dashboardpost) || $dashboardpost=="") $dashboardpost = "<input type=\"hidden\" name=\"owpn\" value=\"page_dashboard\">";

$buttons = <<<LOGINBUTTONS
    <div class="row flex-between-center">
      <div class="col-center">
        <h3 class="text-center">You are logged in as</h3>
      </div>
    </div>

    <div class="row flex-between-center">
      <div class="col-center">
        <h3 class="text-center" style="color:green;">$fullname</h3>
      </div>
    </div>

    <div class="mb-3">
        <form action="$dashboardurl" method="POST">$dashboardpost
        <input type="submit" class="btn btn-primary d-block w-100 mt-3" value="Open dashboard">
        </form>
    </div>

    <div class="mb-3">
        <a href="$logouturl"><button class="btn btn-danger d-block w-100 mt-3" style="background-color: red;">Click here to logout</button></a>
    </div>
LOGINBUTTONS;

if (!$loggedin) { 
  $content = $form;              
} else { 
  $content = $buttons;
} 

//***********************************************************************
// IP address and user agent info for staff
//***********************************************************************
$ip = oziptofilename($_SERVER["REMOTE_ADDR"]);
$staffipflag = "$datadir/services/visitorlog/ips/$ip/staff.txt";
$siteinf = "Copyright 2000-".date("Y")." Ozeki Systems Ltd. ";
if (isDebug()) // || file_exists($staffipflag)
{
  $siteinf .= "<br>Your are using ".$_SERVER["SERVER_NAME"]." (".$_SERVER["SERVER_ADDR"].") browser: ".$_SERVER["REMOTE_ADDR"]."<BR>\r\n";
  $siteinf .= $_SERVER['HTTP_USER_AGENT']."\r\n";
}
if (isOzeki10Debug())
{
  $siteinf .= "<br>Served by Ozeki 10. ".$_SERVER["SERVER_NAME"]." (".$_SERVER["SERVER_ADDR"].") browser: ".$_SERVER["REMOTE_ADDR"]."<BR>\r\n";
}

$siteinfo = "\r\n<CENTER><span style='color:#cecece'>\r\n";
$siteinfo .= $siteinf;
$siteinfo .= "</span></CENTER>\r\n";

//***********************************************************************
// Registration offer
//***********************************************************************

if (!isset($registerurl) || $registerurl=="") $registerurl = "index.php?$registrationtarget=$registrationpage";

$regOffer = "";
global $auth_allowregistration;
if ($auth_allowregistration)
{
    $regOffer = <<<REGOFFER
    <p class="text-white text-center"> New user?<br>
            
    <form action="$registerurl" method="POST">
      $formExtra
      <input type="hidden" name="registrationview" value="registrationform">
      <input type="submit" class="btn btn-outline-light mt-2 px-4" value='Create an account!'></button>
    </form>
  </p>
REGOFFER;
}

//***********************************************************************
// Load workspace name
//***********************************************************************
$workspacenameLabel = "";
$workspaceconfig = "$configdir/workspace.php";
if (file_exists($workspaceconfig))
{
    include_once($workspaceconfig);
    global $workspacename;
    if (!isset($workspaceTitle)) $workspaceTitle = $workspacename;
    $workspacenameLabel = "<h3 class='mb-3' style='color:#2c7be5; '><center>$workspaceTitle</center></h3><hr>";
}

//***********************************************************************
// Return the page
//***********************************************************************
$signinextra = getSignInExtra();
$linkselectdifferentworkspace = getLinkSelectDifferentWorkspace();

$ret= <<<LOGINPAGE
<div style="max-width:800px; margin-left:auto; margin-right:auto; padding-top:20px">
  <div class="card overflow-hidden z-index-1">
    <div class="card-body p-0">
      <div class="row g-0 h-100">
        <div class="col-md-5 text-center bg-card-gradient">
          <div class="position-relative p-4 pb-1 light">

            <div class="z-index-1 position-relative" >
              <img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_portable_web_transparent_text.png" class="d-none d-md-inline" width="150px"/>
              <img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_web_transparent.png" class="d-md-none" width="200px"/> 
              <p class="mt-3 text-white text-center"><h3 class="text-white text-center">Account</h3></p>
            </div>
          </div>
          <div class="mt-1 mb-1 mt-md-0 mb-md-5 light">
            $regOffer
            <p class="mb-0 mt-2 mt-md-3 fs--1 fw-semi-bold text-white opacity-75 text-center d-none d-md-block">Read our <a class="text-decoration-underline text-white" href="https://ozeki.hu/index.php?owpn=3243" target="_blank">terms</a> 
            and <a class="text-decoration-underline text-white" href="https://ozeki.hu/index.php?owpn=3242" target="_blank">conditions </a></p>
          </div>
        </div>
        <div class="col-md-7 ">
          <div class="row p-3 ps-md-5 pe-md-5 pt-md-5">
          $workspacenameLabel
          $content
          </div>
          $signinextra
        </div>
      </div>
    </div>
  </div>
  $linkselectdifferentworkspace
  $siteinfo
</div>
LOGINPAGE;

echo $ret;
echo displayDebugLog();
?>