<?php
//**********************************************************
// Login / functions
//**********************************************************
$sessionkeyname = "loginsessionkey";
$nameofuserid = "userid";

//**********************************************************
// Login info
//**********************************************************
function displayLoginInfo($title)
{
	global $loggedin,$loginsessionkey,$userpasswordencrypted,$userid,$mypassword,$logincookiename,$sessionfilebrowser,$sessionrootbrowser,
	$myfullname,$myaesshared,$myaesprivate,$mydetails,$mypublickeypem,$loginerror;

	$ret = "<hr><b>$title</b><br>";

	$ret .= "Logged in: $loggedin<br>";
	$ret .= "Login cookie name: $logincookiename<BR>";
	$ret .= "Login cookie value: $userpasswordencrypted<br>";
	$ret .= "Password encrypted: $userpasswordencrypted<br>";
	$ret .= "Session key: $loginsessionkey<br>";
	$ret .= "My userid: $userid<br>";
	$ret .= "My password: $mypassword<br>";
	$ret .= "My fullname: $myfullname<br>";
	$ret .= "My aes shared: $myaesshared<br>";
	$ret .= "My aes private: $myaesprivate<br>";
	$ret .= "My details: $mydetails<br>";
	$ret .= "My publick key pem: $mypublickeypem<br>";
	$ret .= "Error: $loginerror<br>";
	$ret .= "Session dir: $sessionrootbrowser<br>";
	$ret .= "Session file: $sessionfilebrowser<BR>";
	$ret .= $extra;
	return $ret;
}

//**********************************************************
// Login after successful authentication
//**********************************************************
function loginToSession($userid,$password)
{
	global $sessionkeyname,$nameofuserid,$logincookiename,$loggedin,$userpasswordencrypted, $sessionfilebrowser, $debugsession, $debuglog,$loginsessionkey;

	$loginsessionkey = generateAesKey();
	addSessionData($sessionkeyname, $loginsessionkey);
	addSessionData($nameofuserid, $userid);
	$userpasswordencrypted = encryptTextAES($loginsessionkey, $password);
	setcookie($logincookiename, $userpasswordencrypted, time()+31556926, "/"); // 31556926 = 1 year

	if ($debugsession)
	{
		$debuglog .= displayLoginInfo("Login to session request.");
	}
	
	$loggedin = true;
}

function logoutFromSession()
{
	global $sessionkeyname,$nameofuserid,$logincookiename,$loggedin,$userpasswordencrypted,$loginsessionkey;
	addSessionData($sessionkeyname, "logout");
	addSessionData($nameofuserid, "logout");
	setcookie($logincookiename, "logout", time()+31556926, "/"); // 31556926 = 1 year
	$loggedin = false;
	$loginsessionkey = "";
	$userpasswordencrypted = "";
}

function isUserLoggedIn(&$error)
{
	global $loggedin,$userdir,$userid,$mydetails;
	if (!$loggedin) { $error = "No one is logged in"; return false; }
	if (!is_dir($userdir)) { $error = "Could not find user dir"; return false; }
	if (strlen($userid)!=32) { $error = "Invalid email hash"; return false; }
	if (strlen($mydetails["fullname"])==0) { $error = "No full name provided"; return false; }
	return true;
}

function redirectAfterLogin()
{
	global $afterlogintarget,$afterloginpage,$afterloginextra,$setupservice,$page_dashboard,$debugredirects,$debuglog;
	loadReqParams("afterlogintarget","afterloginpage","afterloginextra","setupservice");
	if (isEmpty($afterlogintarget)) $afterlogintarget="owpn";
	if ($afterloginpage==0) $afterloginpage="";
	if (isEmpty($afterloginpage)) $afterloginpage= getDefaultFirstPage();
	if (!isEmpty($afterloginextra)) $afterloginextra=urldecode($afterloginextra);
	if (!isEmpty($setupservice)) $afterloginextra.="&setupservice=$setupservice";
	$afterloginextra .= getLinkExtra();
	$location = "index.php?$afterlogintarget=$afterloginpage&justloggedin=true&$afterloginextra".nocache();
	$location = preg_replace("/&&*/","&",$location);
	if ($debugredirects) 
	{
		echo "<hr><font style='color:red;font-weight:bold'>Redirect after login:</font><BR>";
		echo "<a href='$location'>$location</a>"; 
		echo $debuglog;
		exit;
	}
	$redirecturl = $location;
	error_log("login.inc.php 61:  Redirecting browser to $redirecturl. Original request: ".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']);
	header("X-Ozeki-Redirect: login.inc 61");
	header("Location: $redirecturl");
}

function isLoginPasswordOk($userid,$password)
{
	global $regdir;
	$pwhash = sha512($password);
	$pemprivatefile = "$regdir/$userid/privatekey_".$pwhash.".txt";
	if (file_exists($pemprivatefile)) return true;
	return false;
}

function setPasswordToReadonly($userid,$password)
{
	global $regdir;
	$pwhash = sha512($password);
	$pemprivatefile = "$regdir/$userid/privatekey_".$pwhash.".txt";
	if (!file_exists($pemprivatefile)) return false;
	copy($pemprivatefile,$pemprivatefile.".readonly");
	return true;
}

function isPasswordReadonly($userid,$password)
{
	global $regdir;
	$pwhash = sha512($password);
	$pemprivatefile = "$regdir/$userid/privatekey_".$pwhash.".txt.readonly";
	if (file_exists($pemprivatefile)) return true;
	return false;
}

function getUserKey($md5userid,$sha512pass,&$error)
{
	global $regdir;
	$pemprivatefile = $regdir."/".$md5userid."/privatekey_".$sha512pass.".txt";		
	if (!file_exists($pemprivatefile))
	{
		$error = "Invalid user or password.";
		return false;
	}
	return true;
}

function loginUser($userid,$password,&$privatekey,&$publickey,&$aesprivate,&$aesshared,&$userdetails,&$error)
{
	global $regdir;

	if (!ismd5($userid)) 
	{
		$error = "Invalid user hash provided: $userid";
		return false;
	}
	
	$userdir = "$regdir/$userid";
	if (!is_dir($userdir)) 
	{
		$error = "User directory does not exist";
		return false;
	}

	if (!is_dir($userdir)) 
	{
		$error = "User directory does not exist";
		return false;
	}
	
	if (!isPasswordTooShort($password,$error) && !isOzeki10Frame())
	{
		$error = "Invalid password data";
		return false;
	}

	$pwhash = sha512($password);
	$userdir = $regdir."/".$userid;
	$pemprivatefile = $userdir."/privatekey_".$pwhash.".txt";		
	if (!file_exists($pemprivatefile))
	{
		$error = "Invalid user password.";
		return false;
	}

	$pemprivate = file_get_contents($pemprivatefile);
	if (!importRsaPrivateKeyFromPEM($pemprivate,$password,$privatekey,$publickey,$error))
	{
		$error = "Could not import private key. $error";
		return false;
	}

	$aessharedfile = $userdir."/aesshared.txt";
	$aessharedencrypted = file_get_contents($aessharedfile);
	if (!decryptTextRSA($privatekey,$aessharedencrypted,$aesshared,$error))
	{
		$error = "Cannot decrypt aes shared key ".$error;
		return false;
	}

	$aesprivatefile = $userdir."/aesprivate.txt";
	$aesprivateencrypted = file_get_contents($aesprivatefile);
	if (!decryptTextRSA($privatekey,$aesprivateencrypted,$aesprivate,$error))
	{
		$error = "Cannot decrypt aes private key ".$error;
		return false;
	}

	$userdir = $regdir."/".$userid;
	$regfile = $userdir."/registration.txt";
	if (!file_exists($regfile))
	{
		$error = "Cannot find user details file (registration.txt)";
		return false;
	}
	$regdataencrypted = file_get_contents($regfile);
	$regdataencoded = decryptTextAES($aesshared,$regdataencrypted);
	$userdetails = json_decode($regdataencoded,true);
	$userdetails["passwordhash"]=sha512($password);
	if (!array_key_exists("nick",$userdetails)) $userdetails["nick"]="";

	if (!file_exists($userdir."/public.txt"))
	{
		global $sysdir;
		include_once("$sysdir/authentication/registrationcreateuser.php");
		updatePublicDetails($userid, $userdetails["fullname"], $userdetails["nick"]);
	}

	return true;
}

//***********************************************************************
// Return the sign in buttons
//***********************************************************************
function getSignInExtra()
{
  //if (isBrowserIPhone()) return "";
  
  global $signinbuttons;
  $signinextra = "";
  $signinbuttonhtml = "";
  if (is_array($signinbuttons))
  {
      foreach($signinbuttons as $key=>$signinbutton)
      {
          $signinbuttonhtml .= $signinbutton();
      }

      $signinextra = <<<SIGNINBUTTONS
      <div class='row pe-3 ps-3 ps-md-5 pe-md-5 pb-3'>
        <div class='ms-auto me-auto' style='border-top:1px solid black;'>
          <div class='text-center'>optionally sign in with:</div>
        </div>
        <div class='ms-auto me-auto' style='width:unset'>
          $signinbuttonhtml
        </div>
      
      </div>
SIGNINBUTTONS;
  }
  return $signinextra;
}

//**********************************************************
// Workspace selector
//**********************************************************

function getLinkSelectDifferentWorkspace()
{
	if(!isBrowserOzeki()&&!isBrowserCef())return"";
	return<<<BTN
	<center><a role="button" class="fs--1" onclick="bindOzWebViewIfPossible().then(() => { window.ozWebView && window.ozWebView.showWorkspaceSelector && window.ozWebView.showWorkspaceSelector() })">Select a different workspace</a></center>
BTN;
}

?>
