<?php
// To use another server for authentication add the following
// lines to config.php
//
// $auth_server_url = "https://myozeki.com/index.php?srv=api&api=account";
// $auth_provider = "remote"; // remote | default
//
// Browser -> Server (localhost) -> Server (myozeki.com)
//      ok <-   create account   <- ok response
//

function authenticate_remote($username,$password,&$usersecret,&$error)
{
    global $regdir, $auth_server_url;
    
    // Prepare the authentication data
    $userid = ismd5($username) ? $username : md5($username);
    $pwhash = sha512($password);
    
    // Create JSON payload for the API request
    $data = array(
        "action" => "login",
        "userid" => $userid,
        "pwhash" => $pwhash
    );
    
    // Convert data to JSON
    $json_data = json_encode($data);

    // Initialize curl
    $ch = curl_init();
    
    // Set curl options
    curl_setopt($ch, CURLOPT_URL, $auth_server_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Content-Length: ' . strlen($json_data)
    ));
    
    // Execute the request
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error_curl = curl_error($ch);
    
    // Close curl
    curl_close($ch);
    
    // Check for curl errors
    if ($error_curl) {
        $error = "Curl error: " . $error_curl;
        return false;
    }
    
    // Check HTTP response code
    if ($http_code !== 200) {
        $error = "HTTP error: " . $http_code;
        return false;
    }
    
    // Decode JSON response
    $resp = json_decode($response, true);
    
    // Check if authentication was successful
    if (isset($resp['status']) && $resp['status'] === 'OK') {
        $usersecret = $password; // Set user secret as password for compatibility

        $pkencoded = $resp["privatekey"];
        $publickey = $resp["publickey"];
        $aesprivateencrypted = $resp["aesprivatekey"];
        $aessharedencrypted = $resp["aessharedkey"];
        $regdata = $resp["registration"];

        //$pwhash = generateSha512Hash($password);
	    $pwhash = sha512($password);
	    $pemprivatefile = $regdir."/".$userid."/privatekey_".$pwhash.".txt";

        if (!ozmkdir("$regdir/$userid",$error))
        {
            return false;
        }

        if (!file_exists($pemprivatefile))
        {
            if (!file_put_contents($pemprivatefile,$pkencoded))
            {
                $error = "Cannot write user private key ".error_get_last()["message"];
                return false;
            };
            
            $aessharedfile = "$regdir/$userid/aesshared.txt";
            if (!file_put_contents($aessharedfile, $aessharedencrypted))
            {
                $error = "Cannot write user aes shared key ".error_get_last()["message"];
                return false;
            }

            $aesprivatefile = "$regdir/$userid/aesprivate.txt";
            if (!file_put_contents($aesprivatefile, $aesprivateencrypted))
            {
                $error = "Cannot write user aes private key ".error_get_last()["message"];
                return false;
            }

            $regfile = "$regdir/$userid/registration.txt";
            if (!file_put_contents($regfile, $regdata))
            {
                $error = "Cannot write user redigestration data ".error_get_last()["message"];
                return false;
            }

            $pempublicfile ="$regdir/$userid/publickey.txt";
            if (!file_put_contents($pempublicfile,$publickey))
            {
                $error = "Cannot write user public key ".error_get_last()["message"];
                return false;
            }
        }

        $error = ""; // Clear any error
        return true; // Authentication successful
    } else {
        // Authentication failed, set appropriate error message
        $error = isset($response_data['errormessage']) ? $response_data['errormessage'] : "Authentication failed";
        return false;
    }
}

?>