<?php
//**********************************************************
// App details
//**********************************************************
addsrv("authentication");
$root = "$sysdir/authentication";

//**************************************************************
// Default settings
//**************************************************************
if (!isset($auth_allowregistration)) $auth_allowregistration = true;
if (!isset($auth_provider)) $auth_provider = "default";
if (!issafefile($auth_provider)) $auth_provider = "default";
$auth_provider_file = "$sysdir/authentication/authproviders/auth_$auth_provider.php";
if (!file_exists($auth_provider_file)) $auth_provider = "default";
include_once($auth_provider_file);
$auth_provider_func = "authenticate_$auth_provider";

//**********************************************************
// Dependencies
//**********************************************************
if (!isapi()) 
{
    include_once("$sysdir/authentication/registrationcreateuser.php");
    include_once("$sysdir/authentication/loginsession.php");
}

//**********************************************************
// Pages
//**********************************************************
addphidden("registration.php");
addphidden("login.php");
addphidden("logout.php");
addphidden("passwordforgot.php");
addphidden("passwordrecovery.php");

//**********************************************************
// Quest pages
//**********************************************************
$guestpages[] = $page_authentication_login;
$guestpages[] = $page_authentication_logout;
$guestpages[] = $page_authentication_registration;
$guestpages[] = $page_authentication_passwordforgot;
$guestpages[] = $page_authentication_passwordrecovery;

?>