﻿using System;
using Android.App;
using Android.OS;
using Android.Runtime;
using Android.Views;
using AndroidX.AppCompat.Widget;
using AndroidX.AppCompat.App;
using Google.Android.Material.FloatingActionButton;
using Google.Android.Material.Snackbar;
using Ozeki.Media;
using Ozeki.VoIP;
using Android.Widget;

namespace _08_AutoDialer
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme.NoActionBar", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        Button _btnLogin;
        TextView _log;
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            SetContentView(Resource.Layout.activity_main);

            TestIfUserLoggedIn();

            _btnLogin = FindViewById<Button>(Resource.Id.btnLogin);
            _btnLogin.Click += OnClick__btnLogin;

            _log = FindViewById<TextView>(Resource.Id.log);
        }

        private void OnClick__btnLogin(object sender, EventArgs e)
        {
            string displayName = FindViewById<EditText>(Resource.Id.inputDisplayName).Text;
            string userName = FindViewById<EditText>(Resource.Id.inputUserName).Text;
            string authenticationId = FindViewById<EditText>(Resource.Id.inputAuthenticationID).Text;
            string registerPassword = FindViewById<EditText>(Resource.Id.inputRegisterPassword).Text;
            string domainHost = FindViewById<EditText>(Resource.Id.inputDomainHost).Text;
            int domainPort = -1;

            try
            {
                domainPort = Int32.Parse(FindViewById<EditText>(Resource.Id.inputDomainPort).Text);
            }
            catch (Exception exception)
            {
                _log.Text += "Please provide a valid PORT number!\n";
            }

            if (!string.IsNullOrEmpty(displayName) && !string.IsNullOrEmpty(userName)
                && !string.IsNullOrEmpty(authenticationId) && !string.IsNullOrEmpty(registerPassword)
                && !string.IsNullOrEmpty(domainHost) && domainPort != -1)
            {
                /*
                    In this part of the code we use the Xamarin.Essentials.Preferences
                    to store our session details.
                */

                Xamarin.Essentials.Preferences.Set("display_name", displayName);
                Xamarin.Essentials.Preferences.Set("user_name", userName);
                Xamarin.Essentials.Preferences.Set("authentication_id", authenticationId);
                Xamarin.Essentials.Preferences.Set("register_password", registerPassword);
                Xamarin.Essentials.Preferences.Set("domain_host", domainHost);
                Xamarin.Essentials.Preferences.Set("domain_port", domainPort);

                StartActivity(typeof(DialingActivity));
            }
            else
            {
                _log.Text += "Please fill all the required fields!\n";
            }
        }

        /*
            This method tests if the user logged in, by testing if the
            Xamarin.Essentials.Preferences contains the "display_name" key.
            If it doesn't, it means that we do not have a stored session because
            when we press the logout button in the MessaingActivity, it clears
            the Preferences.
        */

        private void TestIfUserLoggedIn()
        {
            if (Xamarin.Essentials.Preferences.ContainsKey("display_name"))
            {
                StartActivity(typeof(DialingActivity));
            }
        }

        public override bool OnCreateOptionsMenu(IMenu menu)
        {
            MenuInflater.Inflate(Resource.Menu.menu_main, menu);
            return true;
        }

        public override bool OnOptionsItemSelected(IMenuItem item)
        {
            int id = item.ItemId;
            if (id == Resource.Id.action_settings)
            {
                return true;
            }

            return base.OnOptionsItemSelected(item);
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}
