﻿using Android.App;
using Android.OS;
using Android.Widget;
using System;
using System.Collections.Generic;
using Ozeki.VoIP;
using System.IO;
using Android.Content.Res;
using System.Text;
using Android.Text.Method;

namespace _08_AutoDialer
{
    [Activity(Label = "DialingActivity")]
    public class DialingActivity : Activity
    {
        TextView _status;
        TextView _btnLogout;
        bool _registered;
        Softphone _mySoftphone;
        string _filename;
        CallInfo _callInfo;
        List<CallInfo> _callList;
        Autodialer _autodialer;
        int _maxConcurrentCall;
        Button _btnInteractions;
        TextView _listOfNumbers;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            SetContentView(Resource.Layout.activity_dialing);

            ReadCSV();
            _registered = false;
            InitSoftphone();
            Register();

            _maxConcurrentCall = 1;

            _status = FindViewById<TextView>(Resource.Id.status);
            _listOfNumbers = FindViewById<TextView>(Resource.Id.listOfNumbers);
            _listOfNumbers.MovementMethod = new ScrollingMovementMethod();

            ReadCSV();
            LoadNumbers();

            _btnLogout = FindViewById<TextView>(Resource.Id.btnLogOut);
            _btnLogout.Click += delegate
            {
                if (_registered)
                {
                    _mySoftphone.Unregister();
                }
                Xamarin.Essentials.Preferences.Clear();
                StartActivity(typeof(MainActivity));
            };

            _btnInteractions = FindViewById<Button>(Resource.Id.btnInteractions);
            _btnInteractions.Click += delegate
            {
                if (_registered)
                {
                    StartAutodialer();
                }
            };
        }

        void InitSoftphone()
        {
            _mySoftphone = new Softphone();
            _mySoftphone.PhoneLineStateChanged += mySoftphone_PhoneLineStateChanged;
            _filename = "ExampleCSV.csv";
            _callList = new List<CallInfo>();
        }

        void ReadCSV()
        {
            try
            {
                AssetManager assets = Application.Context.Assets;
                using (StreamReader reader = new StreamReader(assets.Open(_filename)))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        ParseCSVLineToObjectList(line);
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error occured: {0}", ex.Message);
            }
        }

        void ParseCSVLineToObjectList(string line)
        {
            try
            {
                string[] parse = line.Split(',', ';');
                _callInfo = new CallInfo(parse[0], parse[1]);
                _callList.Add(_callInfo);
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error occured: {0}", ex.Message);
            }
        }

        string ShowList()
        {
            StringBuilder listOfNumbers = new StringBuilder();
            foreach (var callListMember in _callList)
            {
                listOfNumbers.AppendLine(String.Format("Phone number: \"{0}\", message: \"{1}\".", callListMember.PhoneNumber, callListMember.Message));
            }
            return listOfNumbers.ToString();
        }

        void LoadNumbers()
        {
            _listOfNumbers.Text = ShowList();
        }

        void StartAutodialer()
        {
            _autodialer = new Autodialer(_mySoftphone, _callList, _maxConcurrentCall);
            _autodialer.Start();
        }

        /*
            Everytime the PhoneLineState changes this method will test, what is the
            current PhoneLineState.
        */

        private void mySoftphone_PhoneLineStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            if (e.State == RegState.Error || e.State == RegState.NotRegistered)
            {
                _registered = false;
                _status.Text = "Not registered";
            }
            else if (e.State == RegState.RegistrationSucceeded)
            {
                _registered = true;
                _status.Text = "Registered";
            }
        }

        /*
            The Register method will issue a SIP registration to the Ozeki Phone
            System.
        */

        private void Register()
        {
            bool registrationRequired = true;
            string displayName = Xamarin.Essentials.Preferences.Get("display_name", "");
            string userName = Xamarin.Essentials.Preferences.Get("user_name", "");
            string authenticationId = Xamarin.Essentials.Preferences.Get("authentication_id", "");
            string registerPassword = Xamarin.Essentials.Preferences.Get("register_password", "");
            string domainHost = Xamarin.Essentials.Preferences.Get("domain_host", "");
            int domainPort = Xamarin.Essentials.Preferences.Get("domain_port", 5060);

            _mySoftphone.Register(registrationRequired, displayName, userName, authenticationId,
                registerPassword, domainHost, domainPort);
        }

        /*
            This function overwrites the OnBackPressed() method of the class
            so if you press the back button, you will not be able to go back to
            the previous page. The only way you can go back to the registration
            page is if you press the logout button.
        */

        public override void OnBackPressed()
        {
            return;
        }

    }
}