﻿using System;
using Ozeki.Media;
using Ozeki.VoIP;

namespace _08_AutoDialer
{
    class CallHandler
    {
        Softphone _softphone;
        CallInfo _callInfo;
        MediaConnector _connector;
        PhoneCallAudioSender _mediaSender;

        
        public CallHandler(Softphone softphone, CallInfo callInfo)
        {
            _softphone = softphone;
            _callInfo = callInfo;
            _mediaSender = new PhoneCallAudioSender();
            _connector = new MediaConnector();
        }

        public event EventHandler Completed;

        public void Start()
        {
            var call = _softphone.CreateCall(_callInfo.PhoneNumber);
            call.CallStateChanged += OutgoingCallStateChanged;
            _mediaSender.AttachToCall(call);
            call.Start();
            Console.WriteLine("Calling " + _callInfo.PhoneNumber);
        }


        void TextToSpeech(string text)
        {
            var textToSpeech = new TextToSpeech();
            _connector.Connect(textToSpeech, _mediaSender);
            textToSpeech.AddAndStartText(text);
        }


        private void OutgoingCallStateChanged(object sender, CallStateChangedArgs e)
        {
            if (e.State == CallState.Answered)
            {
                TextToSpeech(_callInfo.Message);
            }
            else if (e.State.IsCallEnded())
            {
                var handler = Completed;
                if (handler != null)
                    handler(this, EventArgs.Empty);
            }
        }
    }
}
