﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace _08_AutoDialer
{
    class Autodialer
    {
        Softphone _softphone;
        List<CallInfo> _callList;
        int _maxConcurrentCall;
        int _currentConcurrentCall;
        List<CallHandler> _callHandlers;
        AutoResetEvent _autoResetEvent;
        object _sync;
        
        public Autodialer(Softphone softphone, List<CallInfo> callList, int maxConcurrentCall)
        {
            _sync = new object();
            _softphone = softphone;
            _callList = callList;
            _maxConcurrentCall = maxConcurrentCall;
            _callHandlers = new List<CallHandler>();
            _autoResetEvent = new AutoResetEvent(false);
        }

        public void Start()
        {
            ThreadPool.QueueUserWorkItem(o => 
            {
                foreach (var callInfo in _callList)
                {
                    if (_currentConcurrentCall < _maxConcurrentCall)
                    {
                        StartCallHandler(callInfo);
                    }
                    else
                    {
                        _autoResetEvent.WaitOne();
                        StartCallHandler(callInfo);
                    }
                }
            });
        }

        void StartCallHandler(CallInfo callInfo)
        {
            lock (_sync)
            {
                ++_currentConcurrentCall;
                var callHandler = new CallHandler(_softphone, callInfo);
                callHandler.Completed += callHandler_Completed;
                _callHandlers.Add(callHandler);

                callHandler.Start();
            }
        }

        void callHandler_Completed(object sender, EventArgs e)
        {
            lock (_sync)
            {
                _callHandlers.Remove((CallHandler) sender);
                --_currentConcurrentCall;
                _autoResetEvent.Set();
            }
        }


    }
}
