﻿using Android.App;
using Android.OS;
using Android.Text.Method;
using Android.Widget;
using Ozeki.VoIP;
using System;
using System.Text;

namespace _05_Instant_Messages
{
    [Activity(Label = "MessagingActivity")]
    public class MessagingActivity : Activity
    {
        Softphone _mySoftphone;

        EditText _recipient;
        EditText _message;
        Button _btnSend;
        TextView _btnLogOut;

        TextView _status;
        TextView _logs;
        private bool _registered;
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            SetContentView(Resource.Layout.activity_messaging);

            InitSoftphone();
            _registered = false;
            Register();

            _recipient = FindViewById<EditText>(Resource.Id.recipient);
            _message = FindViewById<EditText>(Resource.Id.message);

            _btnSend = FindViewById<Button>(Resource.Id.btnSend);
            _btnSend.Click += OnClick__btnSend;

            _status = FindViewById<TextView>(Resource.Id.status);
            _logs = FindViewById<TextView>(Resource.Id.logs);
            _logs.MovementMethod = new ScrollingMovementMethod();

            _btnLogOut = FindViewById<TextView>(Resource.Id.btnLogOut);
            _btnLogOut.Click += delegate { Xamarin.Essentials.Preferences.Clear(); StartActivity(typeof(MainActivity)); };
        }

        private void InitSoftphone()
        {
            _mySoftphone = new Softphone();
            _mySoftphone.PhoneLineStateChanged += mySoftphone_PhoneLineStateChanged;
            _mySoftphone.IncomingMessage += _mySoftphone_IncomingMessage;
        }

        private void mySoftphone_PhoneLineStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            if (e.State == RegState.Error || e.State == RegState.NotRegistered)
            {
                _registered = false;
                _status.Text = "Not registered.";
            }
            else if (e.State == RegState.RegistrationSucceeded)
            {
                _registered = true;
                _status.Text = "Registered.";
            }
        }

        private void _mySoftphone_IncomingMessage(object sender, InstantMessage message)
        {
            _logs.Text += String.Format("From {0}: {1}\n", message.Sender, message.Content); 
        }

        private void OnClick__btnSend(object sender, EventArgs e)
        {
            StringBuilder log = new StringBuilder();
            if (_registered)
            {
                if (!string.IsNullOrEmpty(_recipient.Text))
                {
                    if (!string.IsNullOrEmpty(_message.Text))
                    {
                        InstantMessage message = new InstantMessage(_recipient.Text, _message.Text);
                        _mySoftphone.SendMessage(message);
                        _logs.Text += String.Format("To {0}: {1}\n", _recipient.Text, _message.Text);
                        _recipient.Text = "";
                        _message.Text = "";
                    }
                    else
                    {
                        log.Append("You have to provide text for the message!\n");
                    }
                }
                else
                {
                    log.Append("You have to provide a recipient for the message!\n");
                }
            }
            else
            {
                log.Append("Your device is not registered! You can't send a message.\n");
            }

            _logs.Text += log.ToString();
        }

        private void Register()
        {
            bool registrationRequired = true;
            string displayName = Xamarin.Essentials.Preferences.Get("display_name", "");
            string userName = Xamarin.Essentials.Preferences.Get("user_name", "");
            string authenticationId = Xamarin.Essentials.Preferences.Get("authentication_id", "");
            string registerPassword = Xamarin.Essentials.Preferences.Get("register_password", "");
            string domainHost = Xamarin.Essentials.Preferences.Get("domain_host", "");
            int domainPort = Xamarin.Essentials.Preferences.Get("domain_port", 5060);

            _mySoftphone.Register(registrationRequired, displayName, userName, authenticationId,
                registerPassword, domainHost, domainPort);
        }

        public override void OnBackPressed()
        {
            return;
        }
    }
}