﻿using Android.App;
using Android.OS;
using Android.Widget;
using System;
using Ozeki.VoIP;

namespace _04_Call_Control
{
    [Activity(Label = "DialingActivity")]
    public class DialingActivity : Activity
    {
        private static Softphone _mySoftphone;

        Button _btnInteractions;
        TextView _btnLogOut;
        Button _btnTransfer;
        Button _btnHold;
        Button _btnRedial;
        TextView _btnClear;

        Button _btnZero;
        Button _btnOne;
        Button _btnTwo;
        Button _btnThree;
        Button _btnFour;
        Button _btnFive;
        Button _btnSix;
        Button _btnSeven;
        Button _btnEight;
        Button _btnNine;
        Button _btnStar;
        Button _btnHashtag;

        TextView _inputNumberToCall;
        TextView _status;

        CallState _callState;

        string _lastNumberCalled;
        string _numberTransferTo;
        bool _isInCall;
        bool _holding;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            SetContentView(Resource.Layout.activity_dialing);

            InitSoftphone();
            Register();

            _numberTransferTo = "1002";
            _holding = false;
            _isInCall = false;

            _btnInteractions = FindViewById<Button>(Resource.Id.btnInteractions);
            _btnInteractions.Click += OnClick__btnInteractions;

            _btnTransfer = FindViewById<Button>(Resource.Id.btnTrasfer);
            _btnTransfer.Click += OnClick__btnTransfer;

            _btnHold = FindViewById<Button>(Resource.Id.btnHold);
            _btnHold.Click += OnClick__btnHold;

            _btnRedial = FindViewById<Button>(Resource.Id.btnRedial);
            _btnRedial.Click += OnClick__btnRedial;

            _btnLogOut = FindViewById<TextView>(Resource.Id.btnLogOut);
            _btnLogOut.Click += delegate { Xamarin.Essentials.Preferences.Clear(); StartActivity(typeof(MainActivity)); };

            _btnClear = FindViewById<TextView>(Resource.Id.btnClear);
            _btnClear.Click += delegate { _inputNumberToCall.Text = ""; };

            _btnZero = FindViewById<Button>(Resource.Id.btnZero);
            _btnZero.Click += delegate { _inputNumberToCall.Text += "0"; };

            _btnOne = FindViewById<Button>(Resource.Id.btnOne);
            _btnOne.Click += delegate { _inputNumberToCall.Text += "1"; };

            _btnTwo = FindViewById<Button>(Resource.Id.btnTwo);
            _btnTwo.Click += delegate { _inputNumberToCall.Text += "2"; };

            _btnThree = FindViewById<Button>(Resource.Id.btnThree);
            _btnThree.Click += delegate { _inputNumberToCall.Text += "3"; };

            _btnFour = FindViewById<Button>(Resource.Id.btnFour);
            _btnFour.Click += delegate { _inputNumberToCall.Text += "4"; };

            _btnFive = FindViewById<Button>(Resource.Id.btnFive);
            _btnFive.Click += delegate { _inputNumberToCall.Text += "5"; };

            _btnSix = FindViewById<Button>(Resource.Id.btnSix);
            _btnSix.Click += delegate { _inputNumberToCall.Text += "6"; };

            _btnSeven = FindViewById<Button>(Resource.Id.btnSeven);
            _btnSeven.Click += delegate { _inputNumberToCall.Text += "7"; };

            _btnEight = FindViewById<Button>(Resource.Id.btnEight);
            _btnEight.Click += delegate { _inputNumberToCall.Text += "8"; };

            _btnNine = FindViewById<Button>(Resource.Id.btnNine);
            _btnNine.Click += delegate { _inputNumberToCall.Text += "9"; };

            _btnStar = FindViewById<Button>(Resource.Id.btnStar);
            _btnStar.Click += delegate { _inputNumberToCall.Text += "*"; };

            _btnHashtag = FindViewById<Button>(Resource.Id.btnHashtag);
            _btnHashtag.Click += delegate { _inputNumberToCall.Text += "#"; };

            _inputNumberToCall = FindViewById<TextView>(Resource.Id.inputNumberToCall);
            _status = FindViewById<TextView>(Resource.Id.status);
        }

        private void InitSoftphone()
        {
            _mySoftphone = new Softphone();
            _mySoftphone.PhoneLineStateChanged += mySoftphone_PhoneLineStateChanged;
            _mySoftphone.CallStateChanged += mySoftphone_CallStateChanged;
        }

        private void OnClick__btnInteractions(object sender, EventArgs e)
        {
            if (_callState == CallState.Answered || _callState == CallState.InCall)
            {
                _mySoftphone.HangUp();
                _status.Text = "Call ended";
            }
            else
            {
                string currentNumber = _inputNumberToCall.Text;
                if (!string.IsNullOrEmpty(currentNumber))
                {
                    _lastNumberCalled = currentNumber;
                    _mySoftphone.StartCall(currentNumber);
                }
            }
        }

        private void OnClick__btnTransfer(object sender, EventArgs e)
        {
            if (_isInCall)
            {
                _mySoftphone.TransferTo(_numberTransferTo);
                _status.Text = String.Format("Transfering call to: {0}", _numberTransferTo);
                _mySoftphone.HangUp();
            }
        }

        private void OnClick__btnHold(object sender, EventArgs e)
        {
            if (_holding)
            {
                _mySoftphone.HoldCall();
                _status.Text = "In Call";
                _btnHold.Text = "Hold";
            }
            else
            {
                _mySoftphone.HoldCall();
                _status.Text = "In Call - Holding";
                _btnHold.Text = "Unhold";
            }
        }

        private void OnClick__btnRedial(object sender, EventArgs e)
        {
            if (!string.IsNullOrEmpty(_lastNumberCalled))
            {
                _mySoftphone.StartCall(_lastNumberCalled);
            }
        }

        private void mySoftphone_PhoneLineStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            if (e.State == RegState.Error || e.State == RegState.NotRegistered)
            {
                _status.Text = "Not registered.";
                Register();
            }
            else if (e.State == RegState.RegistrationSucceeded)
            {
                _status.Text = "Registered.";
            }
        }

        private void mySoftphone_CallStateChanged(object sender, CallStateChangedArgs e)
        {
            _callState = e.State;



            if (e.State == CallState.LocalHeld)
            {
                _holding = true;
            }
            else
            {
                _holding = false;
            }

            if (e.State == CallState.Answered || e.State == CallState.Ringing
                || e.State == CallState.InCall || _holding)
            {
                if (e.State == CallState.InCall)
                {
                    _status.Text = "In Call";
                    _isInCall = true;
                }
                _btnInteractions.Text = "Hang up";
            }
            else if (e.State == CallState.Setup)
            {
                _status.Text = String.Format("Dialing {0}", _inputNumberToCall.Text);
                _inputNumberToCall.Text = "";
                _btnInteractions.Text = "Hang up";
            }
            else
            {
                _status.Text = "Registered.";
                _btnInteractions.Text = "Dial";
                _isInCall = false;
            }
        }

        private void Register()
        {
            bool registrationRequired = true;
            string displayName = Xamarin.Essentials.Preferences.Get("display_name", "");
            string userName = Xamarin.Essentials.Preferences.Get("user_name", "");
            string authenticationId = Xamarin.Essentials.Preferences.Get("authentication_id", "");
            string registerPassword = Xamarin.Essentials.Preferences.Get("register_password", "");
            string domainHost = Xamarin.Essentials.Preferences.Get("domain_host", "");
            int domainPort = Xamarin.Essentials.Preferences.Get("domain_port", 5060);

            _mySoftphone.Register(registrationRequired, displayName, userName, authenticationId,
                registerPassword, domainHost, domainPort);

        }

        public override void OnBackPressed()
        {
            return;
        }
    }
}