﻿using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Ozeki.Media;
using Ozeki.VoIP;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SipInviteAndroid
{
    partial class MainActivity
    {
        const string PHONE_NUMER = "100";
        const string SIP_REG_DOMAIN_HOST = "192.168.0.126";


        static ISoftPhone _softPhone;   // softphone object
        static IPhoneLine _phoneLine;   // phoneline object
        static IPhoneCall _call;

        private void CreateSoftphone()
        {
            // Create a softphone object with RTP port range 5000-10000
            _softPhone = SoftPhoneFactory.CreateSoftPhone(5000, 10000);

            // SIP account registration data, (supplied by your VoIP service provider)
            var registrationRequired = true;
            var userName = PHONE_NUMER;
            var displayName = PHONE_NUMER;
            var authenticationId = PHONE_NUMER;
            var registerPassword = PHONE_NUMER;
            var domainHost = SIP_REG_DOMAIN_HOST;
            var domainPort = 5060;

            var account = new SIPAccount(registrationRequired, displayName, userName, authenticationId, registerPassword, domainHost, domainPort);

            // Send SIP regitration request
            RegisterAccount(account);
        }

        private void RegisterAccount(SIPAccount account)
        {
            try
            {
                _phoneLine = _softPhone.CreatePhoneLine(account);
                _phoneLine.RegistrationStateChanged += line_RegStateChanged;
                _softPhone.RegisterPhoneLine(_phoneLine);
            }
            catch (Exception ex)
            {
                Log("Error during SIP registration: " + ex);
            }
        }

        private void line_RegStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            if (e.State == RegState.NotRegistered || e.State == RegState.Error)

                Log("Registration failed!");

            if (e.State == RegState.RegistrationSucceeded)
            {
                Log("Registration succeeded - Online!");
                CreateCall();
            }
        }

        private void CreateCall()
        {
            var numberToDial = "200";
            _call = _softPhone.CreateCallObject(_phoneLine, numberToDial);
            _call.CallStateChanged += Call_CallStateChanged;
            _call.Start();
        }

        private void Call_CallStateChanged(object sender, CallStateChangedArgs e)
        {
            Log("Call state:" + e.State);
        }

    }
}