﻿using Android.App;
using Android.OS;
using Android.Runtime;
using Android.Widget;
using AndroidX.AppCompat.App;
using System;

namespace SipInviteAndroid
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public partial class MainActivity : AppCompatActivity
    {
        TextView _tvLogView;
        ScrollView _svLogViewContainer;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            LoadInterfaces();

        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }

        private void LoadInterfaces()
        {
            _tvLogView = FindViewById<TextView>(Resource.Id.textViewLogView);
            _svLogViewContainer = FindViewById<ScrollView>(Resource.Id.scrollViewLogViewContainer);

            LoadCallControlInterface();
        }

        private void Log(string message)
        {
            RunOnUiThread(() =>
            {
                _tvLogView.Text += message + "\n";
                _svLogViewContainer.Post(() => _svLogViewContainer.FullScroll(Android.Views.FocusSearchDirection.Down));
            });
        }

        private void SetText(TextView textView, string text)
        {
            RunOnUiThread(() =>
            {
                textView.Text = text;
            });
        }
    }
}