﻿using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Ozeki.VoIP;

namespace SIPRegistration
{
    class SoftPhone
    {

        public EventHandler<RegistrationStateChangedArgs> PhoneLineStateChanged;

        ISoftPhone _softPhone;
        IPhoneLine _phoneLine;

        public SoftPhone()
        {
            _softPhone = SoftPhoneFactory.CreateSoftPhone(5000, 10000);
        }

        public void Register(bool registrationRequired, string displayName, string userName, string authenticationId, string registerPassword, string domainHost, int domainPort )
        {
            try
            {
                var account = new SIPAccount(registrationRequired, displayName, userName, authenticationId, registerPassword, domainHost, domainPort);

                _phoneLine = _softPhone.CreatePhoneLine(account);

                _phoneLine.RegistrationStateChanged += phoneLine_PhoneLineStateChanged;

                _softPhone.RegisterPhoneLine(_phoneLine);
            }
            catch(Exception ex)
            {
                Console.WriteLine(String.Format("Error during SIP registration: {0}", ex.ToString()));
            }
        }

        public void phoneLine_PhoneLineStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            var handler = PhoneLineStateChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }
    }
}