﻿using System;
using Android.App;
using Android.OS;
using Android.Runtime;
using Android.Views;
using AndroidX.AppCompat.Widget;
using AndroidX.AppCompat.App;
using Google.Android.Material.FloatingActionButton;
using Google.Android.Material.Snackbar;
using Android.Widget;
using Android.Text.Method;
using Ozeki.VoIP;

namespace SIPRegistration
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme.NoActionBar", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {

        private static SoftPhone _mySoftPhone;

        bool _registrationRequired;

        string _displayName;
        string _userName;
        string _authenticationID;
        string _registerPassword;
        string _domainHost;
        string _domainPort;

        TextView _logs;
        Button _btnRegister;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            SetContentView(Resource.Layout.activity_main);

            _registrationRequired = true;

            _logs = FindViewById<TextView>(Resource.Id.logs);
            _logs.MovementMethod = new ScrollingMovementMethod();

            _btnRegister = FindViewById<Button>(Resource.Id.btnRegister);
            _btnRegister.Click += BtnRegisterOnClick__Event;

            _logs.Text = String.Format("{0}{1}", _logs.Text, "This is a simple Ozeki VoIP SIP SDK demo written in C#.\n");
            _logs.Text = String.Format("{0}{1}", _logs.Text, "It can be used to register to a PBX by using SIP account.\n");

        }

        private void BtnRegisterOnClick__Event(object sender, EventArgs e)
        {
            _displayName = FindViewById<EditText>(Resource.Id.displayName).Text;
            _userName = FindViewById<EditText>(Resource.Id.userName).Text;
            _authenticationID = FindViewById<EditText>(Resource.Id.authenticationID).Text;
            _registerPassword = FindViewById<EditText>(Resource.Id.registerPassword).Text;
            _domainHost = FindViewById<EditText>(Resource.Id.domainHost).Text;
            _domainPort = FindViewById<EditText>(Resource.Id.domainPort).Text;

            if (_displayName != "" && _userName != "" && _authenticationID != "" && _registerPassword != ""
                && _domainHost != "" && _domainPort != "")
            {
                _mySoftPhone = new SoftPhone();
                _mySoftPhone.PhoneLineStateChanged += mySoftPhone_PhoneLineStateChanged;
                _mySoftPhone.Register(_registrationRequired, _displayName, _userName, _authenticationID,
                    _registerPassword, _domainHost, Int32.Parse(_domainPort));
            }
            else
            {
                _logs.Text = String.Format("{0}{1}", _logs.Text, "Please enter your credentials!.\n");
            }

        }

        private void mySoftPhone_PhoneLineStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            if (e.State == RegState.RegistrationSucceeded)
            {
                _logs.Text = String.Format("{0}{1}", _logs.Text, "Registration succeeded - Online!\n");
            }
            else if (e.State == RegState.NotRegistered)
            {
                _logs.Text = String.Format("{0}{1}", _logs.Text, "Not registered!\n");
            }
            else if (e.State == RegState.Error)
            {
                _logs.Text = String.Format("{0}{1}", _logs.Text, "Registration Error!\n");
            }
        }


    }
}
